/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.scene.layers;

import com.jogamp.opengl.GL2;
import gama.core.common.interfaces.ILayer;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.layers.OverlayLayerData;
import gama.core.runtime.IScope;
import gama.dev.DEBUG;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.scene.layers.LayerObject;

public class OverlayLayerObject
extends LayerObject {
    static {
        DEBUG.OFF();
    }

    public OverlayLayerObject(IOpenGLRenderer iOpenGLRenderer, ILayer iLayer) {
        super(iOpenGLRenderer, iLayer);
    }

    @Override
    public void computeScale(LayerObject.Trace trace) {
        trace.scale.setLocation(0.9, 0.9, 1.0);
    }

    @Override
    public void computeRotation(LayerObject.Trace trace) {
    }

    @Override
    protected void addFrame(OpenGL openGL) {
        GamaPoint gamaPoint = new GamaPoint(this.renderer.getEnvWidth(), this.renderer.getEnvHeight());
        IScope.IGraphicsScope iGraphicsScope = this.renderer.getSurface().getScope();
        IExpression iExpression = this.layer.getDefinition().getFacet(new String[]{"size"});
        OverlayLayerData overlayLayerData = (OverlayLayerData)this.layer.getData();
        if (iExpression != null) {
            gamaPoint = Cast.asPoint((IScope)iGraphicsScope, (Object)iExpression.value((IScope)iGraphicsScope));
            if (gamaPoint.x <= 1.0) {
                gamaPoint.x *= this.renderer.getEnvWidth();
            }
            if (gamaPoint.y <= 1.0) {
                gamaPoint.y *= this.renderer.getEnvHeight();
            }
        }
        openGL.pushMatrix();
        boolean bl = openGL.setObjectWireframe(false);
        try {
            openGL.setCurrentColor(overlayLayerData.getBackgroundColor((IScope)iGraphicsScope), 1.0 - this.layer.getData().getTransparency((IScope)iGraphicsScope));
            if (overlayLayerData.isRounded()) {
                openGL.translateBy(-gamaPoint.x / 2.0, -gamaPoint.y / 2.0, 0.0);
                openGL.scaleBy(1.0, 1.0, 1.0);
                this.drawRoundedRectangle(openGL.getGL(), gamaPoint.x / 2.0, -gamaPoint.y / 2.0, gamaPoint.x, gamaPoint.y, gamaPoint.x / 20.0, 40);
            } else {
                openGL.translateBy(gamaPoint.x / 2.0, -gamaPoint.y / 2.0, 0.0);
                openGL.scaleBy(gamaPoint.x, gamaPoint.y, 1.0);
                openGL.drawCachedGeometry(IShape.Type.SQUARE, null);
            }
        }
        finally {
            openGL.setObjectWireframe(bl);
            openGL.popMatrix();
        }
    }

    public void drawRoundedRectangle(GL2 gL2, double d, double d2, double d3, double d4, double d5, int n) {
        double d6;
        double d7;
        double d8;
        double d9 = Math.min(d3 / 2.0, d4 / 2.0);
        if (d5 < 0.0) {
            d5 = 0.0;
        }
        if (d5 > d9) {
            d5 = d9;
        }
        if (d5 == 0.0) {
            gL2.glBegin(7);
            gL2.glVertex2d(d, d2);
            gL2.glVertex2d(d + d3, d2);
            gL2.glVertex2d(d + d3, d2 + d4);
            gL2.glVertex2d(d, d2 + d4);
            gL2.glEnd();
            return;
        }
        double d10 = d + d5;
        double d11 = d2 + d5;
        double d12 = d + d3 - d5;
        double d13 = d2 + d5;
        double d14 = d + d3 - d5;
        double d15 = d2 + d4 - d5;
        double d16 = d + d5;
        double d17 = d2 + d4 - d5;
        gL2.glBegin(7);
        gL2.glVertex2d(d10, d11);
        gL2.glVertex2d(d12, d13);
        gL2.glVertex2d(d14, d15);
        gL2.glVertex2d(d16, d17);
        gL2.glVertex2d(d10, d2);
        gL2.glVertex2d(d12, d2);
        gL2.glVertex2d(d12, d13);
        gL2.glVertex2d(d10, d11);
        gL2.glVertex2d(d16, d17);
        gL2.glVertex2d(d14, d15);
        gL2.glVertex2d(d14, d2 + d4);
        gL2.glVertex2d(d16, d2 + d4);
        gL2.glVertex2d(d, d11);
        gL2.glVertex2d(d10, d11);
        gL2.glVertex2d(d16, d17);
        gL2.glVertex2d(d, d17);
        gL2.glVertex2d(d12, d13);
        gL2.glVertex2d(d + d3, d13);
        gL2.glVertex2d(d + d3, d15);
        gL2.glVertex2d(d14, d15);
        gL2.glEnd();
        float f = (float)(1.5707963267948966 / (double)n);
        gL2.glBegin(6);
        gL2.glVertex2d(d10, d11);
        int n2 = 0;
        while (n2 <= n) {
            d8 = (float)Math.PI + (float)n2 * f;
            d7 = d10 + d5 * Math.cos(d8);
            d6 = d11 + d5 * Math.sin(d8);
            gL2.glVertex2d(d7, d6);
            ++n2;
        }
        gL2.glEnd();
        gL2.glBegin(6);
        gL2.glVertex2d(d12, d13);
        n2 = 0;
        while (n2 <= n) {
            d8 = 4.712389f + (float)n2 * f;
            d7 = d12 + d5 * Math.cos(d8);
            d6 = d13 + d5 * Math.sin(d8);
            gL2.glVertex2d(d7, d6);
            ++n2;
        }
        gL2.glEnd();
        gL2.glBegin(6);
        gL2.glVertex2d(d14, d15);
        n2 = 0;
        while (n2 <= n) {
            d8 = (float)n2 * f;
            d7 = d14 + d5 * Math.cos(d8);
            d6 = d15 + d5 * Math.sin(d8);
            gL2.glVertex2d(d7, d6);
            ++n2;
        }
        gL2.glEnd();
        gL2.glBegin(6);
        gL2.glVertex2d(d16, d17);
        n2 = 0;
        while (n2 <= n) {
            d8 = 1.5707964f + (float)n2 * f;
            d7 = d16 + d5 * Math.cos(d8);
            d6 = d17 + d5 * Math.sin(d8);
            gL2.glVertex2d(d7, d6);
            ++n2;
        }
        gL2.glEnd();
    }

    @Override
    public boolean isOverlay() {
        return true;
    }

    @Override
    protected void computeZ(LayerObject.Trace trace) {
    }

    @Override
    protected void prepareDrawing(OpenGL openGL, LayerObject.Trace trace) {
        double d = openGL.getViewHeight();
        double d2 = openGL.getViewWidth();
        double d3 = d2 / (d == 0.0 ? 1.0 : d);
        double d4 = openGL.getWorldHeight();
        double d5 = openGL.getWorldWidth();
        double d6 = d4 > d5 ? d4 : d5;
        openGL.pushIdentity(5889);
        if (d3 >= 1.0) {
            openGL.getGL().glOrtho(0.0, d6 * d3, -d6, 0.0, -1.0, 1.0);
        } else {
            openGL.getGL().glOrtho(0.0, d6, -d6 / d3, 0.0, -1.0, 1.0);
        }
        super.prepareDrawing(openGL, trace);
    }

    @Override
    protected boolean hasDepth() {
        return false;
    }

    @Override
    protected void doDrawing(OpenGL openGL) {
        this.drawObjects(openGL, this.currentList, this.alpha, false);
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    protected void stopDrawing(OpenGL openGL) {
        openGL.resumeZTranslation();
        openGL.pop(5888);
        openGL.pop(5889);
    }
}

