/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.display.opengl.renderer.helpers;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.Scaling3D;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.LayeredDisplayData;
import gama.core.util.GamaColor;
import gama.ui.display.opengl.OpenGL;
import gama.ui.display.opengl.renderer.IOpenGLRenderer;
import gama.ui.display.opengl.renderer.helpers.AbstractRendererHelper;
import gama.ui.display.opengl.renderer.shaders.AbstractPostprocessingShader;
import gama.ui.display.opengl.renderer.shaders.FrameBufferObject;
import gama.ui.display.opengl.renderer.shaders.KeystoneShaderProgram;
import gama.ui.shared.utils.DPIHelper;
import java.awt.Color;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.eclipse.swt.widgets.Monitor;
import org.locationtech.jts.geom.Envelope;

public class KeystoneHelper
extends AbstractRendererHelper {
    private final AbstractRendererHelper.Pass finishingHelper = this::finishRenderToTexture;
    private FrameBufferObject fboScene;
    protected boolean drawKeystoneHelper = false;
    protected int cornerSelected = -1;
    protected int cornerHovered = -1;
    private int uvMappingBufferIndex;
    private int verticesBufferIndex;
    private int indexBufferIndex;
    private KeystoneShaderProgram shader;
    private boolean worldCorners = false;
    private static final Color[] FILL_COLORS = new Color[]{GamaColor.NamedGamaColor.get((String)"gamared").withAlpha(0.3), GamaColor.NamedGamaColor.get((String)"gamablue").withAlpha(0.3), GamaColor.NamedGamaColor.get((String)"black").withAlpha(0.3)};
    final IntBuffer ibIdxBuff;

    public KeystoneHelper(IOpenGLRenderer iOpenGLRenderer) {
        super(iOpenGLRenderer);
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[4] = 2;
        nArray[5] = 3;
        this.ibIdxBuff = Buffers.newDirectIntBuffer((int[])nArray);
    }

    int getViewWidth() {
        return this.getRenderer().getViewWidth();
    }

    int getViewHeight() {
        return this.getRenderer().getViewHeight();
    }

    @Override
    public void initialize() {
    }

    public int getCornerSelected() {
        return this.cornerSelected;
    }

    public GamaPoint[] getCoords() {
        return this.getData().getKeystone().toCoordinateArray();
    }

    public GamaPoint getKeystoneCoordinates(int n) {
        return this.getCoords()[n];
    }

    public void startDrawHelper() {
        this.drawKeystoneHelper = true;
        this.cornerSelected = -1;
    }

    public void stopDrawHelper() {
        this.drawKeystoneHelper = false;
    }

    public void switchCorners() {
        this.worldCorners = !LayeredDisplayData.KEYSTONE_IDENTITY.getEnvelope().covers((Envelope)this.getData().getKeystone().getEnvelope());
    }

    public void dispose() {
        GL2 gL2 = this.getGL();
        if (this.fboScene != null) {
            this.fboScene.cleanUp();
        }
        if (gL2 != null) {
            gL2.glDeleteBuffers(3, new int[]{this.indexBufferIndex, this.verticesBufferIndex, this.uvMappingBufferIndex}, 0);
        }
    }

    public void beginRenderToTexture() {
        GL2 gL2 = this.getGL();
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glClear(17664);
        if (this.fboScene == null) {
            this.fboScene = new FrameBufferObject(gL2, this.getViewWidth(), this.getViewHeight());
        }
        this.fboScene.bindFrameBuffer();
    }

    private void drawRectangle(OpenGL openGL, double d, double d2, double d3, double d4, double d5, Color color) {
        openGL.pushMatrix();
        openGL.translateBy(d, d2, d2);
        openGL.setCurrentColor(color);
        openGL.scaleBy(Scaling3D.of((double)d4, (double)d5, (double)1.0));
        openGL.drawCachedGeometry(IShape.Type.SQUARE, null);
        openGL.popMatrix();
    }

    private void drawKeystoneMarks() {
        ICoordinates iCoordinates;
        OpenGL openGL = this.getOpenGL();
        GL2 gL2 = this.getGL();
        int n2 = this.getViewWidth();
        int n3 = this.getViewHeight();
        double d = 1.0 / (double)n2;
        double d2 = 1.0 / (double)n3;
        double[] dArray = this.getOpenGL().getPixelWidthAndHeightOfWorld();
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = d3 / (double)n2;
        double d9 = d4 / (double)n3;
        double d10 = 1.0 - d5;
        double d11 = 1.0 - d9;
        double d12 = d2 * 38.0;
        if (!this.worldCorners) {
            iCoordinates = LayeredDisplayData.KEYSTONE_IDENTITY;
        } else {
            iCoordinates = ICoordinates.ofLength((int)4);
            iCoordinates.at(0).setLocation(d10, d11, 0.0);
            iCoordinates.at(1).setLocation(d10, 1.0 - d11, 0.0);
            iCoordinates.at(2).setLocation(1.0 - d10, 1.0 - d11, 0.0);
            iCoordinates.at(3).setLocation(1.0 - d10, d11, 0.0);
        }
        openGL.pushIdentity(5889);
        gL2.glOrtho(0.0, 1.0, 0.0, 1.0, 1.0, -1.0);
        boolean bl = openGL.setObjectLighting(false);
        openGL.push(5888);
        iCoordinates.visit((n, d6, d7, d8) -> {
            double d9;
            String string = this.floor4Digit(this.getCoords()[n].x) + "," + this.floor4Digit(this.getCoords()[n].y);
            int n2 = openGL.getGlut().glutBitmapLength(8, string);
            double d10 = d * (double)(n2 + 20);
            int n3 = n == this.cornerSelected ? 0 : (n == this.cornerHovered ? 1 : 2);
            double d11 = d6 + (n == 0 || n == 1 ? d10 / 2.0 : -d10 / 2.0);
            double d12 = d7 + (n == 0 || n == 3 ? d12 / 2.0 : -d12 / 2.0);
            this.drawRectangle(openGL, d11, d12, d8, d10, d12, FILL_COLORS[n3]);
            gL2.glColor3d(1.0, 1.0, 1.0);
            double d13 = n == 0 || n == 1 ? 10.0 * d + (this.worldCorners ? d10 : 0.0) : (d9 = 1.0 - d10 + 10.0 * d - (this.worldCorners ? d10 : 0.0));
            double d14 = n == 0 || n == 3 ? 12.0 * d2 + (this.worldCorners ? d11 : 0.0) : 1.0 - d12 + 12.0 * d2 - (this.worldCorners ? d11 : 0.0);
            openGL.getGL().glRasterPos2d(d9, d14);
            openGL.getGlut().glutBitmapString(8, string);
        }, 4, true);
        openGL.pop(5888);
        openGL.setObjectLighting(bl);
        openGL.pop(5889);
    }

    private double floor4Digit(double d) {
        double d2 = d * 1000.0;
        d2 = Math.round(d2);
        return d2 /= 1000.0;
    }

    public void finishRenderToTexture() {
        if (this.drawKeystoneHelper) {
            this.drawKeystoneMarks();
        }
        KeystoneShaderProgram keystoneShaderProgram = this.getShader();
        if (this.fboScene != null) {
            this.fboScene.unbindCurrentFrameBuffer();
            keystoneShaderProgram.start();
            this.prepareShader(keystoneShaderProgram);
            this.createScreenSurface();
            GL2 gL2 = this.getGL();
            gL2.glDrawElements(4, 6, 5125, 0L);
            keystoneShaderProgram.stop();
            gL2.glBindBuffer(34963, 0);
            gL2.glBindBuffer(34962, 0);
        }
    }

    public KeystoneShaderProgram getShader() {
        GL2 gL2 = this.getGL();
        if (this.shader == null) {
            this.shader = new KeystoneShaderProgram(gL2, "keystoneVertexShader2", "keystoneFragmentShader2");
            int[] nArray = new int[3];
            gL2.glGenBuffers(3, nArray, 0);
            this.uvMappingBufferIndex = nArray[0];
            this.verticesBufferIndex = nArray[1];
            this.indexBufferIndex = nArray[2];
        }
        return this.shader;
    }

    private void prepareShader(AbstractPostprocessingShader abstractPostprocessingShader) {
        abstractPostprocessingShader.storeTextureID(this.fboScene.getFBOTexture());
    }

    public void createScreenSurface() {
        GL2 gL2 = this.getGL();
        ICoordinates iCoordinates = this.getData().getKeystone();
        float[] fArray = new float[]{(float)iCoordinates.at((int)0).x * 2.0f - 1.0f, (float)(iCoordinates.at((int)0).y * 2.0 - 1.0)};
        float[] fArray2 = new float[]{(float)iCoordinates.at((int)1).x * 2.0f - 1.0f, (float)iCoordinates.at((int)1).y * 2.0f - 1.0f};
        float[] fArray3 = new float[]{(float)iCoordinates.at((int)2).x * 2.0f - 1.0f, (float)iCoordinates.at((int)2).y * 2.0f - 1.0f};
        float f = (fArray3[0] - fArray[0]) / 2.0f;
        float[] fArray4 = new float[]{(float)iCoordinates.at((int)3).x * 2.0f - 1.0f, (float)iCoordinates.at((int)3).y * 2.0f - 1.0f};
        float f2 = (fArray4[1] - fArray2[1]) / 2.0f;
        float f3 = (fArray3[1] - fArray[1]) / 2.0f;
        float f4 = (fArray4[0] - fArray2[0]) / 2.0f;
        float f5 = f * f2 - f3 * f4;
        if (f5 != 0.0f) {
            float f6 = (fArray[1] - fArray2[1]) / 2.0f;
            float f7 = (fArray[0] - fArray2[0]) / 2.0f;
            float f8 = (f * f6 - f3 * f7) / f5;
            float f9 = (f4 * f6 - f2 * f7) / f5;
            float f10 = 1.0f / (1.0f - f9);
            float f11 = 1.0f / (1.0f - f8);
            float f12 = 1.0f / f9;
            float f13 = 1.0f / f8;
            float[] fArray5 = new float[]{fArray[0], fArray[1], 1.0f, fArray2[0], fArray2[1], 0.0f, fArray3[0], fArray3[1], 0.0f, fArray4[0], fArray4[1], 1.0f};
            float[] fArray6 = new float[]{0.0f, 1.0f * f10, 0.0f, f10, 0.0f, 0.0f, 0.0f, f11, 1.0f * f12, 0.0f, 0.0f, f12, 1.0f * f13, 1.0f * f13, 0.0f, f13};
            this.storeAttributes(0, this.verticesBufferIndex, 3, fArray5);
            this.storeAttributes(3, this.uvMappingBufferIndex, 4, fArray6);
        }
        this.getOpenGL().bindTexture(this.fboScene.getFBOTexture());
        gL2.glBindBuffer(34963, this.indexBufferIndex);
        gL2.glBufferData(34963, 24L, (Buffer)this.ibIdxBuff, 35044);
        this.ibIdxBuff.rewind();
    }

    private void storeAttributes(int n, int n2, int n3, float[] fArray) {
        GL2 gL2 = this.getGL();
        gL2.glBindBuffer(34962, n2);
        gL2.glVertexAttribPointer(n, n3, 5126, false, 0, 0L);
        int n4 = fArray.length * 4;
        gL2.glBufferData(34962, (long)n4, null, 35044);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer((float[])fArray);
        gL2.glBufferSubData(34962, 0L, (long)n4, (Buffer)floatBuffer);
        gL2.glEnableVertexAttribArray(n);
    }

    public void setCornerSelected(int n) {
        this.cornerSelected = n;
    }

    public void resetCorner(int n) {
        this.setKeystoneCoordinates(n, LayeredDisplayData.KEYSTONE_IDENTITY.at(n));
        this.cornerSelected = -1;
        this.cornerHovered = -1;
    }

    public int cornerSelected(GamaPoint gamaPoint) {
        if (gamaPoint.x < (double)this.getViewWidth() / 2.0) {
            if (gamaPoint.y < (double)this.getViewHeight() / 2.0) {
                return 1;
            }
            return 0;
        }
        if (gamaPoint.y < (double)this.getViewHeight() / 2.0) {
            return 2;
        }
        return 3;
    }

    public int cornerHovered(GamaPoint gamaPoint) {
        if (gamaPoint.x < (double)this.getViewWidth() / 2.0) {
            if (gamaPoint.y < (double)this.getViewHeight() / 2.0) {
                return 1;
            }
            return 0;
        }
        if (gamaPoint.y < (double)this.getViewHeight() / 2.0) {
            return 2;
        }
        return 3;
    }

    public void setCornerHovered(int n) {
        this.cornerHovered = n;
    }

    public void setKeystoneCoordinates(int n, GamaPoint gamaPoint) {
        this.getData().getKeystone().replaceWith(n, gamaPoint.x, gamaPoint.y, gamaPoint.z);
        this.switchCorners();
        this.getData().setKeystone(this.getData().getKeystone());
    }

    public boolean isActive() {
        return this.drawKeystoneHelper;
    }

    public AbstractRendererHelper.Pass render() {
        if (this.drawKeystoneHelper || this.getData().isKeystoneDefined()) {
            this.beginRenderToTexture();
            return this.finishingHelper;
        }
        return null;
    }

    public void reshape(int n, int n2) {
        if (this.fboScene != null) {
            this.fboScene.setDisplayDimensions(DPIHelper.autoScaleUp((Monitor)this.renderer.getCanvas().getMonitor(), (int)n), DPIHelper.autoScaleUp((Monitor)this.renderer.getCanvas().getMonitor(), (int)n2));
        }
    }
}

