/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editbox;

import gaml.compiler.ui.editbox.AbstractBoxBuilder;
import gaml.compiler.ui.editbox.Box;
import java.util.LinkedList;
import java.util.List;

public class BoxBuilderImpl
extends AbstractBoxBuilder {
    protected List<Box> boxes;
    protected Box currentbox;
    protected boolean emptyPrevLine;
    protected boolean lineHasStartTab;

    @Override
    public List<Box> build() {
        this.boxes = new LinkedList<Box>();
        int n = this.text.length() - 1;
        this.currentbox = this.newbox(0, n, -1, null);
        this.boxes.clear();
        this.emptyPrevLine = false;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        this.lineHasStartTab = false;
        boolean bl2 = true;
        this.checkCarret();
        int n4 = 0;
        while (n4 <= n) {
            char c = this.text.charAt(n4);
            boolean bl3 = Character.isWhitespace(c) && n4 != this.caretOffset;
            boolean bl4 = bl2 = bl2 && bl3;
            if (c == '\n' || n4 == n) {
                if (bl) {
                    n2 = n4;
                }
                this.addLine(n2, n4, n3, bl2);
                bl = true;
                n3 = 0;
                n2 = n4;
                this.lineHasStartTab = false;
                bl2 = true;
            } else if (bl) {
                if (bl3) {
                    if (c == '\t') {
                        n3 += this.tabSize;
                        this.lineHasStartTab = true;
                    } else {
                        ++n3;
                    }
                } else {
                    n2 = n4;
                    bl = false;
                }
            }
            ++n4;
        }
        return this.boxes;
    }

    private void checkCarret() {
        if (this.caretOffset < 0) {
            return;
        }
        if (this.caretOffset > 0 && this.text.charAt(this.caretOffset - 1) == '\n') {
            this.caretOffset = -1;
            return;
        }
        int n = this.text.length();
        int n2 = this.caretOffset;
        while (n2 < n) {
            char c = this.text.charAt(n2);
            if (!Character.isWhitespace(c)) {
                this.caretOffset = -1;
                return;
            }
            if (c == '\n') {
                return;
            }
            ++n2;
        }
    }

    protected void addLine(int n, int n2, int n3, boolean bl) {
        if (!bl) {
            this.addbox0(n, n2, n3);
        }
        this.emptyPrevLine = bl;
    }

    protected void addbox0(int n, int n2, int n3) {
        if (n3 == this.currentbox.offset) {
            if (this.emptyPrevLine && this.currentbox.parent != null) {
                this.currentbox = this.newbox(n, n2, n3, this.currentbox.parent);
                this.updateParentEnds(this.currentbox);
            } else if (n2 > this.currentbox.end) {
                this.currentbox.end = n2;
                if (this.currentbox.tabsStart < 0 && this.lineHasStartTab) {
                    this.currentbox.tabsStart = n;
                }
                this.updateMaxEndOffset(n, this.currentbox);
                this.updateParentEnds(this.currentbox);
            }
        } else if (n3 > this.currentbox.offset) {
            this.currentbox = this.newbox(n, n2, n3, this.currentbox);
            this.updateParentEnds(this.currentbox);
        } else if (this.currentbox.parent != null) {
            this.currentbox = this.currentbox.parent;
            this.addbox0(n, n2, n3);
        }
    }

    protected void updateMaxEndOffset(int n, Box box) {
        int n2 = box.end - n + box.offset;
        if (n2 >= box.maxLineLen) {
            box.maxLineLen = n2;
            box.maxEndOffset = box.end;
        }
    }

    protected void updateParentEnds(Box box) {
        Box box2 = box.parent;
        while (box2 != null && box2.end < box.end) {
            box2.end = box.end;
            if (box2.maxLineLen <= box.maxLineLen) {
                box2.maxEndOffset = box.maxEndOffset;
                box2.maxLineLen = box.maxLineLen;
            }
            box2 = box2.parent;
        }
    }

    protected Box newbox(int n, int n2, int n3, Box box) {
        Box box2 = new Box();
        box2.end = n2;
        box2.start = n;
        box2.offset = n3;
        box2.parent = box;
        box2.maxLineLen = n2 - n + n3;
        box2.maxEndOffset = n2;
        int n4 = box2.level = box != null ? box.level + 1 : -1;
        if (this.lineHasStartTab) {
            box2.tabsStart = n;
        }
        if (box != null) {
            box.hasChildren = true;
        }
        this.boxes.add(box2);
        return box2;
    }
}

