/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editbox;

import gaml.compiler.ui.editbox.BoxBuilderImpl;
import java.util.LinkedList;

public class MarkupBoxBuilder
extends BoxBuilderImpl {
    @Override
    protected void addLine(int n, int n2, int n3, boolean bl) {
        if (!bl) {
            this.addbox0(n, n2, n3);
            this.emptyPrevLine = this.isClosingTag0(n, n2);
        } else {
            this.emptyPrevLine = bl;
        }
    }

    protected boolean isClosingTag0(int n, int n2) {
        String string = this.text.substring(n, n2).trim();
        return this.countCloseOpen(string) < 0;
    }

    protected boolean isClosingCurrentTag(int n, int n2) {
        String string = this.text.substring(n, n2).trim();
        if (string.startsWith("</") && string.endsWith(">")) {
            String string2 = "<" + string.substring(2, string.length() - 1);
            int n3 = 0;
            while (n3 < string2.length()) {
                if (this.text.charAt(this.currentbox.start + n3) != string2.charAt(n3)) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void addbox0(int n, int n2, int n3) {
        if (!this.emptyPrevLine && this.isOpenTag(n, n2)) {
            this.emptyPrevLine = true;
        } else if (this.emptyPrevLine && this.isClosingCurrentTag(n, n2)) {
            this.emptyPrevLine = false;
        }
        super.addbox0(n, n2, n3);
    }

    protected boolean isOpenTag(int n, int n2) {
        String string = this.text.substring(n, n2).trim();
        if (string.length() < 3) {
            return false;
        }
        char c = string.charAt(1);
        return string.startsWith("<") && c != '/' && c != '?' && c != '!' && c != '%' && this.countCloseOpen(string) > 0;
    }

    protected int countCloseOpen(String string) {
        TokenStack tokenStack = this.processTags(string);
        return tokenStack.result();
    }

    protected TokenStack processTags(String string) {
        TokenStack tokenStack = new TokenStack();
        String string2 = null;
        int n = 0;
        while (n < string.length() - 1) {
            if (string.startsWith("</", n)) {
                string2 = this.getWord(string, n + 2);
                tokenStack.addClosing(string2);
            } else if (string.startsWith("/>", n)) {
                tokenStack.addClosing(null);
            } else if (string.startsWith("<", n) && Character.isLetterOrDigit(string.charAt(n + 1))) {
                string2 = this.getWord(string, n + 1);
                tokenStack.addOpening(string2);
            }
            ++n;
        }
        return tokenStack;
    }

    protected String getWord(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (Character.isWhitespace(c) || c == '>' || c == '/') break;
            stringBuilder.append(c);
            ++n2;
        }
        return stringBuilder.toString();
    }

    class TokenStack {
        private static final String CLOSING = ">";
        LinkedList<String> tokens = new LinkedList();

        TokenStack() {
        }

        public void addClosing(String string) {
            if (string == null) {
                if (!this.tokens.isEmpty() && !CLOSING.equals(this.tokens.getLast())) {
                    this.tokens.removeLast();
                } else {
                    this.tokens.add(CLOSING);
                }
            } else if (!this.tokens.contains(string)) {
                this.tokens.add(CLOSING);
            } else {
                while (!string.equals(this.tokens.removeLast())) {
                }
            }
        }

        public int result() {
            if (this.tokens.isEmpty()) {
                return 0;
            }
            if (CLOSING.equals(this.tokens.getLast())) {
                return -1;
            }
            return 1;
        }

        public void addOpening(String string) {
            this.tokens.add(string);
        }
    }
}

