/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.contentassist;

import com.google.common.base.Function;
import com.google.inject.Inject;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.factories.DescriptionFactory;
import gaml.compiler.services.GamlGrammarAccess;
import gaml.compiler.ui.contentassist.AbstractGamlProposalProvider;
import gaml.compiler.ui.labeling.GamlLabelProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class GamlProposalProvider
extends AbstractGamlProposalProvider {
    static Image typeImage = ImageDescriptor.createFromFile(GamlProposalProvider.class, (String)"/icons/_type.png").createImage();
    static Image varImage = ImageDescriptor.createFromFile(GamlProposalProvider.class, (String)"/icons/_var.png").createImage();
    static Image actionImage = ImageDescriptor.createFromFile(GamlProposalProvider.class, (String)"/icons/_action.png").createImage();
    static final List<BuiltInProposal> proposals = new ArrayList<BuiltInProposal>();
    static final Set<String> fields = new HashSet<String>();
    static final Set<String> vars = new HashSet<String>();
    static final Set<String> actions = new HashSet<String>();
    static final Set<String> types = new HashSet<String>();
    static final Set<String> skills = new HashSet<String>();
    static final Set<String> constants = new HashSet<String>();
    static final Set<String> units = new HashSet<String>();
    static final Set<String> statements = new HashSet<String>();
    static final Set<String> facets = new HashSet<String>();
    @Inject
    GamlLabelProvider provider;
    @Inject
    private GamlGrammarAccess ga;

    protected String getDisplayString(EObject eObject, String string, String string2) {
        String string3 = string;
        if (string3 == null) {
            string3 = string2;
        }
        if (string3 == null) {
            if (eObject == null) {
                return null;
            }
            string3 = this.provider.getText(eObject);
        }
        return string3;
    }

    public void createProposals(ContentAssistContext contentAssistContext, ICompletionProposalAcceptor iCompletionProposalAcceptor) {
        EObject eObject = contentAssistContext.getCurrentNode().getGrammarElement();
        if (eObject == this.ga.getML_COMMENTRule() || eObject == this.ga.getSL_COMMENTRule()) {
            return;
        }
        this.addBuiltInElements(contentAssistContext, iCompletionProposalAcceptor);
        super.createProposals(contentAssistContext, iCompletionProposalAcceptor);
    }

    protected ConfigurableCompletionProposal doCreateProposal(String string, StyledString styledString, Image image, int n, ContentAssistContext contentAssistContext) {
        return super.doCreateProposal(string, styledString, image, n, contentAssistContext);
    }

    private void addBuiltInElements(ContentAssistContext contentAssistContext, ICompletionProposalAcceptor iCompletionProposalAcceptor) {
        SymbolProto symbolProto;
        if (proposals.isEmpty()) {
            BuiltInProposal builtInProposal;
            for (String object : DescriptionFactory.getStatementProtoNames()) {
                symbolProto = DescriptionFactory.getProto((String)object, null);
                statements.add(object);
                builtInProposal = new BuiltInProposal(object, new StyledString(object + " (Statement)"), null);
                proposals.add(builtInProposal);
                builtInProposal.setDoc(symbolProto.getDocumentation().toString());
            }
            for (String string : DescriptionFactory.getVarProtoNames()) {
                symbolProto = DescriptionFactory.getVarProto((String)string, null);
                statements.add(string);
                builtInProposal = new BuiltInProposal(string, new StyledString(string + " (Declaration)"), null);
                proposals.add(builtInProposal);
                builtInProposal.setDoc(symbolProto.getDocumentation().toString());
            }
        }
        for (BuiltInProposal builtInProposal : proposals) {
            symbolProto = this.createCompletionProposal(builtInProposal.name, builtInProposal.title, builtInProposal.image, 1000, contentAssistContext.getPrefix(), contentAssistContext);
            if (symbolProto == null) continue;
            if (builtInProposal.documentation != null) {
                ((ConfigurableCompletionProposal)symbolProto).setAdditionalProposalInfo((Object)builtInProposal.documentation);
            }
            iCompletionProposalAcceptor.accept((ICompletionProposal)symbolProto);
        }
    }

    protected ConfigurableCompletionProposal doCreateProposal(String string, StyledString styledString, Image image, int n, int n2) {
        return new GamlCompletionProposal(string, n, n2, string.length(), image, styledString, null, null);
    }

    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String string, ContentAssistContext contentAssistContext) {
        return new GamlProposalCreator(contentAssistContext, string, this.getQualifiedNameConverter());
    }

    protected boolean isValidProposal(String string, String string2, ContentAssistContext contentAssistContext) {
        if (".".equals(string2)) {
            return !types.contains(string) && !units.contains(string) && !constants.contains(string) && !skills.contains(string) && this.isValidProposal(string, "", contentAssistContext);
        }
        return super.isValidProposal(string, string2, contentAssistContext);
    }

    static class BuiltInProposal {
        String name;
        StyledString title;
        Image image;
        String documentation;

        public BuiltInProposal(String string, StyledString styledString, Image image) {
            this.name = string;
            this.title = styledString;
            this.image = image;
        }

        public void setDoc(String string) {
            this.documentation = string;
        }
    }

    static class GamlCompletionProposal
    extends ConfigurableCompletionProposal {
        public GamlCompletionProposal(String string, int n, int n2, int n3, Image image, StyledString styledString, IContextInformation iContextInformation, String string2) {
            super(string, n, n2, n3, image, styledString, iContextInformation, string2);
        }

        public IInformationControlCreator getInformationControlCreator() {
            return shell -> new DefaultInformationControl(shell, true);
        }
    }

    class GamlProposalCreator
    extends AbstractJavaBasedContentProposalProvider.DefaultProposalCreator {
        ContentAssistContext context;

        public GamlProposalCreator(ContentAssistContext contentAssistContext, String string, IQualifiedNameConverter iQualifiedNameConverter) {
            super((AbstractJavaBasedContentProposalProvider)GamlProposalProvider.this, contentAssistContext, string, iQualifiedNameConverter);
            this.context = contentAssistContext;
        }

        public ICompletionProposal apply(IEObjectDescription iEObjectDescription) {
            ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)super.apply(iEObjectDescription);
            boolean bl = false;
            String string = iEObjectDescription.getUserData("doc");
            String string2 = iEObjectDescription.getUserData("title");
            if (string == null) {
                string = "Not documented yet";
            }
            if (configurableCompletionProposal != null) {
                configurableCompletionProposal.setAdditionalProposalInfo((Object)("<b>" + string2 + "</b><p/><p>" + string + "</p>"));
                String string3 = iEObjectDescription.getUserData("type");
                if (string3 != null) {
                    configurableCompletionProposal.setDisplayString(configurableCompletionProposal.getDisplayString().concat(" (Built-in " + string3 + ") "));
                    if ("operator".equals(string3)) {
                        bl = true;
                        configurableCompletionProposal.setImage(actionImage);
                    } else if ("variable".equals(string3) || "field".equals(string3)) {
                        configurableCompletionProposal.setImage(varImage);
                    } else if ("action".equals(string3)) {
                        configurableCompletionProposal.setImage(actionImage);
                    } else if ("unit".equals(string3)) {
                        bl = true;
                        configurableCompletionProposal.setImage(null);
                    } else if ("type".equals(string3)) {
                        bl = true;
                        configurableCompletionProposal.setImage(typeImage);
                    }
                    configurableCompletionProposal.setPriority(1000);
                }
            }
            if (".".equals(this.context.getPrefix())) {
                if (bl) {
                    return null;
                }
                if (configurableCompletionProposal != null && configurableCompletionProposal.getPriority() > 500) {
                    configurableCompletionProposal.setPriority(200);
                }
            }
            return configurableCompletionProposal;
        }
    }
}

