/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.decorators;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import gama.ui.shared.resources.GamaIcon;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.IImageHelper;

@Singleton
public class GamlImageHelper
implements IImageHelper,
IImageHelper.IImageDescriptorHelper {
    private static final String path = "gaml";
    private final Map<ImageDescriptor, Image> registry = Maps.newHashMapWithExpectedSize((int)10);

    public boolean exist(String string) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"gama.ui.shared", (String)("/icons/" + string + ".png")) != null;
    }

    public ImageDescriptor getImageDescriptor(String string) {
        String string2 = string;
        if (string2.endsWith(".png")) {
            string2 = string2.replace(".png", "");
        }
        if (this.exist("gaml/" + string2)) {
            return GamaIcon.named((String)("gaml/" + string2)).descriptor();
        }
        return GamaIcon.named((String)"gaml/_agent").descriptor();
    }

    public ImageDescriptor getImageDescriptor(Image image) {
        for (Map.Entry<ImageDescriptor, Image> object2 : this.registry.entrySet()) {
            if (!object2.getValue().equals((Object)image)) continue;
            return object2.getKey();
        }
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        this.registry.put(imageDescriptor, image);
        return imageDescriptor;
    }

    public Image getImage(String string) {
        String string2 = string;
        if (string2.endsWith(".png")) {
            string2 = string2.replace(".png", "");
        }
        if (this.exist("gaml/" + string2)) {
            return GamaIcon.named((String)("gaml/" + string2)).image();
        }
        return GamaIcon.named((String)"gaml/_agent").image();
    }

    public Image getImage(ImageDescriptor imageDescriptor) {
        Image image;
        ImageDescriptor imageDescriptor2 = imageDescriptor;
        if (imageDescriptor2 == null) {
            imageDescriptor2 = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((image = this.registry.get(imageDescriptor2)) != null) {
            return image;
        }
        image = imageDescriptor2.createImage();
        if (image != null) {
            this.registry.put(imageDescriptor2, image);
        }
        return image;
    }
}

