/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editbox;

import gama.core.runtime.PlatformHelper;
import gaml.compiler.ui.editbox.Box;
import gaml.compiler.ui.editbox.IBoxBuilder;
import gaml.compiler.ui.editbox.IBoxDecorator;
import gaml.compiler.ui.editbox.IBoxProvider;
import gaml.compiler.ui.editbox.IBoxSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;

public class BoxDecoratorImpl
implements IBoxDecorator {
    protected static final int ROUND_BOX_ARC = 5;
    protected IBoxProvider provider;
    protected boolean visible;
    protected IBoxSettings settings;
    protected StyledText boxText;
    protected BoxKeyListener boxKey;
    protected BoxModifyListener boxModify;
    protected BoxPaintListener boxPaint;
    protected BoxMouseMoveListener boxMouseMove;
    protected BoxMouseTrackListener boxMouseTrack;
    protected BoxTextChangeListener boxTextChange;
    protected BoxMouseClickListener boxMouseClick;
    protected FillBoxMouseClick fillMouseClick;
    protected SettingsChangeListener settingsChangeListener;
    protected RGB oldBackground;
    protected int oldIndent;
    protected boolean decorated;
    protected List<Box> boxes;
    protected boolean setCaretOffset;
    protected String builderName;
    protected IBoxBuilder builder;
    protected Box currentBox;
    protected Point oldCaretLoc;
    protected int oldXOffset = -1;
    protected int oldYOffset = -1;
    protected Rectangle oldClientArea;
    protected int fillBoxStart = -1;
    protected int fillBoxEnd = -1;
    protected int fillBoxLevel = -1;
    protected int stateMask;
    public boolean keyPressed;
    protected int charCount;

    @Override
    public void enableUpdates(boolean bl) {
        boolean bl2 = bl && !this.visible;
        this.visible = bl;
        if (bl2) {
            this.boxes = null;
            this.update();
        }
    }

    @Override
    public IBoxProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(IBoxProvider iBoxProvider) {
        this.provider = iBoxProvider;
    }

    @Override
    public void setSettings(IBoxSettings iBoxSettings) {
        this.settings = iBoxSettings;
        this.settingsChangeListener = new SettingsChangeListener();
        this.settings.addPropertyChangeListener(this.settingsChangeListener);
    }

    @Override
    public void setStyledText(StyledText styledText) {
        this.boxText = styledText;
    }

    protected void buildBoxes() {
        IBoxBuilder iBoxBuilder = this.getBuilder();
        if (iBoxBuilder == null) {
            return;
        }
        this.builder.setTabSize(this.boxText.getTabs());
        this.builder.setCaretOffset(this.setCaretOffset ? this.boxText.getCaretOffset() : -1);
        this.setCaretOffset = false;
        StringBuilder stringBuilder = new StringBuilder(this.boxText.getText());
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '\n') {
            stringBuilder.append(".");
        }
        iBoxBuilder.setText(stringBuilder);
        this.boxes = iBoxBuilder.build();
        this.charCount = this.boxText.getCharCount();
    }

    protected IBoxBuilder getBuilder() {
        if (this.settings.getBuilder() == null) {
            return null;
        }
        if (this.builder == null || this.builderName == null || !this.builderName.equals(this.settings.getBuilder())) {
            this.builderName = this.settings.getBuilder();
            this.builder = this.provider.createBoxBuilder(this.builderName);
        }
        return this.builder;
    }

    @Override
    public void forceUpdate() {
        this.boxes = null;
        this.update();
    }

    public void update() {
        if (this.decorated && this.visible) {
            if (!(this.builder == null || this.builderName.equals(this.settings.getBuilder()) && this.builder.getTabSize() == this.boxText.getTabs())) {
                this.boxes = null;
            }
            if (this.boxes == null) {
                this.buildBoxes();
            }
            this.offsetMoved();
            this.updateCaret();
            this.drawBackgroundBoxes();
        }
    }

    void drawBackgroundBoxes() {
        Box box2;
        Object object;
        if (this.boxes == null || !this.visible) {
            return;
        }
        Rectangle rectangle = this.boxText.getClientArea();
        if (rectangle.width < 1 || rectangle.height < 1) {
            return;
        }
        int n = this.boxText.getHorizontalPixel();
        int n2 = this.boxText.getTopPixel() - (PlatformHelper.isMac() ? this.boxText.getLinePixel(2) : 0);
        Image image = new Image(null, rectangle.width, rectangle.height);
        GC gC = new GC((Drawable)image);
        Color color = this.settings.getColor(0);
        if (this.settings.getNoBackground() && this.oldBackground != null) {
            color = new Color(null, this.oldBackground);
        }
        if (color != null) {
            object = image.getBounds();
            this.fillRectangle(color, gC, object.x, object.y, object.width, object.height);
        }
        if (this.settings.getAlpha() > 0) {
            gC.setAlpha(this.settings.getAlpha());
        }
        object = null;
        boolean bl = !this.settings.getFillOnMove();
        Collection<Box> collection = this.visibleBoxes();
        boolean bl2 = this.settings.getExpandBox();
        for (Box box2 : collection) {
            if (bl && box2.level == this.fillBoxLevel && box2.start <= this.fillBoxStart && box2.end >= this.fillBoxEnd) {
                object = box2;
            }
            this.fillRectangle(this.settings.getColor(box2.level + 1), gC, box2.rec.x - n, box2.rec.y - n2, bl2 ? rectangle.width : box2.rec.width, box2.rec.height);
        }
        if (this.settings.getFillSelected()) {
            if (this.settings.getFillOnMove() && this.currentBox != null && this.stateMask == this.settings.getFillKeyModifierSWTInt()) {
                this.fillRectangle(this.settings.getFillSelectedColor(), gC, this.currentBox.rec.x - n, this.currentBox.rec.y - n2, bl2 ? rectangle.width : this.currentBox.rec.width + 1, this.currentBox.rec.height + 1);
            } else if (object != null) {
                this.fillRectangle(this.settings.getFillSelectedColor(), gC, object.rec.x - n, object.rec.y - n2, bl2 ? rectangle.width : object.rec.width + 1, object.rec.height + 1);
            }
        }
        for (Box box2 : collection) {
            if (box2.isOn) continue;
            this.drawRect(gC, box2, box2.rec.x - n, box2.rec.y - n2, this.settings.getExpandBox() ? rectangle.width : box2.rec.width, box2.rec.height);
        }
        for (Box box2 : collection) {
            if (!box2.isOn) continue;
            this.drawRect(gC, box2, box2.rec.x - n, box2.rec.y - n2, this.settings.getExpandBox() ? rectangle.width : box2.rec.width, box2.rec.height);
        }
        box2 = this.boxText.getBackgroundImage();
        this.boxText.setBackgroundImage(image);
        if (box2 != null) {
            box2.dispose();
        }
        gC.dispose();
        this.oldClientArea = rectangle;
        this.oldXOffset = n;
        this.oldYOffset = n2;
    }

    private void drawRect(GC gC, Box box, int n, int n2, int n3, int n4) {
        if (box.isOn && this.settings.getHighlightWidth() > 0 && this.settings.getHighlightColor(box.level) != null) {
            gC.setLineStyle(this.settings.getHighlightLineStyleSWTInt());
            gC.setLineWidth(this.settings.getHighlightWidth());
            gC.setForeground(this.settings.getHighlightColor(box.level));
            if (this.settings.getHighlightDrawLine()) {
                gC.drawLine(n, n2, n, n2 + box.rec.height);
            } else if (this.settings.getRoundBox()) {
                gC.drawRoundRectangle(n, n2, n3, n4, 5, 5);
            } else {
                gC.drawRectangle(n, n2, n3, n4);
            }
        } else if (!box.isOn && this.settings.getBorderWidth() > 0 && this.settings.getBorderColor(box.level) != null) {
            gC.setLineStyle(this.settings.getBorderLineStyleSWTInt());
            gC.setLineWidth(this.settings.getBorderWidth());
            gC.setForeground(this.settings.getBorderColor(box.level));
            if (this.settings.getBorderDrawLine()) {
                gC.drawLine(n, n2 + 1, n, n2 + box.rec.height - 1);
            } else if (this.settings.getRoundBox()) {
                gC.drawRoundRectangle(n, n2, n3, n4, 5, 5);
            } else {
                gC.drawRectangle(n, n2, n3, n4);
            }
        }
    }

    void fillRectangle(Color color, GC gC, int n, int n2, int n3, int n4) {
        if (color == null) {
            return;
        }
        gC.setBackground(color);
        if (this.settings.getRoundBox()) {
            gC.fillRoundRectangle(n, n2, n3, n4, 5, 5);
        } else if (this.settings.getFillGradient() && this.settings.getFillGradientColor() != null) {
            gC.setBackground(this.settings.getFillGradientColor());
            gC.setForeground(color);
            gC.fillGradientRectangle(n, n2, n3, n4, false);
        } else {
            gC.fillRectangle(n, n2, n3, n4);
        }
    }

    @Override
    public void decorate(boolean bl) {
        Color color;
        this.decorated = false;
        if (this.boxText == null || this.settings == null) {
            return;
        }
        this.boxPaint = new BoxPaintListener();
        this.boxMouseMove = new BoxMouseMoveListener();
        this.boxMouseTrack = new BoxMouseTrackListener();
        this.boxTextChange = new BoxTextChangeListener();
        this.fillMouseClick = new FillBoxMouseClick();
        this.boxKey = new BoxKeyListener();
        this.boxModify = new BoxModifyListener();
        if (bl) {
            this.boxMouseClick = new BoxMouseClickListener();
        }
        if ((color = this.boxText.getBackground()) != null) {
            this.oldBackground = color.getRGB();
        }
        this.oldIndent = this.boxText.getIndent();
        if (this.oldIndent < 3) {
            this.boxText.setIndent(3);
        }
        this.boxText.addPaintListener((PaintListener)this.boxPaint);
        this.boxText.addMouseMoveListener((MouseMoveListener)this.boxMouseMove);
        this.boxText.addMouseTrackListener((MouseTrackListener)this.boxMouseTrack);
        this.boxText.getContent().addTextChangeListener((TextChangeListener)this.boxTextChange);
        this.boxText.addMouseListener((MouseListener)this.fillMouseClick);
        this.boxText.addModifyListener((ModifyListener)this.boxModify);
        this.boxText.addKeyListener((KeyListener)this.boxKey);
        if (bl) {
            this.boxText.addMouseListener((MouseListener)this.boxMouseClick);
        }
        this.decorated = true;
    }

    @Override
    public void undecorate() {
        if (this.boxText == null && !this.decorated) {
            return;
        }
        if (this.settingsChangeListener != null) {
            this.settings.removePropertyChangeListener(this.settingsChangeListener);
        }
        if (this.boxText == null || this.boxText.isDisposed()) {
            return;
        }
        this.decorated = false;
        if (this.boxMouseClick != null) {
            this.boxText.removeMouseListener((MouseListener)this.boxMouseClick);
        }
        if (this.boxTextChange != null) {
            this.boxText.getContent().removeTextChangeListener((TextChangeListener)this.boxTextChange);
        }
        if (this.boxMouseTrack != null) {
            this.boxText.removeMouseTrackListener((MouseTrackListener)this.boxMouseTrack);
        }
        if (this.boxMouseMove != null) {
            this.boxText.removeMouseMoveListener((MouseMoveListener)this.boxMouseMove);
        }
        if (this.boxPaint != null) {
            this.boxText.removePaintListener((PaintListener)this.boxPaint);
        }
        if (this.fillMouseClick != null) {
            this.boxText.removeMouseListener((MouseListener)this.fillMouseClick);
        }
        if (this.boxModify != null) {
            this.boxText.removeModifyListener((ModifyListener)this.boxModify);
        }
        if (this.boxKey != null) {
            this.boxText.removeKeyListener((KeyListener)this.boxKey);
        }
        this.boxText.setIndent(this.oldIndent);
        this.boxText.setBackgroundImage(null);
        if (this.oldBackground != null) {
            this.boxText.setBackground(new Color(null, this.oldBackground));
        } else {
            this.boxText.setBackground(null);
        }
    }

    protected Collection<Box> visibleBoxes() {
        Rectangle rectangle = this.boxText.getClientArea();
        int n = this.boxText.getHorizontalIndex() + this.boxText.getOffsetAtLine(this.boxText.getTopIndex());
        int n2 = this.boxText.getCharCount() - 1;
        int n3 = this.boxText.getLineIndex(rectangle.height);
        if (n3 < this.boxText.getLineCount() - 1) {
            n2 = this.boxText.getOffsetAtLine(n3);
        }
        ArrayList<Box> arrayList = new ArrayList<Box>();
        for (Box box : this.boxes) {
            if (!box.intersects(n, n2)) continue;
            arrayList.add(box);
        }
        int n4 = this.boxText.getTopPixel();
        int n5 = this.boxText.getHorizontalPixel();
        for (Box box : arrayList) {
            Point point;
            Point point2;
            if (box.rec != null) continue;
            Point point3 = this.boxText.getLocationAtOffset(box.start);
            if (box.tabsStart > -1 && box.tabsStart != box.start) {
                point2 = this.boxText.getLocationAtOffset(box.tabsStart);
                if (point2.x < point3.x) {
                    point3.x = point2.x;
                }
            }
            point2 = this.boxText.getLocationAtOffset(box.end);
            if (box.end != box.maxEndOffset) {
                point = this.boxText.getLocationAtOffset(box.maxEndOffset);
                point2.x = point.x;
            }
            point = new Rectangle(point3.x + n5 - 2, point3.y + n4 - 1, point2.x - point3.x + 6, point2.y - point3.y + this.boxText.getLineHeight(box.end));
            box.rec = point;
            this.updateWidth(box);
            this.updateWidth3(box);
        }
        return arrayList;
    }

    void updateWidth(Box box) {
        Box box2 = box;
        Box box3 = box2.parent;
        while (box3 != null && box3.rec != null && box3.rec.x + box3.rec.width <= box2.rec.x + box2.rec.width) {
            box3.rec.width += 5;
            box2 = box3;
            box3 = box3.parent;
        }
    }

    void updateWidth3(Box box) {
        Box box2 = box;
        Box box3 = box2.parent;
        while (box3 != null && box3.rec != null && box3.rec.x >= box2.rec.x) {
            box3.rec.width += box3.rec.x - box2.rec.x + 3;
            box3.rec.x = box2.rec.x - 3 > 0 ? box2.rec.x - 3 : 0;
            box2 = box3;
            box3 = box3.parent;
        }
    }

    protected boolean turnOnBox(int n, int n2) {
        if (this.boxes == null || !this.visible) {
            return false;
        }
        int n3 = n + this.boxText.getHorizontalPixel();
        int n4 = n2 + this.boxText.getTopPixel();
        return this.settings.getHighlightOne() ? this.turnOnOne(n3, n4) : this.turnOnAll(n3, n4);
    }

    protected boolean turnOnAll(int n, int n2) {
        boolean bl = false;
        Box box = null;
        for (Box box2 : this.visibleBoxes()) {
            if (this.contains(box2.rec, n, n2)) {
                if (!box2.isOn) {
                    box2.isOn = true;
                    bl = true;
                }
                if (box != null && box.offset >= box2.offset) continue;
                box = box2;
                continue;
            }
            if (!box2.isOn) continue;
            box2.isOn = false;
            bl = true;
        }
        if (!bl) {
            bl = box != this.currentBox;
        }
        this.currentBox = box;
        return bl;
    }

    protected boolean turnOnOne(int n, int n2) {
        Box box = null;
        for (Box box2 : this.visibleBoxes()) {
            if (this.contains(box2.rec, n, n2)) {
                box = box2;
            }
            box2.isOn = false;
        }
        if (box != null) {
            box.isOn = true;
        }
        boolean bl = box != this.currentBox;
        this.currentBox = box;
        return bl;
    }

    boolean contains(Rectangle rectangle, int n, int n2) {
        return n >= rectangle.x && n2 >= rectangle.y && n - rectangle.x < rectangle.width && n2 - rectangle.y < rectangle.height;
    }

    boolean redrawIfClientAreaChanged() {
        if (this.oldClientArea == null || !this.oldClientArea.equals((Object)this.boxText.getClientArea())) {
            this.drawBackgroundBoxes();
            return true;
        }
        return false;
    }

    void updateCaret() {
        this.oldCaretLoc = this.boxText.getLocationAtOffset(this.boxText.getCaretOffset());
        this.turnOnBox(this.oldCaretLoc.x > 0 ? this.oldCaretLoc.x - 1 : this.oldCaretLoc.x, this.oldCaretLoc.y);
    }

    public boolean offsetMoved() {
        int n = this.boxText.getTopPixel();
        int n2 = this.boxText.getHorizontalPixel();
        if (n2 != this.oldXOffset || n != this.oldYOffset) {
            this.oldXOffset = n2;
            this.oldYOffset = n;
            return true;
        }
        return false;
    }

    protected void carretMoved() {
        Point point = this.boxText.getLocationAtOffset(this.boxText.getCaretOffset());
        if (!(this.boxes == null || this.oldCaretLoc != null && this.oldCaretLoc.equals((Object)point))) {
            this.oldCaretLoc = point;
            boolean bl = false;
            if (!this.setCaretOffset && this.builder != null && this.builder.getCaretOffset() > -1 && this.builder.getCaretOffset() != this.boxText.getCaretOffset()) {
                this.buildBoxes();
                bl = true;
            }
            if (this.turnOnBox(this.oldCaretLoc.x > 0 ? this.oldCaretLoc.x - 1 : this.oldCaretLoc.x, this.oldCaretLoc.y) || bl) {
                this.drawBackgroundBoxes();
            }
        }
    }

    private final class BoxKeyListener
    implements KeyListener {
        public void keyReleased(KeyEvent keyEvent) {
            BoxDecoratorImpl.this.keyPressed = true;
            BoxDecoratorImpl.this.carretMoved();
        }

        public void keyPressed(KeyEvent keyEvent) {
        }
    }

    private final class BoxModifyListener
    implements ModifyListener {
        public void modifyText(ModifyEvent modifyEvent) {
            if (BoxDecoratorImpl.this.boxes == null) {
                BoxDecoratorImpl.this.buildBoxes();
                BoxDecoratorImpl.this.updateCaret();
                BoxDecoratorImpl.this.drawBackgroundBoxes();
            }
        }
    }

    class BoxMouseClickListener
    extends MouseAdapter {
        BoxMouseClickListener() {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            Box box;
            int n = mouseEvent.x + BoxDecoratorImpl.this.boxText.getHorizontalPixel();
            int n2 = mouseEvent.y + BoxDecoratorImpl.this.boxText.getTopPixel();
            int n3 = -1;
            Color color = BoxDecoratorImpl.this.visibleBoxes().iterator();
            while (color.hasNext()) {
                box = color.next();
                if (!BoxDecoratorImpl.this.contains(box.rec, n, n2) || n3 >= box.level) continue;
                n3 = box.level;
            }
            box = new ColorDialog(BoxDecoratorImpl.this.boxText.getShell());
            if ((color = BoxDecoratorImpl.this.settings.getColor(++n3)) != null) {
                box.setRGB(color.getRGB());
            }
            BoxDecoratorImpl.this.settings.setColor(n3, box.open());
        }
    }

    class BoxMouseMoveListener
    implements MouseMoveListener {
        BoxMouseMoveListener() {
        }

        public void mouseMove(MouseEvent mouseEvent) {
            BoxDecoratorImpl.this.stateMask = mouseEvent.stateMask;
            if (BoxDecoratorImpl.this.turnOnBox(mouseEvent.x, mouseEvent.y)) {
                BoxDecoratorImpl.this.drawBackgroundBoxes();
            }
        }
    }

    class BoxMouseTrackListener
    implements MouseTrackListener {
        BoxMouseTrackListener() {
        }

        public void mouseEnter(MouseEvent mouseEvent) {
        }

        public void mouseExit(MouseEvent mouseEvent) {
            boolean bl = false;
            if (BoxDecoratorImpl.this.boxes != null) {
                for (Box box : BoxDecoratorImpl.this.boxes) {
                    if (!box.isOn) continue;
                    bl = true;
                    box.isOn = false;
                }
            }
            if (bl) {
                BoxDecoratorImpl.this.drawBackgroundBoxes();
            }
        }

        public void mouseHover(MouseEvent mouseEvent) {
        }
    }

    class BoxPaintListener
    implements PaintListener {
        volatile boolean paintMode;

        BoxPaintListener() {
        }

        public void paintControl(PaintEvent paintEvent) {
            block8: {
                if (this.paintMode) {
                    return;
                }
                this.paintMode = true;
                try {
                    try {
                        if (BoxDecoratorImpl.this.boxes == null || BoxDecoratorImpl.this.charCount != BoxDecoratorImpl.this.boxText.getCharCount()) {
                            BoxDecoratorImpl.this.buildBoxes();
                            BoxDecoratorImpl.this.updateCaret();
                            BoxDecoratorImpl.this.drawBackgroundBoxes();
                            break block8;
                        }
                        if (BoxDecoratorImpl.this.offsetMoved()) {
                            BoxDecoratorImpl.this.updateCaret();
                            BoxDecoratorImpl.this.drawBackgroundBoxes();
                            break block8;
                        }
                        BoxDecoratorImpl.this.redrawIfClientAreaChanged();
                    }
                    catch (Throwable throwable) {
                        this.paintMode = false;
                    }
                }
                finally {
                    this.paintMode = false;
                }
            }
        }
    }

    class BoxTextChangeListener
    implements TextChangeListener {
        BoxTextChangeListener() {
        }

        private void change() {
            BoxDecoratorImpl.this.boxes = null;
            BoxDecoratorImpl.this.setCaretOffset = true;
        }

        public void textChanged(TextChangedEvent textChangedEvent) {
            this.change();
        }

        public void textChanging(TextChangingEvent textChangingEvent) {
        }

        public void textSet(TextChangedEvent textChangedEvent) {
            this.change();
        }
    }

    class FillBoxMouseClick
    extends MouseAdapter {
        FillBoxMouseClick() {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button != 1 || BoxDecoratorImpl.this.settings.getFillOnMove() || mouseEvent.stateMask != BoxDecoratorImpl.this.settings.getFillKeyModifierSWTInt()) {
                if (BoxDecoratorImpl.this.keyPressed) {
                    BoxDecoratorImpl.this.keyPressed = false;
                    BoxDecoratorImpl.this.carretMoved();
                }
                return;
            }
            int n = mouseEvent.x + BoxDecoratorImpl.this.boxText.getHorizontalPixel();
            int n2 = mouseEvent.y + BoxDecoratorImpl.this.boxText.getTopPixel();
            Box box = null;
            for (Box box2 : BoxDecoratorImpl.this.visibleBoxes()) {
                if (!BoxDecoratorImpl.this.contains(box2.rec, n, n2)) continue;
                box = box2;
            }
            if (box != null && (box.end != BoxDecoratorImpl.this.fillBoxEnd || box.start != BoxDecoratorImpl.this.fillBoxStart || box.level != BoxDecoratorImpl.this.fillBoxLevel)) {
                BoxDecoratorImpl.this.fillBoxEnd = box.end;
                BoxDecoratorImpl.this.fillBoxLevel = box.level;
                BoxDecoratorImpl.this.fillBoxStart = box.start;
            } else {
                BoxDecoratorImpl.this.fillBoxEnd = -1;
                BoxDecoratorImpl.this.fillBoxStart = -1;
                BoxDecoratorImpl.this.fillBoxLevel = -1;
            }
            if (BoxDecoratorImpl.this.keyPressed) {
                Box box2;
                BoxDecoratorImpl.this.keyPressed = false;
                box2 = BoxDecoratorImpl.this.boxText.getLocationAtOffset(BoxDecoratorImpl.this.boxText.getCaretOffset());
                if (BoxDecoratorImpl.this.oldCaretLoc == null || !BoxDecoratorImpl.this.oldCaretLoc.equals((Object)box2)) {
                    BoxDecoratorImpl.this.buildBoxes();
                    BoxDecoratorImpl.this.oldCaretLoc = box2;
                }
            }
            BoxDecoratorImpl.this.drawBackgroundBoxes();
        }
    }

    class SettingsChangeListener
    implements IPropertyChangeListener {
        SettingsChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BoxDecoratorImpl.this.update();
        }
    }
}

