/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editbox;

import gama.ui.editor.internal.EditorActivator;
import gaml.compiler.ui.editbox.BoxBuilderImpl;
import gaml.compiler.ui.editbox.BoxProviderImpl;
import gaml.compiler.ui.editbox.IBoxProvider;
import gaml.compiler.ui.editbox.JavaBoxBuilder;
import gaml.compiler.ui.editbox.TextBoxBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BoxProviderRegistry {
    private static final String PROIVDERS = "proivders";
    private static final String PROVIDER_ID_ = "gaml.editbox.provider.";
    protected Collection<IBoxProvider> providers;
    private static BoxProviderRegistry INSTANCE;

    public static BoxProviderRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BoxProviderRegistry();
        }
        return INSTANCE;
    }

    public IBoxProvider getGamlProvider() {
        return BoxProviderRegistry.getInstance().providerForName("GAML");
    }

    public Collection<IBoxProvider> getBoxProviders() {
        if (this.providers == null) {
            this.providers = this.loadProviders();
        }
        if (this.providers == null) {
            this.providers = this.defaultProviders();
        }
        return this.providers;
    }

    protected Collection<IBoxProvider> loadProviders() {
        String[] stringArray;
        ArrayList<BoxProviderImpl> arrayList = null;
        String string = EditorActivator.getInstance().getPreferenceStore().getString(PROIVDERS);
        if (string != null && string.length() > 0 && (stringArray = string.split(",")).length > 0) {
            arrayList = new ArrayList<BoxProviderImpl>();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (string2.trim().length() > 0) {
                    arrayList.add(this.createProvider(string2.trim()));
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public void setProviders(Collection<IBoxProvider> collection) {
        this.providers = collection;
    }

    public void storeProviders() {
        if (this.providers != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (IBoxProvider iBoxProvider : this.providers) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(iBoxProvider.getName());
            }
            EditorActivator.getInstance().getPreferenceStore().setValue(PROIVDERS, stringBuilder.toString());
        }
    }

    protected Collection<IBoxProvider> defaultProviders() {
        ArrayList<IBoxProvider> arrayList = new ArrayList<IBoxProvider>();
        arrayList.add(this.gamlProvider());
        arrayList.add(this.textProvider());
        return arrayList;
    }

    protected BoxProviderImpl createProvider(String string) {
        BoxProviderImpl boxProviderImpl = new BoxProviderImpl();
        boxProviderImpl.setId(PROVIDER_ID_ + string);
        boxProviderImpl.setName(string);
        boxProviderImpl.setBuilders(this.defaultBuilders());
        boxProviderImpl.setDefaultSettingsCatalog(Collections.singletonList("Default"));
        return boxProviderImpl;
    }

    protected BoxProviderImpl gamlProvider() {
        BoxProviderImpl boxProviderImpl = this.createProvider("GAML");
        boxProviderImpl.setDefaultSettingsCatalog(Arrays.asList("GAML", "Default", "OnClick", "GreyGradient", "Classic"));
        if (boxProviderImpl.getEditorsBoxSettings().getFileNames() == null) {
            boxProviderImpl.getEditorsBoxSettings().setFileNames(Collections.singletonList("*.gaml"));
        }
        return boxProviderImpl;
    }

    protected BoxProviderImpl textProvider() {
        BoxProviderImpl boxProviderImpl = this.createProvider("Text");
        boxProviderImpl.setDefaultSettingsCatalog(Arrays.asList("Default", "Whitebox"));
        if (boxProviderImpl.getEditorsBoxSettings().getFileNames() == null) {
            boxProviderImpl.getEditorsBoxSettings().setFileNames(Arrays.asList("*.txt", "*.*"));
        }
        return boxProviderImpl;
    }

    protected Map<String, Class> defaultBuilders() {
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        hashMap.put("Text", BoxBuilderImpl.class);
        hashMap.put("GAML", JavaBoxBuilder.class);
        hashMap.put("Text2", TextBoxBuilder.class);
        return hashMap;
    }

    public IBoxProvider providerForName(String string) {
        IBoxProvider iBoxProvider2;
        Collection<IBoxProvider> collection = this.getBoxProviders();
        for (IBoxProvider iBoxProvider2 : collection) {
            if (!iBoxProvider2.getName().equals(string)) continue;
            return iBoxProvider2;
        }
        iBoxProvider2 = this.createProvider(string);
        collection.add(iBoxProvider2);
        return iBoxProvider2;
    }

    public void removeProvider(String string) {
        Iterator<IBoxProvider> iterator = this.getBoxProviders().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getName().equals(string)) continue;
            iterator.remove();
        }
    }
}

