/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editbox;

import gaml.compiler.ui.editbox.IBoxSettings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class BoxSettingsImpl
implements IBoxSettings {
    private static final BoxSettingsImpl DEFAULT = new BoxSettingsImpl(){
        {
            this.name = "Default";
            this.borderWidth = 1;
            this.highlightWidth = 1;
            this.highlightOne = true;
            this.roundBox = true;
            this.borderColor = new Color(null, 0, 187, 187);
            this.highlightColor = new Color(null, 0, 0, 0);
            this.builder = "Text";
            Color[] colorArray = new Color[4];
            colorArray[1] = new Color(null, 208, 221, 155);
            colorArray[2] = new Color(null, 205, 216, 185);
            colorArray[3] = new Color(null, 233, 245, 139);
            this.boxColors = colorArray;
            this.fillSelected = true;
            this.fillColor = new Color(null, 255, 255, 196);
            this.fillKeyModifier = "Alt";
        }
    };
    protected boolean enabled;
    protected String name;
    protected String text;
    protected Color borderColor;
    protected Color highlightColor;
    protected Color fillColor;
    protected int borderWidth;
    protected int highlightWidth;
    protected boolean highlightOne;
    protected boolean fillSelected;
    protected boolean roundBox;
    protected String builder;
    protected Color[] boxColors;
    protected ArrayList<IPropertyChangeListener> listeners;
    protected boolean highlightDrawLine;
    protected Color fillGradientColor;
    protected boolean fillGradient;
    protected boolean borderDrawLine;
    protected boolean fillOnMove;
    protected boolean circulateLevelColors;
    protected String fillKeyModifier;
    protected Collection<String> fileNames;
    protected int highlightColorType;
    protected int borderColorType;
    protected int borderLineStyle;
    protected int highlightLineStyle;
    protected boolean noBackground;
    protected boolean expandBox;
    protected int alpha;
    private transient Color[] borderColors;
    private transient Color[] highlightColors;

    @Override
    public void copyFrom(IBoxSettings iBoxSettings) {
        BoxSettingsImpl boxSettingsImpl = (BoxSettingsImpl)iBoxSettings;
        this.name = boxSettingsImpl.getName();
        this.enabled = boxSettingsImpl.getEnabled();
        this.fileNames = boxSettingsImpl.fileNames == null ? null : new ArrayList<String>(boxSettingsImpl.fileNames);
        this.borderColor = this.setColorCopy(this.borderColor, boxSettingsImpl.borderColor);
        this.highlightColor = this.setColorCopy(this.highlightColor, boxSettingsImpl.highlightColor);
        this.fillColor = this.setColorCopy(this.fillColor, boxSettingsImpl.fillColor);
        this.borderWidth = boxSettingsImpl.borderWidth;
        this.highlightWidth = boxSettingsImpl.highlightWidth;
        this.highlightOne = boxSettingsImpl.highlightOne;
        this.fillSelected = boxSettingsImpl.fillSelected;
        this.roundBox = boxSettingsImpl.roundBox;
        Color[] colorArray = this.copyColors(boxSettingsImpl);
        Color[] colorArray2 = this.boxColors;
        this.boxColors = colorArray;
        this.disposeColors(colorArray2);
        this.builder = boxSettingsImpl.builder;
        this.borderDrawLine = boxSettingsImpl.borderDrawLine;
        this.highlightDrawLine = boxSettingsImpl.highlightDrawLine;
        this.fillGradient = boxSettingsImpl.fillGradient;
        this.fillGradientColor = this.setColorCopy(this.fillGradientColor, boxSettingsImpl.fillGradientColor);
        this.fillOnMove = boxSettingsImpl.fillOnMove;
        this.circulateLevelColors = boxSettingsImpl.circulateLevelColors;
        this.fillKeyModifier = boxSettingsImpl.fillKeyModifier;
        this.borderColorType = boxSettingsImpl.borderColorType;
        this.highlightColorType = boxSettingsImpl.highlightColorType;
        this.borderColors = this.disposeColors(this.borderColors);
        this.highlightColors = this.disposeColors(this.highlightColors);
        this.highlightLineStyle = boxSettingsImpl.highlightLineStyle;
        this.borderLineStyle = boxSettingsImpl.borderLineStyle;
        this.noBackground = boxSettingsImpl.noBackground;
        this.expandBox = boxSettingsImpl.expandBox;
        this.alpha = boxSettingsImpl.alpha;
        this.notifyChange(IBoxSettings.PropertiesKeys.ALL.name(), null, null);
    }

    private Color[] copyColors(BoxSettingsImpl boxSettingsImpl) {
        Color[] colorArray;
        Color[] colorArray2 = colorArray = boxSettingsImpl.boxColors == null ? null : new Color[boxSettingsImpl.boxColors.length];
        if (colorArray != null) {
            int n = 0;
            while (n < colorArray.length) {
                Color color = boxSettingsImpl.boxColors[n];
                if (color != null) {
                    colorArray[n] = new Color(null, color.getRGB());
                }
                ++n;
            }
        }
        return colorArray;
    }

    private Color[] disposeColors(Color[] colorArray) {
        if (colorArray != null) {
            Color[] colorArray2 = colorArray;
            int n = colorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Color color = colorArray2[n2];
                if (color != null) {
                    color.dispose();
                }
                ++n2;
            }
        }
        return null;
    }

    protected Color setColorCopy(Color color, Color color2) {
        if (color != null) {
            color.dispose();
        }
        return color2 == null ? null : new Color(null, color2.getRGB());
    }

    @Override
    public String export() {
        return new StringExternalization().export(this);
    }

    @Override
    public void load(String string) {
        StringExternalization stringExternalization = new StringExternalization();
        boolean bl = false;
        if (string != null) {
            try {
                stringExternalization.load(string, this);
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        if (bl || string == null) {
            this.copyFrom(DEFAULT);
        }
        this.notifyChange(IBoxSettings.PropertiesKeys.ALL.name(), null, null);
    }

    @Override
    public void export(OutputStream outputStream) throws Exception {
        new StringExternalization().export(outputStream, this);
    }

    @Override
    public void load(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            this.load((String)null);
        } else {
            new StringExternalization().load(inputStream, this);
        }
        this.notifyChange(IBoxSettings.PropertiesKeys.ALL.name(), null, null);
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.notifyChange(IBoxSettings.PropertiesKeys.Enabled.name(), null, bl);
    }

    @Override
    public void setFileNames(Collection<String> collection) {
        this.fileNames = collection;
        this.notifyChange(IBoxSettings.PropertiesKeys.FileNames.name(), null, null);
    }

    @Override
    public Collection<String> getFileNames() {
        return this.fileNames;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
        this.notifyChange(IBoxSettings.PropertiesKeys.Name.name(), null, null);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String string) {
        this.text = string;
    }

    protected Color setColor0(Color color, Color color2) {
        this.disposeColor(color);
        return color2;
    }

    protected Color setColor0(Color color, RGB rGB) {
        if (rGB == null) {
            return color;
        }
        return this.setColor0(color, new Color(null, rGB));
    }

    protected Color disposeColor(Color color) {
        if (color != null) {
            color.dispose();
        }
        return null;
    }

    @Override
    public void dispose() {
        this.borderColor = this.disposeColor(this.borderColor);
        this.highlightColor = this.disposeColor(this.highlightColor);
        this.fillColor = this.disposeColor(this.fillColor);
        this.disposeColors(this.boxColors);
        this.boxColors = null;
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public void setBorderRGB(RGB rGB) {
        this.borderColor = this.setColor0(this.borderColor, rGB);
        this.notifyChange(IBoxSettings.PropertiesKeys.BorderColor.name(), null, null);
    }

    @Override
    public void setBorderWidth(int n) {
        this.borderWidth = n;
        this.notifyChange(IBoxSettings.PropertiesKeys.BorderWidth.name(), null, null);
    }

    @Override
    public void setRoundBox(boolean bl) {
        this.roundBox = bl;
        this.notifyChange(IBoxSettings.PropertiesKeys.RoundBox.name(), null, null);
    }

    @Override
    public boolean getRoundBox() {
        return this.roundBox;
    }

    @Override
    public Color getHighlightColor() {
        return this.highlightColor;
    }

    @Override
    public boolean getHighlightOne() {
        return this.highlightOne;
    }

    @Override
    public int getHighlightWidth() {
        return this.highlightWidth;
    }

    @Override
    public void setHighlightOne(boolean bl) {
        this.highlightOne = bl;
        this.notifyChange(IBoxSettings.PropertiesKeys.HighlightOne.name(), null, null);
    }

    @Override
    public void setHighlightRGB(RGB rGB) {
        this.highlightColor = this.setColor0(this.highlightColor, rGB);
        this.notifyChange(IBoxSettings.PropertiesKeys.HighlightColor.name(), null, null);
    }

    @Override
    public void setHighlightWidth(int n) {
        this.highlightWidth = n;
        this.notifyChange(IBoxSettings.PropertiesKeys.HighlightWidth.name(), null, null);
    }

    @Override
    public boolean getFillSelected() {
        return this.fillSelected;
    }

    @Override
    public Color getFillSelectedColor() {
        return this.fillColor;
    }

    @Override
    public void setFillSelected(boolean bl) {
        this.fillSelected = bl;
        this.notifyChange(IBoxSettings.PropertiesKeys.FillSelected.name(), null, null);
    }

    @Override
    public void setFillSelectedRGB(RGB rGB) {
        this.fillColor = this.setColor0(this.fillColor, rGB);
        this.notifyChange(IBoxSettings.PropertiesKeys.FillSelectedColor.name(), null, null);
    }

    @Override
    public void setBuilder(String string) {
        this.builder = string;
        this.notifyChange(IBoxSettings.PropertiesKeys.Builder.name(), null, null);
    }

    @Override
    public String getBuilder() {
        return this.builder;
    }

    @Override
    public boolean getBorderDrawLine() {
        return this.borderDrawLine;
    }

    @Override
    public boolean getFillGradient() {
        return this.fillGradient;
    }

    @Override
    public Color getFillGradientColor() {
        return this.fillGradientColor;
    }

    @Override
    public boolean getHighlightDrawLine() {
        return this.highlightDrawLine;
    }

    @Override
    public void setBorderDrawLine(boolean bl) {
        this.borderDrawLine = bl;
        this.notifyChange(IBoxSettings.PropertiesKeys.BorderDrawLine.name(), null, null);
    }

    @Override
    public void setFillGradient(boolean bl) {
        this.fillGradient = bl;
        this.notifyChange(IBoxSettings.PropertiesKeys.FillGradient.name(), null, null);
    }

    @Override
    public void setFillGradientColorRGB(RGB rGB) {
        this.fillGradientColor = this.setColor0(this.fillGradientColor, rGB);
        this.notifyChange(IBoxSettings.PropertiesKeys.FillGradientColor.name(), null, null);
    }

    @Override
    public void setHighlightDrawLine(boolean bl) {
        this.highlightDrawLine = bl;
        this.notifyChange(IBoxSettings.PropertiesKeys.HighlightDrawLine.name(), null, null);
    }

    @Override
    public Color[] getColors() {
        return this.boxColors;
    }

    @Override
    public boolean getFillOnMove() {
        return this.fillOnMove;
    }

    @Override
    public void setFillOnMove(boolean bl) {
        this.fillOnMove = bl;
        this.notifyChange(IBoxSettings.PropertiesKeys.FillOnMove.name(), null, null);
    }

    @Override
    public void setColorsRGB(RGB[] rGBArray) {
        if (rGBArray == null) {
            this.disposeColors(this.boxColors);
            this.boxColors = null;
        } else {
            Color[] colorArray = new Color[rGBArray.length];
            int n = 0;
            while (n < rGBArray.length) {
                colorArray[n] = new Color(null, rGBArray[n]);
                ++n;
            }
            this.disposeColors(this.boxColors);
            this.boxColors = colorArray;
        }
        this.notifyChange(IBoxSettings.PropertiesKeys.Colors.name(), null, null);
    }

    @Override
    public void setColorsSize(int n) {
        int n2 = n + 1;
        Color[] colorArray = null;
        if (n2 == 0) {
            this.disposeColors(this.boxColors);
        } else if (this.boxColors != null) {
            colorArray = new Color[n2];
            int n3 = 0;
            while (n3 < n2) {
                if (n3 >= this.boxColors.length) break;
                colorArray[n3] = this.boxColors[n3];
                ++n3;
            }
            n3 = n2;
            while (n3 < this.boxColors.length) {
                this.disposeColor(this.boxColors[n3]);
                ++n3;
            }
        } else {
            colorArray = new Color[n2];
        }
        this.boxColors = colorArray;
        this.notifyChange(IBoxSettings.PropertiesKeys.Colors.name(), null, null);
    }

    @Override
    public int getColorsSize() {
        return this.boxColors == null ? 0 : this.boxColors.length - 1;
    }

    @Override
    public Color getBorderColor(int n) {
        int n2;
        if (this.borderColorType < 1) {
            return this.borderColor;
        }
        if (this.boxColors == null) {
            return null;
        }
        if (this.borderColors != null && this.borderColors.length != this.boxColors.length) {
            this.borderColors = this.disposeColors(this.borderColors);
        }
        if (this.borderColors == null) {
            this.borderColors = new Color[this.boxColors.length];
        }
        if ((n2 = this.getColorIndex(n)) > -1) {
            if (this.borderColors[n2] != null) {
                return this.borderColors[n2];
            }
            if (this.boxColors[n2] == null) {
                return null;
            }
            this.borderColors[n2] = this.calculateDarkerColor(this.boxColors[n2], this.borderColorType);
            return this.borderColors[n2];
        }
        return null;
    }

    private final Color calculateDarkerColor(Color color, int n) {
        return new Color(null, this.calcDarker(color.getRed(), n), this.calcDarker(color.getGreen(), n), this.calcDarker(color.getBlue(), n));
    }

    private final int calcDarker(int n, int n2) {
        return n - n * n2 / 4;
    }

    @Override
    public Color getHighlightColor(int n) {
        int n2;
        if (this.highlightColorType < 1) {
            return this.highlightColor;
        }
        if (this.boxColors == null) {
            return null;
        }
        if (this.highlightColors != null && this.highlightColors.length != this.boxColors.length) {
            this.highlightColors = this.disposeColors(this.highlightColors);
        }
        if (this.highlightColors == null) {
            this.highlightColors = new Color[this.boxColors.length];
        }
        if ((n2 = this.getColorIndex(n)) > -1) {
            if (this.highlightColors[n2] != null) {
                return this.highlightColors[n2];
            }
            if (this.boxColors[n2] == null) {
                return null;
            }
            this.highlightColors[n2] = this.calculateDarkerColor(this.boxColors[n2], this.highlightColorType);
            return this.highlightColors[n2];
        }
        return null;
    }

    @Override
    public void setBorderColorType(int n) {
        this.borderColorType = n;
        this.notifyChange(IBoxSettings.PropertiesKeys.BorderColorType.name(), null, null);
    }

    @Override
    public int getBorderColorType() {
        return this.borderColorType;
    }

    @Override
    public void setHighlightColorType(int n) {
        this.highlightColorType = n;
        this.notifyChange(IBoxSettings.PropertiesKeys.HighlightColorType.name(), null, null);
    }

    @Override
    public int getHighlightColorType() {
        return this.highlightColorType;
    }

    public int getColorIndex(int n) {
        if (this.boxColors != null && this.boxColors.length == 1 && this.noBackground && n > 0) {
            return -1;
        }
        if (!this.circulateLevelColors && this.boxColors != null && this.boxColors.length <= n && this.boxColors.length > 0) {
            return this.boxColors.length - 1;
        }
        if (this.boxColors != null && this.boxColors.length > 0 && n > -1) {
            return this.getNColor0(n);
        }
        return -1;
    }

    @Override
    public Color getColor(int n) {
        int n2 = this.getColorIndex(n);
        if (n2 > -1) {
            return this.boxColors[n2];
        }
        return null;
    }

    int getNColor0(int n) {
        int n2 = this.boxColors.length;
        if (n2 < 2) {
            return 0;
        }
        int n3 = n % (n2 + n2 - 2);
        if (n3 < n2) {
            return n3;
        }
        return n2 - (n3 - n2 + 2);
    }

    @Override
    public void setColor(int n, RGB rGB) {
        if (this.boxColors != null && this.boxColors.length > 0 && n > -1) {
            this.boxColors[n % this.boxColors.length] = this.setColor0(this.boxColors[n % this.boxColors.length], rGB);
        }
        this.notifyChange(IBoxSettings.PropertiesKeys.Color.name(), null, null);
    }

    @Override
    public boolean getCirculateLevelColors() {
        return this.circulateLevelColors;
    }

    @Override
    public void setCirculateLevelColors(boolean bl) {
        this.circulateLevelColors = bl;
        this.notifyChange(IBoxSettings.PropertiesKeys.CirculateLevelColors.name(), null, null);
    }

    @Override
    public void setFillKeyModifier(String string) {
        this.fillKeyModifier = string;
        this.notifyChange(IBoxSettings.PropertiesKeys.FillKeyModifier.name(), null, null);
    }

    @Override
    public String getFillKeyModifier() {
        return this.fillKeyModifier;
    }

    @Override
    public int getFillKeyModifierSWTInt() {
        if (this.fillKeyModifier == null || this.fillKeyModifier.length() == 0) {
            return 0;
        }
        if ("Alt".equals(this.fillKeyModifier)) {
            return 65536;
        }
        if ("Ctrl".equals(this.fillKeyModifier)) {
            return 262144;
        }
        if ("Shift".equals(this.fillKeyModifier)) {
            return 131072;
        }
        return 0;
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(iPropertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(iPropertyChangeListener);
        }
    }

    protected void notifyChange(String string, Object object, Object object2) {
        if (this.listeners != null) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
            for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
                iPropertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    @Override
    public void setBorderLineStyle(int n) {
        this.borderLineStyle = n;
        this.notifyChange(IBoxSettings.PropertiesKeys.BorderLineStyle.name(), null, null);
    }

    @Override
    public void setHighlightLineStyle(int n) {
        this.highlightLineStyle = n;
        this.notifyChange(IBoxSettings.PropertiesKeys.HighlightLineStyle.name(), null, null);
    }

    @Override
    public int getBorderLineStyle() {
        return this.borderLineStyle;
    }

    @Override
    public int getBorderLineStyleSWTInt() {
        return this.swtLineStyle(this.borderLineStyle);
    }

    private int swtLineStyle(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public int getHighlightLineStyle() {
        return this.highlightLineStyle;
    }

    @Override
    public int getHighlightLineStyleSWTInt() {
        return this.swtLineStyle(this.highlightLineStyle);
    }

    @Override
    public boolean getNoBackground() {
        return this.noBackground;
    }

    @Override
    public void setNoBackground(boolean bl) {
        this.noBackground = bl;
        this.notifyChange(IBoxSettings.PropertiesKeys.NoBackground.name(), null, null);
    }

    @Override
    public boolean getExpandBox() {
        return this.expandBox;
    }

    @Override
    public void setExpandBox(boolean bl) {
        this.expandBox = bl;
        this.notifyChange(IBoxSettings.PropertiesKeys.ExpandBox.name(), null, null);
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(int n) {
        this.alpha = n;
        this.notifyChange(IBoxSettings.PropertiesKeys.Alpha.name(), null, null);
    }

    class StringExternalization {
        private static final String COMMENT = "Editbox Eclipse Plugin Settings";

        StringExternalization() {
        }

        public String export(BoxSettingsImpl boxSettingsImpl) {
            Properties properties = this.toProperies(boxSettingsImpl);
            return this.propertiesToString(properties);
        }

        public void load(InputStream inputStream, BoxSettingsImpl boxSettingsImpl) throws Exception {
            Properties properties = new Properties();
            properties.load(inputStream);
            this.load(properties, boxSettingsImpl);
        }

        public void export(OutputStream outputStream, BoxSettingsImpl boxSettingsImpl) throws Exception {
            Properties properties = this.toProperies(boxSettingsImpl);
            properties.store(outputStream, COMMENT);
        }

        public void load(String string, BoxSettingsImpl boxSettingsImpl) throws Exception {
            Properties properties = this.loadProperties(string);
            this.load(properties, boxSettingsImpl);
        }

        private void load(Properties properties, BoxSettingsImpl boxSettingsImpl) {
            boxSettingsImpl.name = this.parseString(properties.get(IBoxSettings.PropertiesKeys.Name.name()));
            boxSettingsImpl.borderColor = this.parseColor(properties.get(IBoxSettings.PropertiesKeys.BorderColor.name()));
            boxSettingsImpl.highlightColor = this.parseColor(properties.get(IBoxSettings.PropertiesKeys.HighlightColor.name()));
            boxSettingsImpl.borderWidth = this.parseInt(properties.get(IBoxSettings.PropertiesKeys.BorderWidth.name()));
            boxSettingsImpl.highlightWidth = this.parseInt(properties.get(IBoxSettings.PropertiesKeys.HighlightWidth.name()));
            boxSettingsImpl.roundBox = this.parseBool(properties.get(IBoxSettings.PropertiesKeys.RoundBox.name()));
            boxSettingsImpl.highlightOne = this.parseBool(properties.get(IBoxSettings.PropertiesKeys.HighlightOne.name()));
            boxSettingsImpl.fillSelected = this.parseBool(properties.get(IBoxSettings.PropertiesKeys.FillSelected.name()));
            boxSettingsImpl.fillColor = this.parseColor(properties.get(IBoxSettings.PropertiesKeys.FillSelectedColor.name()));
            boxSettingsImpl.builder = this.parseString(properties.get(IBoxSettings.PropertiesKeys.Builder.name()));
            boxSettingsImpl.boxColors = this.parseColorsArray(properties.get(IBoxSettings.PropertiesKeys.Colors.name()));
            boxSettingsImpl.highlightDrawLine = this.parseBool(properties.get(IBoxSettings.PropertiesKeys.HighlightDrawLine.name()));
            boxSettingsImpl.borderDrawLine = this.parseBool(properties.get(IBoxSettings.PropertiesKeys.BorderDrawLine.name()));
            boxSettingsImpl.fillGradient = this.parseBool(properties.get(IBoxSettings.PropertiesKeys.FillGradient.name()));
            boxSettingsImpl.fillGradientColor = this.parseColor(properties.get(IBoxSettings.PropertiesKeys.FillGradientColor.name()));
            boxSettingsImpl.fillOnMove = this.parseBool(properties.get(IBoxSettings.PropertiesKeys.FillOnMove.name()));
            boxSettingsImpl.circulateLevelColors = this.parseBool(properties.get(IBoxSettings.PropertiesKeys.CirculateLevelColors.name()));
            boxSettingsImpl.fillKeyModifier = this.parseString(properties.get(IBoxSettings.PropertiesKeys.FillKeyModifier.name()));
            boxSettingsImpl.borderColorType = this.parseInt(properties.get(IBoxSettings.PropertiesKeys.BorderColorType.name()));
            boxSettingsImpl.highlightColorType = this.parseInt(properties.get(IBoxSettings.PropertiesKeys.HighlightColorType.name()));
            boxSettingsImpl.highlightLineStyle = this.parseInt(properties.get(IBoxSettings.PropertiesKeys.HighlightLineStyle.name()));
            boxSettingsImpl.borderLineStyle = this.parseInt(properties.get(IBoxSettings.PropertiesKeys.BorderLineStyle.name()));
            boxSettingsImpl.noBackground = this.parseBool(properties.get(IBoxSettings.PropertiesKeys.NoBackground.name()));
            boxSettingsImpl.expandBox = this.parseBool(properties.get(IBoxSettings.PropertiesKeys.ExpandBox.name()));
            boxSettingsImpl.alpha = this.parseInt(properties.get(IBoxSettings.PropertiesKeys.Alpha.name()));
        }

        private Properties toProperies(BoxSettingsImpl boxSettingsImpl) {
            Properties properties = new Properties();
            properties.put(IBoxSettings.PropertiesKeys.Name.name(), this.toS(boxSettingsImpl.name));
            properties.put(IBoxSettings.PropertiesKeys.BorderColor.name(), this.toS(boxSettingsImpl.borderColor));
            properties.put(IBoxSettings.PropertiesKeys.HighlightColor.name(), this.toS(boxSettingsImpl.highlightColor));
            properties.put(IBoxSettings.PropertiesKeys.BorderWidth.name(), this.toS(boxSettingsImpl.borderWidth));
            properties.put(IBoxSettings.PropertiesKeys.HighlightWidth.name(), this.toS(boxSettingsImpl.highlightWidth));
            properties.put(IBoxSettings.PropertiesKeys.RoundBox.name(), this.toS(boxSettingsImpl.roundBox));
            properties.put(IBoxSettings.PropertiesKeys.HighlightOne.name(), this.toS(boxSettingsImpl.highlightOne));
            properties.put(IBoxSettings.PropertiesKeys.FillSelected.name(), this.toS(boxSettingsImpl.fillSelected));
            properties.put(IBoxSettings.PropertiesKeys.FillSelectedColor.name(), this.toS(boxSettingsImpl.fillColor));
            properties.put(IBoxSettings.PropertiesKeys.Builder.name(), this.toS(boxSettingsImpl.builder));
            properties.put(IBoxSettings.PropertiesKeys.Colors.name(), this.toS(boxSettingsImpl.boxColors));
            properties.put(IBoxSettings.PropertiesKeys.HighlightDrawLine.name(), this.toS(boxSettingsImpl.highlightDrawLine));
            properties.put(IBoxSettings.PropertiesKeys.BorderDrawLine.name(), this.toS(boxSettingsImpl.borderDrawLine));
            properties.put(IBoxSettings.PropertiesKeys.FillGradient.name(), this.toS(boxSettingsImpl.fillGradient));
            properties.put(IBoxSettings.PropertiesKeys.FillGradientColor.name(), this.toS(boxSettingsImpl.fillGradientColor));
            properties.put(IBoxSettings.PropertiesKeys.FillOnMove.name(), this.toS(boxSettingsImpl.fillOnMove));
            properties.put(IBoxSettings.PropertiesKeys.CirculateLevelColors.name(), this.toS(boxSettingsImpl.circulateLevelColors));
            properties.put(IBoxSettings.PropertiesKeys.FillKeyModifier.name(), this.toS(boxSettingsImpl.fillKeyModifier));
            properties.put(IBoxSettings.PropertiesKeys.BorderColorType.name(), this.toS(boxSettingsImpl.borderColorType));
            properties.put(IBoxSettings.PropertiesKeys.HighlightColorType.name(), this.toS(boxSettingsImpl.highlightColorType));
            properties.put(IBoxSettings.PropertiesKeys.HighlightLineStyle.name(), this.toS(boxSettingsImpl.highlightLineStyle));
            properties.put(IBoxSettings.PropertiesKeys.BorderLineStyle.name(), this.toS(boxSettingsImpl.borderLineStyle));
            properties.put(IBoxSettings.PropertiesKeys.NoBackground.name(), this.toS(boxSettingsImpl.noBackground));
            properties.put(IBoxSettings.PropertiesKeys.ExpandBox.name(), this.toS(boxSettingsImpl.expandBox));
            properties.put(IBoxSettings.PropertiesKeys.Alpha.name(), this.toS(boxSettingsImpl.alpha));
            return properties;
        }

        private Properties loadProperties(String string) throws IOException {
            Properties properties = new Properties();
            properties.load(new StringReader(string));
            return properties;
        }

        private String propertiesToString(Properties properties) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                properties.store(byteArrayOutputStream, "COMMENT");
                return byteArrayOutputStream.toString();
            }
            catch (IOException iOException) {
                return "";
            }
        }

        private Color[] parseColorsArray(Object object) {
            if (object == null || object.equals("null")) {
                return null;
            }
            String[] stringArray = object.toString().split("-");
            Color[] colorArray = new Color[stringArray.length];
            int n = 0;
            while (n < colorArray.length) {
                colorArray[n] = this.parseColor(stringArray[n]);
                ++n;
            }
            return colorArray;
        }

        private boolean parseBool(Object object) {
            if (object == null) {
                return false;
            }
            return object.equals("true");
        }

        private int parseInt(Object object) {
            if (object == null || object.equals("null")) {
                return 0;
            }
            return Integer.parseInt(object.toString());
        }

        private Color parseColor(Object object) {
            if (object == null || object.equals("null")) {
                return null;
            }
            String string = object.toString();
            if (string.length() != 6) {
                return null;
            }
            try {
                int n = Integer.parseInt(string.substring(0, 2), 16);
                int n2 = Integer.parseInt(string.substring(2, 4), 16);
                int n3 = Integer.parseInt(string.substring(4, 6), 16);
                return new Color(null, n, n2, n3);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private String parseString(Object object) {
            if (object == null || object.equals("null")) {
                return null;
            }
            return object.toString();
        }

        private String toS(boolean bl) {
            return bl ? "true" : "false";
        }

        private String toS(Color[] colorArray) {
            StringBuilder stringBuilder = new StringBuilder();
            if (colorArray == null || colorArray.length == 0) {
                stringBuilder.append("null");
            } else {
                int n = 0;
                while (n < colorArray.length) {
                    if (n > 0) {
                        stringBuilder.append("-");
                    }
                    stringBuilder.append(this.toS(colorArray[n]));
                    ++n;
                }
            }
            return stringBuilder.toString();
        }

        private String toS(int n) {
            return Integer.toString(n);
        }

        private String toS(Color color) {
            return color == null ? "null" : this.toHex(color.getRed()) + this.toHex(color.getGreen()) + this.toHex(color.getBlue());
        }

        private String toHex(int n) {
            Object object = Integer.toHexString(n);
            if (((String)object).length() == 1) {
                object = "0" + (String)object;
            }
            return object;
        }

        private String toS(String string) {
            return string == null ? "null" : string;
        }
    }
}

