/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editbox;

import gama.ui.editor.internal.EditorActivator;
import gaml.compiler.ui.editbox.IBoxSettings;
import gaml.compiler.ui.editbox.IBoxSettingsStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;

public class BoxSettingsStoreImpl
implements IBoxSettingsStore {
    private static final String FILE_NAMES = "fileNames";
    private static final String TXT_POSTFIX = "$txt";
    private static final String DEFAULT = "default";
    private static final String ENABLED = "enabled";
    protected String providerId;
    protected IPreferenceStore store;
    private Set<String> catalog;
    private Collection<String> defaultCatalog;

    protected IPreferenceStore getStore() {
        if (this.store == null) {
            this.store = EditorActivator.getInstance().getPreferenceStore();
        }
        return this.store;
    }

    protected String key(String string) {
        return this.providerId + "_" + string;
    }

    @Override
    public void setProviderId(String string) {
        this.providerId = string;
    }

    @Override
    public void loadDefaults(IBoxSettings iBoxSettings) {
        String string = this.getStore().getString(this.key(DEFAULT));
        if (this.isEmpty(string)) {
            string = this.providerId;
        }
        this.load(string, iBoxSettings);
    }

    @Override
    public void load(String string, IBoxSettings iBoxSettings) {
        String string2 = this.getStore().getString(this.key(string));
        if (!this.isEmpty(string2)) {
            iBoxSettings.load(string2);
        } else {
            try {
                iBoxSettings.load(this.getClass().getResourceAsStream("/" + string + ".eb"));
            }
            catch (Exception exception) {}
        }
        iBoxSettings.setEnabled(this.getIsEnabled());
        iBoxSettings.setFileNames(this.getFileNames());
    }

    protected boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    protected boolean getIsEnabled() {
        String string = this.key(ENABLED);
        if (this.getStore().contains(string)) {
            return this.getStore().getBoolean(string);
        }
        return true;
    }

    @Override
    public void saveDefaults(IBoxSettings iBoxSettings) {
        this.getStore().setValue(this.key(ENABLED), iBoxSettings.getEnabled() ? "true" : "false");
        this.getStore().setValue(this.key(DEFAULT), iBoxSettings.getName());
        this.store(iBoxSettings);
    }

    public void store(IBoxSettings iBoxSettings) {
        String string = iBoxSettings.getName();
        this.getStore().setValue(this.key(string), iBoxSettings.export());
        this.setFileNames(iBoxSettings.getFileNames());
        this.addToCatalog(string);
        EditorActivator.getInstance().savePluginPreferences();
    }

    protected void addToCatalog(String string) {
        Set<String> set = this.getCatalog();
        if (!set.contains(string)) {
            set.add(string);
            this.storeCatalog(set);
        }
    }

    private void storeCatalog(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        this.getStore().setValue(this.key("catalog"), stringBuilder.toString());
    }

    @Override
    public Set<String> getCatalog() {
        if (this.catalog == null) {
            this.catalog = new LinkedHashSet<String>();
            String string = this.getStore().getString(this.key("catalog"));
            if (!this.isEmpty(string)) {
                String[] stringArray = string.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray[n2];
                    this.catalog.add(string2);
                    ++n2;
                }
            }
        }
        if (this.defaultCatalog != null && this.catalog != null) {
            this.catalog.addAll(this.defaultCatalog);
        }
        return this.catalog;
    }

    public void setDefaultSettingsCatalog(Collection<String> collection) {
        this.defaultCatalog = collection;
    }

    @Override
    public void remove(String string) {
        if (this.getCatalog().remove(string)) {
            this.storeCatalog(this.getCatalog());
        }
        this.getStore().setValue(this.key(string), "");
        this.getStore().setValue(this.key(string + TXT_POSTFIX), "");
        EditorActivator.getInstance().savePluginPreferences();
    }

    protected void setFileNames(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        if (collection != null) {
            boolean bl = true;
            for (String string : collection) {
                if (!bl) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string);
                bl = false;
            }
        }
        this.getStore().setValue(this.key(FILE_NAMES), stringBuilder.toString());
    }

    protected Collection<String> getFileNames() {
        String string = this.key(FILE_NAMES);
        if (!this.getStore().contains(string)) {
            return null;
        }
        String string2 = this.getStore().getString(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                if (string3.length() <= 0) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }
}

