/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editbox;

import gaml.compiler.ui.editbox.IBoxDecorator;
import gaml.compiler.ui.editbox.IBoxProvider;
import gaml.compiler.ui.editbox.IBoxSettings;
import gaml.compiler.ui.editbox.IBoxSettingsStore;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class BoxSettingsTab {
    protected IBoxProvider provider;
    protected IBoxSettingsStore store;
    protected IBoxSettings settings;
    protected IBoxDecorator decorator;
    Button enabled;
    Combo combo;
    Combo borderWidth;
    Button roundBox;
    Combo highlightWidth;
    Button highlightOne;
    ColorSelector fillSelectedColor;
    Button fillSelected;
    Combo builderCombo;
    ColorSelector fromColorLab;
    ColorSelector toColorLab;
    StyledText st;
    Button bordertDrawLine;
    Button highlightDrawLine;
    Button fillGradient;
    ColorSelector fillGradientColor;
    Button fillOnMove;
    Button circulateColors;
    Combo levels;
    Combo fillKey;
    protected boolean changed;
    Composite composite;
    ColorSelector borderColorSelector;
    Combo borderColorType;
    Combo highlightColorType;
    ColorSelector highlightColorSelector;
    Button genGradientBut;
    Combo borderLineStyle;
    Combo highlightLineStyle;
    Button noBackground;
    Button eolBox;
    Scale scale;
    Spinner spinner;

    public Control createContro(Composite composite, IBoxProvider iBoxProvider) {
        this.provider = iBoxProvider;
        if (this.provider == null) {
            Label label = new Label(composite, 0);
            label.setText("Error - cannot make configuration");
            return label;
        }
        this.store = this.provider.getSettingsStore();
        this.settings = this.provider.createSettings();
        this.decorator = this.provider.createDecorator();
        this.decorator.setSettings(this.settings);
        Control control = this.createContents0(composite);
        this.updateContents();
        this.decorator.setStyledText(this.st);
        this.decorator.decorate(true);
        this.decorator.enableUpdates(true);
        this.settings.addPropertyChangeListener(propertyChangeEvent -> {
            this.changed = true;
            if (propertyChangeEvent.getProperty().equals(IBoxSettings.PropertiesKeys.Color.name())) {
                this.updateFromToColors();
            }
            this.provider.getEditorsBoxSettings().copyFrom(this.settings);
        });
        return control;
    }

    protected Control createContents0(Composite composite) {
        Composite composite2;
        this.composite = composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 1;
        gridLayout.marginWidth = 1;
        gridLayout.numColumns = 6;
        composite2.setLayout((Layout)gridLayout);
        composite2.setSize(200, 400);
        this.enabled = new Button(composite2, 32);
        GridData gridData = new GridData();
        this.enabled.setLayoutData((Object)gridData);
        this.enabled.setText("Enabled");
        this.enabled.setAlignment(131072);
        this.enabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setEnabled(BoxSettingsTab.this.enabled.getSelection());
            }
        });
        this.newButton(composite2, "Export", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(BoxSettingsTab.this.getShell(), 8192);
                fileDialog.setFileName(BoxSettingsTab.this.settings.getName());
                fileDialog.setFilterExtensions(new String[]{"*.eb"});
                fileDialog.setText("Editbox settings");
                String string = fileDialog.open();
                if (string != null) {
                    try {
                        BoxSettingsTab.this.settings.export(new FileOutputStream(string));
                    }
                    catch (Exception exception) {
                        MessageBox messageBox = new MessageBox(BoxSettingsTab.this.getShell(), 1);
                        messageBox.setText("Failed to export configuration: " + exception.getMessage());
                        messageBox.open();
                    }
                }
                super.widgetSelected(selectionEvent);
            }
        });
        Button button = this.newButton(composite2, "Import", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(BoxSettingsTab.this.getShell(), 4096);
                fileDialog.setFileName(BoxSettingsTab.this.settings.getName());
                fileDialog.setFilterExtensions(new String[]{"*.eb"});
                fileDialog.setText("Editbox settings");
                String string = fileDialog.open();
                if (string != null) {
                    try {
                        IBoxSettings iBoxSettings = BoxSettingsTab.this.provider.createSettings();
                        iBoxSettings.load(new FileInputStream(string));
                        iBoxSettings.setEnabled(BoxSettingsTab.this.settings.getEnabled());
                        BoxSettingsTab.this.settings.copyFrom(iBoxSettings);
                        BoxSettingsTab.this.updateContents();
                    }
                    catch (Exception exception) {
                        MessageBox messageBox = new MessageBox(BoxSettingsTab.this.getShell(), 1);
                        messageBox.setText("Failed to load configuration: " + exception.getMessage());
                        messageBox.open();
                    }
                }
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        button.setLayoutData((Object)gridData);
        this.newLabel(composite2, "Enter/select theme");
        this.combo = new Combo(composite2, 4);
        gridData = new GridData(1);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        this.combo.setLayoutData((Object)gridData);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = BoxSettingsTab.this.combo.getText();
                if (string != null && string.length() > 0) {
                    BoxSettingsTab.this.decorator.enableUpdates(false);
                    BoxSettingsTab.this.store.load(string, BoxSettingsTab.this.settings);
                    BoxSettingsTab.this.updateContents();
                    BoxSettingsTab.this.decorator.enableUpdates(true);
                }
            }
        });
        Button button2 = new Button(composite2, 0);
        button2.setText("Remove");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = BoxSettingsTab.this.combo.getText();
                if (string != null && string.length() > 0) {
                    int n = BoxSettingsTab.this.combo.indexOf(string);
                    if (n > -1) {
                        BoxSettingsTab.this.combo.remove(n);
                        BoxSettingsTab.this.store.remove(string);
                    } else {
                        BoxSettingsTab.this.combo.setText("");
                    }
                }
            }
        });
        Label label = this.newLabel(composite2, "Box border:");
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.horizontalSpacing = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData());
        this.newLabel(composite3, " style");
        this.borderLineStyle = this.newCombo(composite3, new String[]{"Solid", "Dot", "Dash", "DashDot", "DashDotDot"}, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setBorderLineStyle(BoxSettingsTab.this.borderLineStyle.getSelectionIndex());
            }
        });
        this.borderLineStyle.select(0);
        Composite composite4 = new Composite(composite2, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.horizontalSpacing = 0;
        gridLayout3.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData());
        this.newLabel(composite4, "color");
        this.borderColorType = this.newCombo(composite4, new String[]{"Custom", "Dark", "Darker", "Darkest"}, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = BoxSettingsTab.this.borderColorType.getSelectionIndex();
                BoxSettingsTab.this.settings.setBorderColorType(n);
                BoxSettingsTab.this.borderColorSelector.getButton().setEnabled(n == 0);
            }
        });
        this.borderColorType.select(0);
        this.borderColorSelector = new ColorSelector(composite2);
        this.borderColorSelector.addListener(propertyChangeEvent -> this.settings.setBorderRGB(this.borderColorSelector.getColorValue()));
        Label label2 = this.newLabel(composite2, "width");
        label2.setLayoutData((Object)new GridData(128));
        this.borderWidth = this.newCombo(composite2, new String[]{"0", "1", "2", "3", "4", "5"}, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setBorderWidth(BoxSettingsTab.this.borderWidth.getSelectionIndex());
            }
        });
        this.bordertDrawLine = new Button(composite2, 32);
        this.bordertDrawLine.setText("Line");
        this.bordertDrawLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setBorderDrawLine(BoxSettingsTab.this.bordertDrawLine.getSelection());
            }
        });
        Label label3 = this.newLabel(composite2, "Highlight selected box:");
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        label3.setLayoutData((Object)gridData);
        Composite composite5 = new Composite(composite2, 0);
        GridLayout gridLayout4 = new GridLayout();
        gridLayout4.horizontalSpacing = 0;
        gridLayout4.marginWidth = 0;
        gridLayout4.numColumns = 2;
        composite5.setLayout((Layout)gridLayout);
        composite5.setLayoutData((Object)new GridData());
        this.newLabel(composite5, " style");
        this.highlightLineStyle = this.newCombo(composite5, new String[]{"Solid", "Dot", "Dash", "DashDot", "DashDotDot"}, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setHighlightLineStyle(BoxSettingsTab.this.highlightLineStyle.getSelectionIndex());
            }
        });
        this.highlightLineStyle.select(0);
        Composite composite6 = new Composite(composite2, 0);
        GridLayout gridLayout5 = new GridLayout();
        gridLayout5.horizontalSpacing = 0;
        gridLayout5.numColumns = 2;
        composite6.setLayout((Layout)gridLayout);
        composite6.setLayoutData((Object)new GridData());
        this.newLabel(composite6, "color");
        this.highlightColorType = this.newCombo(composite6, new String[]{"Custom", "Dark", "Darker", "Darkest"}, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = BoxSettingsTab.this.highlightColorType.getSelectionIndex();
                BoxSettingsTab.this.settings.setHighlightColorType(n);
                BoxSettingsTab.this.highlightColorSelector.getButton().setEnabled(n == 0);
            }
        });
        this.highlightColorType.select(0);
        this.highlightColorSelector = new ColorSelector(composite2);
        this.highlightColorSelector.addListener(propertyChangeEvent -> this.settings.setHighlightRGB(this.highlightColorSelector.getColorValue()));
        Label label4 = this.newLabel(composite2, "width");
        label4.setLayoutData((Object)new GridData(128));
        this.highlightWidth = this.newCombo(composite2, new String[]{"0", "1", "2", "3", "4", "5"}, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setHighlightWidth(BoxSettingsTab.this.highlightWidth.getSelectionIndex());
            }
        });
        this.highlightDrawLine = new Button(composite2, 32);
        this.highlightDrawLine.setText("Line");
        this.highlightDrawLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setHighlightDrawLine(BoxSettingsTab.this.highlightDrawLine.getSelection());
            }
        });
        this.roundBox = new Button(composite2, 32);
        this.roundBox.setText("Round box");
        this.roundBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setRoundBox(BoxSettingsTab.this.roundBox.getSelection());
                if (BoxSettingsTab.this.roundBox.getSelection()) {
                    BoxSettingsTab.this.fillGradient.setSelection(false);
                    BoxSettingsTab.this.settings.setFillGradient(false);
                }
            }
        });
        this.highlightOne = new Button(composite2, 32);
        this.highlightOne.setText("Highlight one");
        this.highlightOne.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setHighlightOne(BoxSettingsTab.this.highlightOne.getSelection());
            }
        });
        this.eolBox = new Button(composite2, 32);
        this.eolBox.setText("Expand box");
        this.eolBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setExpandBox(BoxSettingsTab.this.eolBox.getSelection());
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.eolBox.setLayoutData((Object)gridData);
        this.noBackground = new Button(composite2, 32);
        this.noBackground.setText("No background");
        this.noBackground.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setNoBackground(BoxSettingsTab.this.noBackground.getSelection());
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.noBackground.setLayoutData((Object)gridData);
        this.fillSelected = new Button(composite2, 32);
        this.fillSelected.setText("Fill selected box");
        this.fillSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setFillSelected(BoxSettingsTab.this.fillSelected.getSelection());
            }
        });
        this.fillSelectedColor = new ColorSelector(composite2);
        this.fillSelectedColor.addListener(propertyChangeEvent -> this.settings.setFillSelectedRGB(this.fillSelectedColor.getColorValue()));
        this.fillSelectedColor.getButton().setLayoutData((Object)new GridData(1));
        this.fillOnMove = new Button(composite2, 32);
        this.fillOnMove.setText("On move");
        this.fillOnMove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setFillOnMove(BoxSettingsTab.this.fillOnMove.getSelection());
            }
        });
        this.newLabel(composite2, "with key");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fillOnMove.setLayoutData((Object)gridData);
        this.fillKey = this.newCombo(composite2, new String[]{"", "Alt", "Ctrl", "Shift"}, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setFillKeyModifier(BoxSettingsTab.this.fillKey.getText());
            }
        });
        this.fillGradient = new Button(composite2, 32);
        this.fillGradient.setText("Make gradient");
        this.fillGradient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setFillGradient(BoxSettingsTab.this.fillGradient.getSelection());
                if (BoxSettingsTab.this.fillGradient.getSelection()) {
                    BoxSettingsTab.this.roundBox.setSelection(false);
                    BoxSettingsTab.this.settings.setRoundBox(false);
                }
            }
        });
        this.fillGradientColor = new ColorSelector(composite2);
        this.fillGradientColor.addListener(propertyChangeEvent -> this.settings.setFillGradientColorRGB(this.fillGradientColor.getColorValue()));
        Label label5 = this.newLabel(composite2, "Alpha blending");
        label5.setToolTipText("Can slow down box drawing");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label5.setLayoutData((Object)gridData);
        this.scale = new Scale(composite2, 256);
        this.scale.setToolTipText("Can slow down box drawing");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 80;
        this.scale.setLayoutData((Object)gridData);
        this.scale.setMinimum(0);
        this.scale.setMinimum(255);
        this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = BoxSettingsTab.this.scale.getSelection() * 255 / 100;
                BoxSettingsTab.this.spinner.setSelection(n);
                BoxSettingsTab.this.settings.setAlpha(n);
            }
        });
        this.spinner = new Spinner(composite2, 0);
        this.spinner.setToolTipText("Can slow down box drawing");
        this.spinner.setMinimum(0);
        this.spinner.setMaximum(255);
        this.spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.scale.setSelection(BoxSettingsTab.this.spinner.getSelection() * 100 / 255);
                BoxSettingsTab.this.settings.setAlpha(BoxSettingsTab.this.spinner.getSelection());
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.spinner.setLayoutData((Object)gridData);
        this.newLabel(composite2, "Color levels");
        this.levels = this.newCombo(composite2, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"}, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setColorsSize(BoxSettingsTab.this.levels.getSelectionIndex());
                BoxSettingsTab.this.st.setText(BoxSettingsTab.this.generateIndentText(BoxSettingsTab.this.settings.getColorsSize() + 1));
            }
        });
        this.circulateColors = new Button(composite2, 32);
        this.circulateColors.setText("Circulate colors");
        this.circulateColors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setCirculateLevelColors(BoxSettingsTab.this.circulateColors.getSelection());
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        this.circulateColors.setLayoutData((Object)gridData);
        this.newLabel(composite2, "Syntax");
        this.builderCombo = new Combo(composite2, 8);
        gridData = new GridData(1);
        gridData.horizontalSpan = 5;
        this.builderCombo.setLayoutData((Object)gridData);
        this.builderCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BoxSettingsTab.this.settings.setBuilder(BoxSettingsTab.this.builderCombo.getText());
            }
        });
        this.newLabel(composite2, "Gradient tool");
        Composite composite7 = new Composite(composite2, 0);
        GridLayout gridLayout6 = new GridLayout();
        gridLayout6.horizontalSpacing = 0;
        gridLayout6.marginWidth = 0;
        gridLayout6.numColumns = 2;
        composite7.setLayout((Layout)gridLayout);
        composite7.setLayoutData((Object)new GridData());
        this.newLabel(composite7, "from color");
        this.fromColorLab = new ColorSelector(composite7);
        this.fromColorLab.getButton().setLayoutData((Object)new GridData(32));
        this.newLabel(composite2, "to");
        this.toColorLab = new ColorSelector(composite2);
        IPropertyChangeListener iPropertyChangeListener = propertyChangeEvent -> this.genGradientBut.setEnabled(this.toColorLab.getColorValue() != null && this.fromColorLab.getColorValue() != null);
        this.fromColorLab.addListener(iPropertyChangeListener);
        this.toColorLab.addListener(iPropertyChangeListener);
        this.genGradientBut = this.newButton(composite2, "Generate", new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (BoxSettingsTab.this.fromColorLab.getColorValue() == null || BoxSettingsTab.this.toColorLab.getColorValue() == null) {
                    return;
                }
                Color[] colorArray = BoxSettingsTab.this.settings.getColors();
                if (colorArray == null || colorArray.length < 2) {
                    return;
                }
                BoxSettingsTab.this.settings.setColorsRGB(BoxSettingsTab.this.rgbGradient(colorArray));
            }
        });
        Label label6 = this.newLabel(composite2, "Preview - double click on any box to change color:");
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        label6.setLayoutData((Object)gridData);
        this.st = new StyledText(composite2, 68360);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 50;
        this.st.setLayoutData((Object)gridData);
        this.st.setEditable(false);
        this.st.setToolTipText("Double click to change color");
        return composite2;
    }

    protected Shell getShell() {
        if (this.composite != null) {
            return this.composite.getShell();
        }
        return null;
    }

    protected Combo newCombo(Composite composite, String[] stringArray, SelectionListener selectionListener) {
        Combo combo = new Combo(composite, 8);
        combo.setItems(stringArray);
        combo.addSelectionListener(selectionListener);
        return combo;
    }

    protected Button newButton(Composite composite, String string, SelectionAdapter selectionAdapter) {
        Button button = new Button(composite, 0);
        button.setText(string);
        button.addSelectionListener((SelectionListener)selectionAdapter);
        return button;
    }

    protected Label newLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        Color color = composite.getBackground();
        if (color != null) {
            label.setBackground(new Color(null, color.getRGB()));
        }
        return label;
    }

    protected void updateContents() {
        int n;
        this.enabled.setSelection(this.settings.getEnabled());
        this.combo.setItems(this.store.getCatalog().toArray(new String[0]));
        if (this.settings.getName() != null) {
            n = this.combo.indexOf(this.settings.getName());
            if (n > -1) {
                this.combo.select(n);
            } else {
                this.combo.setText(this.settings.getName());
            }
        }
        if (this.settings.getBorderColor() != null) {
            this.borderColorSelector.setColorValue(this.settings.getBorderColor().getRGB());
        }
        this.borderWidth.select(this.settings.getBorderWidth());
        this.roundBox.setSelection(this.settings.getRoundBox());
        if (this.settings.getHighlightColor() != null) {
            this.highlightColorSelector.setColorValue(this.settings.getHighlightColor().getRGB());
        }
        this.highlightWidth.select(this.settings.getHighlightWidth());
        this.highlightOne.setSelection(this.settings.getHighlightOne());
        this.fillSelected.setSelection(this.settings.getFillSelected());
        if (this.settings.getFillSelectedColor() != null) {
            this.fillSelectedColor.setColorValue(this.settings.getFillSelectedColor().getRGB());
        }
        this.builderCombo.setItems(this.provider.getBuilders().toArray(new String[0]));
        n = -1;
        if (this.settings.getBuilder() != null) {
            n = this.builderCombo.indexOf(this.settings.getBuilder());
        }
        this.builderCombo.select(n == -1 ? 0 : n);
        this.st.setText(this.generateIndentText(this.settings.getColorsSize() + 1));
        this.updateFromToColors();
        this.bordertDrawLine.setSelection(this.settings.getBorderDrawLine());
        this.highlightDrawLine.setSelection(this.settings.getHighlightDrawLine());
        this.fillGradient.setSelection(this.settings.getFillGradient());
        if (this.settings.getFillGradientColor() != null) {
            this.fillGradientColor.setColorValue(this.settings.getFillGradientColor().getRGB());
        }
        this.fillOnMove.setSelection(this.settings.getFillOnMove());
        this.circulateColors.setSelection(this.settings.getCirculateLevelColors());
        this.levels.select(this.settings.getColorsSize());
        this.fillKey.setText(this.settings.getFillKeyModifier() == null ? "" : this.settings.getFillKeyModifier());
        this.borderColorType.select(this.settings.getBorderColorType());
        this.highlightColorType.select(this.settings.getHighlightColorType());
        this.highlightColorSelector.getButton().setEnabled(this.settings.getHighlightColorType() == 0);
        this.borderColorSelector.getButton().setEnabled(this.settings.getBorderColorType() == 0);
        this.borderLineStyle.select(this.settings.getBorderLineStyle());
        this.highlightLineStyle.select(this.settings.getHighlightLineStyle());
        this.noBackground.setSelection(this.settings.getNoBackground());
        this.eolBox.setSelection(this.settings.getExpandBox());
        this.spinner.setSelection(this.settings.getAlpha());
        this.scale.setSelection(this.settings.getAlpha() * 100 / 255);
    }

    private void updateFromToColors() {
        Color[] colorArray = this.settings.getColors();
        if (colorArray != null && colorArray.length > 1) {
            this.updateBackground(this.fromColorLab, colorArray[0]);
            this.updateBackground(this.toColorLab, colorArray[colorArray.length - 1]);
        } else {
            this.genGradientBut.setEnabled(false);
        }
    }

    protected void updateBackground(ColorSelector colorSelector, Color color) {
        if (color == null) {
            this.genGradientBut.setEnabled(false);
        } else {
            colorSelector.setColorValue(color.getRGB());
        }
    }

    public void dispose() {
        if (this.settings != null) {
            this.settings.dispose();
        }
    }

    RGB[] rgbGradient(Color[] colorArray) {
        int n = colorArray.length - 1;
        RGB rGB = this.fromColorLab.getColorValue();
        RGB rGB2 = this.toColorLab.getColorValue();
        int n2 = (rGB2.red - rGB.red) / n;
        int n3 = (rGB2.green - rGB.green) / n;
        int n4 = (rGB2.blue - rGB.blue) / n;
        RGB[] rGBArray = new RGB[n + 1];
        rGBArray[0] = rGB;
        int n5 = 1;
        while (n5 <= n) {
            RGB rGB3 = rGBArray[n5 - 1];
            rGBArray[n5] = new RGB(rGB3.red + n2, rGB3.green + n3, rGB3.blue + n4);
            ++n5;
        }
        return rGBArray;
    }

    String generateIndentText(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n2) {
                stringBuilder.append("  ");
                ++n3;
            }
            stringBuilder.append("level " + String.valueOf(n2 + 1 == n ? "n" : Integer.valueOf(n2 + 1)));
            stringBuilder.append("\n");
            ++n2;
        }
        return stringBuilder.toString();
    }

    public IBoxProvider getProvider() {
        return this.provider;
    }

    public IBoxSettings getSettings() {
        return this.settings;
    }

    public String validate() {
        this.settings.setName(this.combo.getText());
        if (this.settings.getName() == null || this.settings.getName().length() == 0) {
            return "Enter configuration name";
        }
        return null;
    }

    public void save() {
        if (this.changed) {
            this.store.saveDefaults(this.settings);
            this.provider.getEditorsBoxSettings().copyFrom(this.settings);
        }
    }

    public void cancel() {
        if (this.changed) {
            this.store.loadDefaults(this.provider.getEditorsBoxSettings());
        }
    }
}

