/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editbox;

import gaml.compiler.ui.editbox.BoxProviderRegistry;
import gaml.compiler.ui.editbox.BoxSettingsTab;
import gaml.compiler.ui.editbox.IBoxProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class EditboxPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    List categoryList;
    TabFolder folder;
    Map<String, LinkedHashSet<String>> categoryFiles;
    List namesList;
    Button bAddFile;
    boolean providersChanged;

    protected Control createContents(Composite composite) {
        FontData fontData;
        FontData[] fontDataArray;
        this.noDefaultAndApplyButton();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        Link link = new Link(composite2, 0);
        link.setText("Turn off current line highlighting <A>here</A>.");
        FontData[] fontDataArray2 = fontDataArray = link.getFont().getFontData();
        int n = fontDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            fontData = fontDataArray2[n2];
            fontData.setHeight(10);
            fontData.setStyle(1);
            ++n2;
        }
        link.setFont(new Font((Device)this.getShell().getDisplay(), fontDataArray));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer = (IWorkbenchPreferenceContainer)EditboxPreferencePage.this.getContainer();
                iWorkbenchPreferenceContainer.openPage("org.eclipse.ui.preferencePages.GeneralTextEditor", null);
            }
        });
        this.folder = new TabFolder(composite2, 0);
        this.folder.setLayoutData((Object)new GridData(1808));
        fontData = new TabItem(this.folder, 0);
        fontData.setText("Themes");
        fontData.setControl(this.createCategoryControl((Composite)this.folder));
        this.folder.pack();
        return composite2;
    }

    protected Control createCategoryControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, true));
        Label label = new Label(composite2, 0);
        label.setText("Themes");
        Label label2 = new Label(composite2, 0);
        label2.setText("Associated file names");
        label2.setAlignment(131072);
        this.categoryList = new List(composite2, 2560);
        this.categoryList.setLayoutData((Object)new GridData(1808));
        this.categoryList.addSelectionListener((SelectionListener)new SelectCategory());
        this.namesList = new List(composite2, 2560);
        this.namesList.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, true));
        Button button = new Button(composite3, 0);
        button.setText("Add");
        button.addSelectionListener((SelectionListener)new AddCategory());
        button.setLayoutData((Object)new GridData(1808));
        Button button2 = new Button(composite3, 0);
        button2.setText("Remove");
        button2.setLayoutData((Object)new GridData(1808));
        button2.addSelectionListener((SelectionListener)new RemoveCategory());
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayoutData((Object)new GridData(128));
        composite4.setLayout((Layout)new GridLayout(2, true));
        this.bAddFile = new Button(composite4, 0);
        this.bAddFile.setText("Add");
        this.bAddFile.setLayoutData((Object)new GridData(1808));
        this.bAddFile.addSelectionListener((SelectionListener)new AddFile());
        this.bAddFile.setEnabled(false);
        Button button3 = new Button(composite4, 0);
        button3.setText("Remove");
        button3.setLayoutData((Object)new GridData(1808));
        button3.addSelectionListener((SelectionListener)new RemoveFile());
        this.loadData();
        return composite2;
    }

    protected void loadData() {
        Collection<IBoxProvider> collection = BoxProviderRegistry.getInstance().getBoxProviders();
        for (IBoxProvider iBoxProvider : collection) {
            this.newTab(iBoxProvider.getName());
        }
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected boolean contains(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equalsIgnoreCase(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void newTab(String string) {
        Collection<String> collection;
        this.categoryList.add(string);
        TabItem tabItem = new TabItem(this.folder, 0);
        tabItem.setText(string);
        BoxSettingsTab boxSettingsTab = new BoxSettingsTab();
        IBoxProvider iBoxProvider = BoxProviderRegistry.getInstance().providerForName(string);
        tabItem.setControl(boxSettingsTab.createContro((Composite)this.folder, iBoxProvider));
        tabItem.setData((Object)boxSettingsTab);
        if (this.categoryFiles == null) {
            this.categoryFiles = new LinkedHashMap<String, LinkedHashSet<String>>();
        }
        if ((collection = boxSettingsTab.getSettings().getFileNames()) == null) {
            collection = Collections.emptyList();
        }
        this.categoryFiles.put(string, new LinkedHashSet<String>(collection));
        this.categoryList.setSelection(new String[]{string});
        this.namesList.setItems(collection.toArray(new String[0]));
        this.bAddFile.setEnabled(true);
    }

    public String[] namesArray(String string) {
        LinkedHashSet<String> linkedHashSet = this.categoryFiles.get(string);
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            return new String[0];
        }
        return linkedHashSet.toArray(new String[0]);
    }

    public void addFileName(String string) {
        int n = this.categoryList.getSelectionIndex();
        if (n > -1) {
            String string2 = this.categoryList.getItem(n);
            LinkedHashSet<String> linkedHashSet = this.categoryFiles.get(string2);
            linkedHashSet.add(string);
            this.namesList.add(string);
            Object object = this.folder.getItem(n + 1).getData();
            if (object instanceof BoxSettingsTab) {
                ((BoxSettingsTab)object).getSettings().setFileNames(linkedHashSet);
            }
        }
    }

    public boolean performOk() {
        TabItem[] tabItemArray = this.folder.getItems();
        int n = 1;
        while (n < tabItemArray.length) {
            Object object = tabItemArray[n].getData();
            if (object instanceof BoxSettingsTab) {
                BoxSettingsTab boxSettingsTab = (BoxSettingsTab)object;
                String string = boxSettingsTab.validate();
                if (string != null) {
                    this.folder.setSelection(n);
                    this.setMessage(string);
                    return false;
                }
                boxSettingsTab.save();
            }
            ++n;
        }
        if (this.providersChanged) {
            BoxProviderRegistry.getInstance().storeProviders();
        }
        return true;
    }

    public boolean performCancel() {
        TabItem[] tabItemArray = this.folder.getItems();
        int n = 1;
        while (n < tabItemArray.length) {
            Object object = tabItemArray[n].getData();
            if (object instanceof BoxSettingsTab) {
                ((BoxSettingsTab)object).cancel();
            }
            ++n;
        }
        if (this.providersChanged) {
            BoxProviderRegistry.getInstance().setProviders(null);
        }
        return true;
    }

    class AddCategory
    extends SelectionAdapter {
        AddCategory() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            InputDialog inputDialog = new InputDialog(EditboxPreferencePage.this.getShell(), "New Category", "Name:", null, string -> {
                if (string != null && string.trim().length() > 0 && !EditboxPreferencePage.this.contains(EditboxPreferencePage.this.categoryList.getItems(), string)) {
                    return null;
                }
                return "Unique name required";
            });
            if (inputDialog.open() == 0) {
                EditboxPreferencePage.this.newTab(inputDialog.getValue());
                EditboxPreferencePage.this.providersChanged = true;
            }
        }
    }

    class AddFile
    extends SelectionAdapter {
        AddFile() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            InputDialog inputDialog = new InputDialog(EditboxPreferencePage.this.getShell(), "New Name", "File name pattern like *.java, my.xml:", null, string -> {
                if (string != null && string.trim().length() > 0) {
                    return null;
                }
                return "";
            });
            if (inputDialog.open() == 0) {
                EditboxPreferencePage.this.addFileName(inputDialog.getValue());
            }
        }
    }

    class RemoveCategory
    extends SelectionAdapter {
        RemoveCategory() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = EditboxPreferencePage.this.categoryList.getSelectionIndex();
            if (n > -1) {
                String string = EditboxPreferencePage.this.categoryList.getItem(n);
                EditboxPreferencePage.this.categoryList.remove(n);
                EditboxPreferencePage.this.categoryFiles.remove(string);
                EditboxPreferencePage.this.namesList.setItems(new String[0]);
                EditboxPreferencePage.this.bAddFile.setEnabled(false);
                TabItem tabItem = EditboxPreferencePage.this.folder.getItem(n + 1);
                Object object = tabItem.getData();
                tabItem.dispose();
                if (object instanceof BoxSettingsTab) {
                    ((BoxSettingsTab)object).dispose();
                }
                BoxProviderRegistry.getInstance().removeProvider(string);
                EditboxPreferencePage.this.providersChanged = true;
            }
        }
    }

    class RemoveFile
    extends SelectionAdapter {
        RemoveFile() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n;
            int n2 = EditboxPreferencePage.this.namesList.getSelectionIndex();
            if (n2 > -1 && (n = EditboxPreferencePage.this.categoryList.getSelectionIndex()) > -1) {
                String string = EditboxPreferencePage.this.categoryList.getItem(n);
                String string2 = EditboxPreferencePage.this.namesList.getItem(n2);
                LinkedHashSet<String> linkedHashSet = EditboxPreferencePage.this.categoryFiles.get(string);
                linkedHashSet.remove(string2);
                EditboxPreferencePage.this.namesList.remove(n2);
                Object object = EditboxPreferencePage.this.folder.getItem(n + 1).getData();
                if (object instanceof BoxSettingsTab) {
                    ((BoxSettingsTab)object).getSettings().setFileNames(new ArrayList<String>(linkedHashSet));
                }
            }
        }
    }

    class SelectCategory
    extends SelectionAdapter {
        SelectCategory() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = EditboxPreferencePage.this.categoryList.getSelectionIndex();
            if (n > -1) {
                String string = EditboxPreferencePage.this.categoryList.getItem(n);
                EditboxPreferencePage.this.namesList.setItems(EditboxPreferencePage.this.namesArray(string));
                EditboxPreferencePage.this.bAddFile.setEnabled(true);
            } else {
                EditboxPreferencePage.this.namesList.setItems(new String[0]);
                EditboxPreferencePage.this.bAddFile.setEnabled(false);
            }
        }
    }
}

