/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editor;

import com.google.inject.Inject;
import gama.core.common.util.FileUtils;
import gama.ui.navigator.commands.FileOpener;
import gaml.compiler.gaml.HeadlessExperiment;
import gaml.compiler.gaml.Import;
import gaml.compiler.gaml.StringLiteral;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.DefaultHyperlinkDetector;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class GamlHyperlinkDetector
extends DefaultHyperlinkDetector {
    private static final IHyperlink[] NO_HYPERLINKS = null;
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;

    public IHyperlink[] detectHyperlinks(ITextViewer iTextViewer, final IRegion iRegion, final boolean bl) {
        IXtextDocument iXtextDocument = (IXtextDocument)iTextViewer.getDocument();
        IHyperlink[] iHyperlinkArray = this.importHyperlinks(iXtextDocument, iRegion);
        if (iHyperlinkArray != NO_HYPERLINKS) {
            return iHyperlinkArray;
        }
        return (IHyperlink[])iXtextDocument.readOnly((IUnitOfWork)new CancelableUnitOfWork<IHyperlink[], XtextResource>(){

            public IHyperlink[] exec(XtextResource xtextResource, CancelIndicator cancelIndicator) {
                return GamlHyperlinkDetector.this.getHelper().createHyperlinksByOffset(xtextResource, iRegion.getOffset(), bl);
            }
        });
    }

    public URI getURI(StringLiteral stringLiteral) {
        String string = stringLiteral.getOp();
        if (string == null || string.isBlank()) {
            return null;
        }
        return FileUtils.getURI((String)string, (URI)stringLiteral.eResource().getURI());
    }

    private IHyperlink[] importHyperlinks(IXtextDocument iXtextDocument, IRegion iRegion) {
        return (IHyperlink[])iXtextDocument.readOnly(xtextResource -> {
            IRegion iRegion2;
            Object object;
            EObject eObject = this.eObjectAtOffsetHelper.resolveElementAt(xtextResource, iRegion.getOffset());
            if (eObject instanceof StringLiteral && (object = this.getURI((StringLiteral)eObject)) != null) {
                IRegion iRegion3;
                try {
                    iRegion3 = this.importUriRegion(iXtextDocument, iRegion.getOffset(), ((StringLiteral)eObject).getOp());
                }
                catch (BadLocationException badLocationException) {
                    return NO_HYPERLINKS;
                }
                if (iRegion3 == null) {
                    return NO_HYPERLINKS;
                }
                ImportHyperlink importHyperlink = new ImportHyperlink((URI)object, iRegion3);
                return new IHyperlink[]{importHyperlink};
            }
            object = null;
            if (eObject instanceof Import) {
                object = ((Import)eObject).getImportURI();
            } else if (eObject instanceof HeadlessExperiment) {
                object = ((HeadlessExperiment)eObject).getImportURI();
            }
            if (object == null) {
                return NO_HYPERLINKS;
            }
            URI uRI = URI.createURI((String)object, (boolean)false).resolve(xtextResource.getURI());
            try {
                iRegion2 = this.importUriRegion(iXtextDocument, iRegion.getOffset(), (String)object);
            }
            catch (BadLocationException badLocationException) {
                return NO_HYPERLINKS;
            }
            if (iRegion2 == null) {
                return NO_HYPERLINKS;
            }
            ImportHyperlink importHyperlink = new ImportHyperlink(uRI, iRegion2);
            return new IHyperlink[]{importHyperlink};
        });
    }

    private IRegion importUriRegion(IXtextDocument iXtextDocument, int n, String string) throws BadLocationException {
        int n2 = iXtextDocument.getLineOfOffset(n);
        int n3 = iXtextDocument.getLineLength(n2);
        int n4 = iXtextDocument.getLineOffset(n2);
        String string2 = iXtextDocument.get(n4, n3);
        int n5 = string2.indexOf(string);
        return new Region(n4 + n5, string.length());
    }

    class ImportHyperlink
    implements IHyperlink {
        private final URI importUri;
        private final IRegion region;

        ImportHyperlink(URI uRI, IRegion iRegion) {
            this.importUri = uRI;
            this.region = iRegion;
        }

        public void open() {
            FileOpener.openFile((URI)this.importUri);
        }

        public String getTypeLabel() {
            return null;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getHyperlinkText() {
            return null;
        }
    }
}

