/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editor.folding;

import gaml.compiler.gaml.EGaml;
import java.util.Collection;
import java.util.regex.Matcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldedPosition;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptorExtension;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class GamaFoldingRegionProvider
extends DefaultFoldingRegionProvider {
    protected void computeObjectFolding(XtextResource xtextResource, IFoldingRegionAcceptor<ITextRegion> iFoldingRegionAcceptor) {
        super.computeObjectFolding(xtextResource, iFoldingRegionAcceptor);
    }

    protected void computeObjectFolding(EObject eObject, IFoldingRegionAcceptor<ITextRegion> iFoldingRegionAcceptor) {
        super.computeObjectFolding(eObject, iFoldingRegionAcceptor);
    }

    protected void computeObjectFolding(EObject eObject, IFoldingRegionAcceptor<ITextRegion> iFoldingRegionAcceptor, boolean bl) {
        super.computeObjectFolding(eObject, iFoldingRegionAcceptor, bl);
    }

    protected boolean isHandled(EObject eObject) {
        return EGaml.getInstance().hasChildren(eObject) && super.isHandled(eObject);
    }

    protected boolean shouldProcessContent(EObject eObject) {
        return EGaml.getInstance().hasChildren(eObject);
    }

    protected IFoldingRegionAcceptor<ITextRegion> createAcceptor(IXtextDocument iXtextDocument, Collection<FoldedPosition> collection) {
        return new GamaFoldingRegionAcceptor(iXtextDocument, collection);
    }

    protected void computeCommentFolding(IXtextDocument iXtextDocument, IFoldingRegionAcceptor<ITextRegion> iFoldingRegionAcceptor, ITypedRegion iTypedRegion, boolean bl) throws BadLocationException {
        int n = iTypedRegion.getOffset();
        int n2 = iTypedRegion.getLength();
        Matcher matcher = this.getTextPatternInComment().matcher(iXtextDocument.get(n, n2));
        ((GamaFoldingRegionAcceptor)iFoldingRegionAcceptor).type = iTypedRegion.getType();
        if (matcher.find()) {
            TextRegion textRegion = new TextRegion(n + matcher.start(), 0);
            ((IFoldingRegionAcceptorExtension)iFoldingRegionAcceptor).accept(n, n2, bl, (Object)textRegion);
        } else {
            ((IFoldingRegionAcceptorExtension)iFoldingRegionAcceptor).accept(n, n2, bl);
        }
    }

    private class GamaFoldingRegionAcceptor
    extends DefaultFoldingRegionAcceptor {
        String type;

        public GamaFoldingRegionAcceptor(IXtextDocument iXtextDocument, Collection<FoldedPosition> collection) {
            super(iXtextDocument, collection);
        }

        protected FoldedPosition newFoldedPosition(IRegion iRegion, ITextRegion iTextRegion) {
            Object object = null;
            if (iRegion != null) {
                object = this.type != null && iTextRegion != null ? new TypedFoldedPosition(iRegion.getOffset(), iRegion.getLength(), iTextRegion.getOffset() - iRegion.getOffset() - 1, iTextRegion.getLength(), this.type) : super.newFoldedPosition(iRegion, iTextRegion);
            }
            return object;
        }
    }

    public class TypedFoldedPosition
    extends DefaultFoldedPosition {
        String type;

        public TypedFoldedPosition(int n, int n2, int n3, int n4, String string) {
            super(n, n2, n3, n4);
            this.type = string;
        }

        public String getType() {
            return this.type;
        }
    }
}

