/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editor.toolbar;

import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.ui.shared.bindings.GamaKeyBindings;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.toolbar.GamaToolbarSimple;
import gama.ui.shared.views.toolbar.Selector;
import gaml.compiler.ui.editor.GamlEditor;
import gaml.compiler.ui.editor.toolbar.EditorSearchControls;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolItem;

public class EditorToolbar {
    ToolItem next;
    ToolItem previous;
    ToolItem diagram;
    EditorSearchControls find;
    final GamlEditor editor;
    volatile boolean searching;
    final Selector globalPrevious = selectionEvent -> {
        boolean bl = WorkbenchHelper.executeCommand((String)"org.eclipse.ui.navigate.backwardHistory");
    };
    final Selector globalNext = selectionEvent -> {
        boolean bl = WorkbenchHelper.executeCommand((String)"org.eclipse.ui.navigate.forwardHistory");
    };
    final Selector searchPrevious = selectionEvent -> this.find.findPrevious();
    final Selector searchNext = selectionEvent -> this.find.findNext();

    public EditorToolbar(GamlEditor gamlEditor) {
        this.editor = gamlEditor;
    }

    public EditorSearchControls fill(GamaToolbarSimple gamaToolbarSimple) {
        this.previous = gamaToolbarSimple.button("editor/command.lastedit", null, "Previous edit location", this.globalPrevious);
        this.next = gamaToolbarSimple.button("editor/command.nextedit", null, "Next edit location", this.globalNext);
        this.find = new EditorSearchControls(this.editor).fill(gamaToolbarSimple);
        gamaToolbarSimple.menu("editor/command.outline", null, "Show outline", selectionEvent -> {
            if (this.editor == null) {
                return;
            }
            this.editor.openOutlinePopup();
        });
        if (GamaBundleLoader.isDiagramEditorLoaded()) {
            this.diagram = gamaToolbarSimple.button("editor/command.graphical", null, "Switch to diagram", selectionEvent -> {
                if (this.editor == null) {
                    return;
                }
                this.editor.switchToDiagram();
            });
        }
        this.hookToCommands(this.previous, this.next);
        this.hookToSearch(this.previous, this.next);
        return this.find;
    }

    private void hookToSearch(ToolItem toolItem, ToolItem toolItem2) {
        this.find.getFindControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                EditorToolbar.this.searching = true;
                EditorToolbar.this.previous.removeSelectionListener((SelectionListener)EditorToolbar.this.globalPrevious);
                EditorToolbar.this.previous.setToolTipText("Search previous occurence");
                EditorToolbar.this.next.removeSelectionListener((SelectionListener)EditorToolbar.this.globalNext);
                EditorToolbar.this.next.setToolTipText("Search next occurence " + GamaKeyBindings.format((int)SWT.MOD1, (int)71));
                EditorToolbar.this.previous.addSelectionListener((SelectionListener)EditorToolbar.this.searchPrevious);
                EditorToolbar.this.next.addSelectionListener((SelectionListener)EditorToolbar.this.searchNext);
                EditorToolbar.this.previous.setEnabled(true);
                EditorToolbar.this.next.setEnabled(true);
            }

            public void focusLost(FocusEvent focusEvent) {
                EditorToolbar.this.searching = false;
                EditorToolbar.this.previous.removeSelectionListener((SelectionListener)EditorToolbar.this.searchPrevious);
                EditorToolbar.this.previous.setToolTipText("Previous edit location");
                EditorToolbar.this.next.removeSelectionListener((SelectionListener)EditorToolbar.this.searchNext);
                EditorToolbar.this.next.setToolTipText("Next edit location");
                EditorToolbar.this.previous.addSelectionListener((SelectionListener)EditorToolbar.this.globalPrevious);
                EditorToolbar.this.next.addSelectionListener((SelectionListener)EditorToolbar.this.globalNext);
                EditorToolbar.this.previous.setEnabled(WorkbenchHelper.getCommand((String)"org.eclipse.ui.navigate.backwardHistory").isEnabled());
                EditorToolbar.this.next.setEnabled(WorkbenchHelper.getCommand((String)"org.eclipse.ui.navigate.forwardHistory").isEnabled());
            }
        });
    }

    private void hookToCommands(ToolItem toolItem, ToolItem toolItem2) {
        WorkbenchHelper.runInUI((String)"Hooking to commands", (int)0, iProgressMonitor -> {
            Command command;
            Command command2 = WorkbenchHelper.getCommand((String)"org.eclipse.ui.navigate.forwardHistory");
            if (!toolItem2.isDisposed()) {
                toolItem2.setEnabled(command2.isEnabled());
                command = commandEvent -> toolItem2.setEnabled(this.searching || command2.isEnabled());
                command2.addCommandListener((ICommandListener)command);
                toolItem2.addDisposeListener(arg_0 -> EditorToolbar.lambda$8(command2, (ICommandListener)command, arg_0));
            }
            command = WorkbenchHelper.getCommand((String)"org.eclipse.ui.navigate.backwardHistory");
            if (!toolItem.isDisposed()) {
                ICommandListener iCommandListener = commandEvent -> toolItem.setEnabled(this.searching || command.isEnabled());
                toolItem.setEnabled(command.isEnabled());
                command.addCommandListener(iCommandListener);
                toolItem.addDisposeListener(disposeEvent -> command.removeCommandListener(iCommandListener));
            }
        });
    }

    private static /* synthetic */ void lambda$8(Command command, ICommandListener iCommandListener, DisposeEvent disposeEvent) {
        command.removeCommandListener(iCommandListener);
    }
}

