/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editor.toolbar;

import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gaml.compiler.ui.editor.GamlEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtext.ui.editor.outline.quickoutline.QuickOutlinePopup;

public class GamlQuickOutlinePopup
extends QuickOutlinePopup {
    private final Control textWidget;
    private final GamaToolbar2 toolbar;

    public GamlQuickOutlinePopup(GamlEditor gamlEditor, GamaToolbar2 gamaToolbar2) {
        super(gamlEditor.getEditorSite().getShell());
        this.setEditor(gamlEditor);
        this.textWidget = gamlEditor.getInternalSourceViewer().getTextWidget();
        this.toolbar = gamaToolbar2;
        this.setInput(gamlEditor.getDocument());
        this.setEvent(new Event());
    }

    protected TreeViewer createTreeViewer(Composite composite, int n) {
        TreeViewer treeViewer = super.createTreeViewer(composite, n);
        treeViewer.setAutoExpandLevel(-1);
        return treeViewer;
    }

    protected Point getDefaultLocation(Point point) {
        Point point2 = this.textWidget.getLocation();
        Point point3 = new Point(point2.x, 24);
        return this.toolbar.toDisplay(point3);
    }

    protected Point getInitialLocation(Point point) {
        Point point2 = this.textWidget.getLocation();
        Point point3 = new Point(point2.x, 24);
        return this.toolbar.toDisplay(point3);
    }

    protected Point getInitialSize() {
        Point point = this.textWidget.getSize();
        return new Point(point.x, point.y / 2);
    }

    protected Point getDefaultSize() {
        Point point = this.textWidget.getSize();
        return new Point(point.x, point.y / 2);
    }

    protected Color getBackground() {
        return IGamaColors.WHITE.color();
    }

    protected Color getForeground() {
        return IGamaColors.BLACK.color();
    }

    protected Text createFilterText(Composite composite) {
        Text text = new Text(composite, 640);
        text.setMessage("Search keyword");
        Dialog.applyDialogFont((Control)text);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        text.setLayoutData((Object)gridData);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13) {
                    GamlQuickOutlinePopup.this.gotoSelectedElement();
                }
                if (keyEvent.keyCode == 0x1000002) {
                    GamlQuickOutlinePopup.this.getTreeViewer().getTree().setFocus();
                }
                if (keyEvent.keyCode == 0x1000001) {
                    GamlQuickOutlinePopup.this.getTreeViewer().getTree().setFocus();
                }
                if (keyEvent.character == '\u001b') {
                    GamlQuickOutlinePopup.this.dispose();
                }
            }
        });
        return text;
    }
}

