/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.highlight;

import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.Pref;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.ui.shared.resources.GamaColors;
import java.util.Map;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public abstract class DelegateHighlightingConfiguration
implements IHighlightingConfiguration {
    public static final String OPERATOR_ID = "binary";
    public static final String RESERVED_ID = "reserved";
    public static final String FACET_ID = "facet";
    public static final String FIELD_ID = "field";
    public static final String GLOBAL_ID = "global";
    public static final String VARIABLE_ID = "variable";
    public static final String VARDEF_ID = "varDef";
    public static final String TYPE_ID = "typeDef";
    public static final String ASSIGN_ID = "assignment";
    public static final String UNIT_ID = "unit";
    public static final String PRAGMA_ID = "pragma";
    public static final String KEYWORD_ID = "keyword";
    public static final String PUNCTUATION_ID = "punctuation";
    public static final String COMMENT_ID = "comment";
    public static final String STRING_ID = "string";
    public static final String NUMBER_ID = "number";
    public static final String DEFAULT_ID = "default";
    public static final String INVALID_TOKEN_ID = "error";
    public static final String TASK_ID = "task";
    String theme;
    static final Map<String, String> TITLES = Map.ofEntries(Map.entry("keyword", "Statement keyword"), Map.entry("punctuation", "Punctuation character"), Map.entry("binary", "Operator & action call"), Map.entry("reserved", "Reserved symbol"), Map.entry("comment", "Comment"), Map.entry("string", "String"), Map.entry("number", "Literal constant"), Map.entry("default", "Default"), Map.entry("facet", "Facet key"), Map.entry("variable", "Variable"), Map.entry("varDef", "Variable definition"), Map.entry("typeDef", "Type"), Map.entry("assignment", "Assignment sign"), Map.entry("unit", "Unit & constant"), Map.entry("task", "Task"), Map.entry("pragma", "Pragma"), Map.entry("field", "Field"));
    final Map<String, TextStyle> styles = Map.ofEntries(Map.entry("keyword", this.keywordTextStyle()), Map.entry("punctuation", this.punctuationTextStyle()), Map.entry("binary", this.operatorTextStyle()), Map.entry("reserved", this.reservedTextStyle()), Map.entry("comment", this.commentTextStyle()), Map.entry("string", this.stringTextStyle()), Map.entry("number", this.numberTextStyle()), Map.entry("default", this.defaultTextStyle()), Map.entry("facet", this.facetTextStyle()), Map.entry("variable", this.variableTextStyle()), Map.entry("varDef", this.varDefTextStyle()), Map.entry("typeDef", this.typeTextStyle()), Map.entry("assignment", this.assignTextStyle()), Map.entry("unit", this.unitTextStyle()), Map.entry("task", this.taskTextStyle()), Map.entry("pragma", this.pragmaTextStyle()), Map.entry("field", this.fieldTextStyle()));

    TextStyle newStyle(int n, int n2, int n3, int n4) {
        TextStyle textStyle = this.newStyle(n);
        textStyle.setColor(new RGB(n2, n3, n4));
        return textStyle;
    }

    TextStyle newStyle(int n) {
        TextStyle textStyle = this.newStyle();
        textStyle.setStyle(n);
        return textStyle;
    }

    TextStyle newStyle() {
        return this.defaultTextStyle().copy();
    }

    public DelegateHighlightingConfiguration(String string) {
        this.theme = string;
        this.configurePreferences();
    }

    private void configure(IHighlightingConfigurationAcceptor iHighlightingConfigurationAcceptor, String string) {
        iHighlightingConfigurationAcceptor.acceptDefaultHighlighting(string, TITLES.get(string), this.styles.get(string));
    }

    public void configure(IHighlightingConfigurationAcceptor iHighlightingConfigurationAcceptor) {
        TITLES.keySet().forEach(string -> this.configure(iHighlightingConfigurationAcceptor, (String)string));
    }

    public void configurePreferences() {
        this.configure((string, string2, textStyle) -> {
            String string3 = "pref_" + string + "_color_" + this.theme;
            Pref pref = GamaPreferences.create((String)string3, (String)(this.theme + " theme " + string2 + " color"), () -> GamaColors.toGamaColor((RGB)textStyle.getColor()), (int)6, (boolean)false).in("Editors", "Syntax coloring (" + this.theme + " theme)").onChange(gamaColor -> this.applyColor(string, string2, textStyle, (GamaColor)gamaColor));
            this.applyColor(string, string2, textStyle, (GamaColor)pref.getValue());
            GamaColor gamaColor2 = (GamaColor)pref.getValue();
            if (gamaColor2 != null) {
                textStyle.setColor(new RGB(gamaColor2.red().intValue(), gamaColor2.green().intValue(), gamaColor2.blue().intValue()));
            }
        });
    }

    private void applyFont(String string, String string2, TextStyle textStyle, GamaFont gamaFont) {
        if (gamaFont != null) {
            textStyle.setFontData(new FontData[]{new FontData(gamaFont.getFontName(), gamaFont.getSize(), gamaFont.getStyle())});
        }
    }

    private void applyColor(String string, String string2, TextStyle textStyle, GamaColor gamaColor) {
        textStyle.setColor(new RGB(gamaColor.red().intValue(), gamaColor.green().intValue(), gamaColor.blue().intValue()));
    }

    abstract TextStyle facetTextStyle();

    abstract TextStyle pragmaTextStyle();

    abstract TextStyle typeTextStyle();

    abstract TextStyle assignTextStyle();

    abstract TextStyle variableTextStyle();

    abstract TextStyle fieldTextStyle();

    abstract TextStyle operatorTextStyle();

    abstract TextStyle reservedTextStyle();

    abstract TextStyle errorTextStyle();

    abstract TextStyle unitTextStyle();

    abstract TextStyle numberTextStyle();

    abstract TextStyle keywordTextStyle();

    abstract TextStyle punctuationTextStyle();

    abstract TextStyle stringTextStyle();

    abstract TextStyle varDefTextStyle();

    abstract TextStyle taskTextStyle();

    abstract TextStyle commentTextStyle();

    abstract TextStyle defaultTextStyle();
}

