/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.highlight;

import com.google.inject.Inject;
import gama.core.common.util.StringUtils;
import gama.dev.DEBUG;
import gaml.compiler.gaml.ArgumentDefinition;
import gaml.compiler.gaml.ArgumentPair;
import gaml.compiler.gaml.EGaml;
import gaml.compiler.gaml.Facet;
import gaml.compiler.gaml.GamlDefinition;
import gaml.compiler.gaml.HeadlessExperiment;
import gaml.compiler.gaml.Parameter;
import gaml.compiler.gaml.Pragma;
import gaml.compiler.gaml.S_Assignment;
import gaml.compiler.gaml.S_Definition;
import gaml.compiler.gaml.S_Display;
import gaml.compiler.gaml.Statement;
import gaml.compiler.gaml.StringLiteral;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.tasks.ITaskFinder;
import org.eclipse.xtext.tasks.Task;
import org.eclipse.xtext.util.CancelIndicator;

public class GamlSemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    @Inject
    private ITaskFinder taskFinder;
    private static Set<String> ASSIGNMENTS = new HashSet<String>(Arrays.asList("<-", "<<", ">>", "->", "<+", ">-", "<<+", ">>-", "+<-"));
    private IHighlightedPositionAcceptor acceptor;
    Set<INode> done = new HashSet<INode>();

    public void provideHighlightingFor(XtextResource xtextResource, IHighlightedPositionAcceptor iHighlightedPositionAcceptor, CancelIndicator cancelIndicator) {
        if (xtextResource == null) {
            return;
        }
        this.acceptor = iHighlightedPositionAcceptor;
        TreeIterator treeIterator = xtextResource.getAllContents();
        while (treeIterator.hasNext()) {
            this.process((EObject)treeIterator.next());
        }
        this.done.clear();
        this.highlightTasks(xtextResource);
    }

    protected void highlightTasks(XtextResource xtextResource) {
        List list = this.taskFinder.findTasks((Resource)xtextResource);
        for (Task task : list) {
            this.acceptor.addPosition(task.getOffset(), task.getTagLength(), new String[]{"task"});
        }
    }

    void process(EObject eObject) {
        if (eObject == null) {
            return;
        }
        this.process(eObject, eObject.eClass());
    }

    void process(EObject eObject, EClass eClass) {
        int n = eClass.getClassifierID();
        if ("envelope".equals(EGaml.getInstance().getKeyOf(eObject))) {
            DEBUG.OUT((Object)"");
        }
        switch (n) {
            case 6: {
                this.setStyle(eObject, "pragma", ((Pragma)eObject).getName(), false);
                break;
            }
            case 22: {
                String string = ((S_Assignment)eObject).getKey();
                this.setStyle(eObject, "assignment", string, false);
                break;
            }
            case 32: {
                Facet facet = (Facet)eObject;
                String string = facet.getKey();
                if (ASSIGNMENTS.contains(string)) {
                    this.setStyle(eObject, "assignment", 0);
                    break;
                }
                this.setStyle(eObject, "facet", 0);
                if (string.startsWith("type")) {
                    this.setStyle("typeDef", (INode)NodeModelUtils.getNode((EObject)facet.getExpr()));
                    break;
                }
                if (facet.getName() == null) break;
                this.setStyle(eObject, "varDef", 1);
                break;
            }
            case 49: {
                if (eObject instanceof StringLiteral) break;
                this.setStyle(eObject, "number", 0);
                break;
            }
            case 70: {
                this.setStyle(eObject, "reserved", 0);
                break;
            }
            case 53: 
            case 60: {
                this.setStyle(eObject, "binary", EGaml.getInstance().getKeyOf(eObject), true);
                break;
            }
            case 34: {
                this.setStyle(eObject, "variable", ((ArgumentPair)eObject).getOp(), false);
                break;
            }
            case 36: {
                this.setStyle("variable", (INode)NodeModelUtils.getNode((EObject)eObject));
                break;
            }
            case 62: {
                this.setStyle(eObject, "unit", 0);
                break;
            }
            case 63: {
                Statement statement = EGaml.getInstance().getStatement(eObject);
                if (statement instanceof S_Definition && ((S_Definition)statement).getTkey() == eObject) {
                    this.setStyle("keyword", (INode)NodeModelUtils.findActualNodeFor((EObject)eObject));
                    break;
                }
                this.setStyle("typeDef", (INode)NodeModelUtils.getNode((EObject)eObject));
                break;
            }
            case 61: {
                this.setStyle(eObject, "variable", ((Parameter)eObject).getBuiltInFacetKey(), false);
                break;
            }
            case 31: {
                this.setStyle(eObject, "varDef", ((ArgumentDefinition)eObject).getName(), false);
                break;
            }
            case 9: {
                Statement statement = (Statement)eObject;
                String string = this.findNameOf((EObject)statement);
                if (string != null) {
                    this.setStyle((EObject)statement, "varDef", string, false);
                }
                this.setStyle((EObject)statement, "keyword", statement.getKey(), false);
                break;
            }
            default: {
                EList eList = eClass.getESuperTypes();
                if (eList.isEmpty()) break;
                this.process(eObject, (EClass)eList.get(0));
            }
        }
    }

    private String findNameOf(EObject eObject) {
        if (eObject instanceof GamlDefinition) {
            return ((GamlDefinition)eObject).getName();
        }
        if (eObject instanceof S_Display) {
            return ((S_Display)eObject).getName();
        }
        if (eObject instanceof HeadlessExperiment) {
            return ((HeadlessExperiment)eObject).getName();
        }
        return null;
    }

    private final boolean setStyle(EObject eObject, String string, int n) {
        if (eObject != null && string != null) {
            ICompositeNode iCompositeNode = NodeModelUtils.getNode((EObject)eObject);
            if (iCompositeNode == null) {
                return false;
            }
            if (n > -1) {
                int n2 = 0;
                for (ILeafNode iLeafNode : iCompositeNode.getLeafNodes()) {
                    if (iLeafNode.isHidden()) continue;
                    if (n == n2) {
                        iCompositeNode = iLeafNode;
                        break;
                    }
                    ++n2;
                }
            }
            return this.setStyle(string, (INode)iCompositeNode);
        }
        return false;
    }

    private final boolean setStyle(String string, INode iNode) {
        if (!this.done.contains(iNode) && iNode != null) {
            this.done.add(iNode);
            this.acceptor.addPosition(iNode.getOffset(), iNode.getLength(), new String[]{string});
            return true;
        }
        return false;
    }

    private final boolean setStyle(EObject eObject, String string, String string2, boolean bl) {
        if (string2 == null) {
            return false;
        }
        if (eObject != null && string != null) {
            boolean bl2 = true;
            ICompositeNode iCompositeNode = NodeModelUtils.getNode((EObject)eObject);
            if (iCompositeNode == null) {
                return false;
            }
            for (ILeafNode iLeafNode : iCompositeNode.getLeafNodes()) {
                String string3;
                if (iLeafNode.isHidden() || !this.equalsFacetOrString(string2, string3 = StringUtils.toJavaString((String)NodeModelUtils.getTokenText((INode)iLeafNode)))) continue;
                iCompositeNode = iLeafNode;
                bl2 = this.setStyle(string, (INode)iCompositeNode);
                if (!bl) break;
            }
            return bl2;
        }
        return false;
    }

    boolean equalsFacetOrString(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        if (string2.equals(string)) {
            return true;
        }
        int n = string2.length();
        if (n == 0) {
            return false;
        }
        char c = string2.charAt(n - 1);
        switch (c) {
            case ':': {
                return string.equals(string2.substring(0, n - 1));
            }
            case '\"': 
            case '\'': {
                return string2.charAt(0) == c && n > 1 && string.equals(string2.substring(1, n - 1));
            }
        }
        return false;
    }
}

