/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.reference;

import com.google.common.collect.Lists;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.kernel.GamaSkillRegistry;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.interfaces.INamed;
import gama.gaml.types.Types;
import gama.ui.shared.resources.GamaIcon;
import gaml.compiler.ui.reference.GamlReferenceMenu;
import gaml.compiler.ui.templates.GamlTemplateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;

public class BuiltinReferenceMenu
extends GamlReferenceMenu {
    @Override
    protected void fillMenu() {
        String string;
        ArrayList arrayList;
        Object object2;
        ArrayList arrayList2 = new ArrayList(ModelDescription.ROOT.getMicroSpecies().values());
        ArrayList<String> arrayList3 = new ArrayList<String>();
        Collections.sort(arrayList2, INamed.COMPARATOR);
        Menu menu = this.sub("Built-in species");
        for (Object object2 : arrayList2) {
            arrayList3.add(object2.getName());
            this.fillSpeciesSubmenu(this.sub(menu, object2.getName()), (TypeDescription)object2);
        }
        object2 = new ArrayList(GamaSkillRegistry.INSTANCE.getSkillNames());
        Collections.sort(object2, IGNORE_CASE);
        menu = this.sub("Skills");
        Object object32 = object2.iterator();
        while (object32.hasNext()) {
            arrayList = (String)object32.next();
            this.fillSkillSubmenu(this.sub(menu, (String)((Object)arrayList)), (String)((Object)arrayList), false);
        }
        arrayList = new ArrayList(GamaSkillRegistry.INSTANCE.getArchitectureNames());
        Collections.sort(arrayList, IGNORE_CASE);
        menu = this.sub("Control architectures");
        for (Object object32 : arrayList) {
            this.fillSkillSubmenu(this.sub(menu, (String)object32), (String)object32, true);
        }
        object32 = Lists.newArrayList((Iterable)Types.getTypeNames());
        object32.removeAll(arrayList3);
        Collections.sort(object32, IGNORE_CASE);
        menu = this.sub("Types");
        ArrayList arrayList4 = new ArrayList();
        Iterator iterator = object32.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!string.contains("_file")) continue;
            arrayList4.add(string);
        }
        object32.removeAll(arrayList4);
        iterator = object32.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.fillTypeSubmenu(this.sub(menu, string), string);
        }
        menu = this.sub("File types");
        iterator = arrayList4.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            this.fillTypeSubmenu(this.sub(menu, string), string);
        }
    }

    private void fillTypeSubmenu(Menu menu, final String string) {
        BuiltinReferenceMenu.action((Menu)menu, (String)"Insert new attribute with this type", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuiltinReferenceMenu.this.applyTemplate(GamlTemplateFactory.attributeWithType(string));
            }
        });
        Map map = Types.get((String)string).getFieldGetters();
        ArrayList arrayList = new ArrayList(map.keySet());
        if (!arrayList.isEmpty()) {
            Collections.sort(arrayList);
            this.title(menu, "Attributes");
            for (String string2 : arrayList) {
                this.fillProtoSubMenu(this.sub(menu, string2), (OperatorProto)map.get(string2));
            }
        }
    }

    private void fillSkillSubmenu(Menu menu, final String string, final boolean bl) {
        ArrayList arrayList3;
        BuiltinReferenceMenu.action((Menu)menu, (String)"Insert name", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuiltinReferenceMenu.this.getEditor().insertText(string);
            }
        });
        BuiltinReferenceMenu.action((Menu)menu, (String)("Insert new species with this " + (bl ? "control" : "skill")), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!bl) {
                    BuiltinReferenceMenu.this.applyTemplate(GamlTemplateFactory.speciesWithSkill(string));
                } else {
                    BuiltinReferenceMenu.this.applyTemplate(GamlTemplateFactory.speciesWithControl(string));
                }
            }
        });
        ArrayList arrayList2 = Lists.newArrayList((Iterable)GamaSkillRegistry.INSTANCE.getVariablesForSkill(string));
        Collections.sort(arrayList2, INamed.COMPARATOR);
        if (!arrayList2.isEmpty()) {
            this.title(menu, "Attributes");
            for (ArrayList arrayList3 : arrayList2) {
                this.fillIDescriptionSubMenu(this.sub(menu, arrayList3.getName() + " (" + String.valueOf(arrayList3.getGamlType()) + ")"), (IDescription)arrayList3);
            }
        }
        arrayList3 = Lists.newArrayList((Iterable)GamaSkillRegistry.INSTANCE.getActionsForSkill(string));
        Collections.sort(arrayList3, INamed.COMPARATOR);
        if (!arrayList3.isEmpty()) {
            this.title(menu, "Primitives");
            for (Object object : arrayList3) {
                this.fillIDescriptionSubMenu(this.sub(menu, object.getName()), (IDescription)object);
            }
        }
        if (bl) {
            Object object;
            object = new ArrayList(GAML.getStatementsForSkill((String)string));
            Collections.sort(object, INamed.COMPARATOR);
            if (!object.isEmpty()) {
                this.title(menu, "Control statements");
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SymbolProto symbolProto = (SymbolProto)iterator.next();
                    this.fillProtoSubMenu(this.sub(menu, symbolProto.getName()), symbolProto);
                }
            }
        }
    }

    private void fillProtoSubMenu(Menu menu, final SymbolProto symbolProto) {
        BuiltinReferenceMenu.action((Menu)menu, (String)"Insert statement name", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuiltinReferenceMenu.this.getEditor().insertText(symbolProto.getName());
            }
        });
    }

    private void fillProtoSubMenu(Menu menu, final OperatorProto operatorProto) {
        BuiltinReferenceMenu.action((Menu)menu, (String)"Insert attribute name", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuiltinReferenceMenu.this.getEditor().insertText(operatorProto.getName());
            }
        });
    }

    private void fillSpeciesSubmenu(Menu menu, final TypeDescription typeDescription) {
        Object object;
        Object object22;
        BuiltinReferenceMenu.action((Menu)menu, (String)"Insert name", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuiltinReferenceMenu.this.getEditor().insertText(typeDescription.getName());
            }
        });
        BuiltinReferenceMenu.action((Menu)menu, (String)"Insert new child species", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuiltinReferenceMenu.this.applyTemplate(GamlTemplateFactory.speciesWithParent(typeDescription));
            }
        });
        ArrayList arrayList = new ArrayList(typeDescription.getAttributeNames());
        Collections.sort(arrayList, IGNORE_CASE);
        if (!arrayList.isEmpty()) {
            this.title(menu, "Attributes");
            for (Object object22 : arrayList) {
                object = typeDescription.getAttribute((String)object22);
                if (object.isSyntheticSpeciesContainer() || !object.getOriginName().endsWith(typeDescription.getName())) continue;
                this.fillIDescriptionSubMenu(this.sub(menu, (String)object22 + " (" + String.valueOf(object.getGamlType()) + ")"), (IDescription)object);
            }
        }
        object22 = new ArrayList(typeDescription.getActionNames());
        Collections.sort(object22, IGNORE_CASE);
        if (!object22.isEmpty()) {
            this.title(menu, "Primitives");
            object = object22.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                ActionDescription actionDescription = typeDescription.getAction(string);
                if (!actionDescription.getOriginName().endsWith(typeDescription.getName())) continue;
                this.fillIDescriptionSubMenu(this.sub(menu, string), (IDescription)actionDescription);
            }
        }
    }

    private void fillIDescriptionSubMenu(Menu menu, final IDescription iDescription) {
        boolean bl = iDescription instanceof VariableDescription;
        BuiltinReferenceMenu.action((Menu)menu, (String)"Insert name", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuiltinReferenceMenu.this.getEditor().insertText(iDescription.getName());
            }
        });
        if (bl) {
            BuiltinReferenceMenu.action((Menu)menu, (String)"Insert redefinition", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    BuiltinReferenceMenu.this.getEditor().insertText(iDescription.serializeToGaml(true));
                }
            });
        } else {
            BuiltinReferenceMenu.action((Menu)menu, (String)"Insert call", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    BuiltinReferenceMenu.this.getEditor().applyTemplate(GamlTemplateFactory.callToAction((StatementDescription)iDescription));
                }
            });
        }
    }

    @Override
    protected void openView() {
    }

    @Override
    protected Image getImage() {
        return GamaIcon.named((String)"editor/reference.builtin").image();
    }

    @Override
    protected String getTitle() {
        return "Built-In structures";
    }
}

