/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.reference;

import gama.core.util.GamaColor;
import gama.ui.shared.menus.GamaColorMenu;
import gama.ui.shared.resources.GamaIcon;
import gaml.compiler.ui.reference.GamlReferenceMenu;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ColorReferenceMenu
extends GamlReferenceMenu {
    GamaColorMenu colorMenu;
    GamaColorMenu.IColorRunnable runnable = (n, n2, n3) -> {
        GamaColor gamaColor = GamaColor.get((int)n, (int)n2, (int)n3, (int)255);
        this.applyText(gamaColor.serializeToGaml(true));
    };
    final SelectionListener colorInserter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.widget;
            ColorReferenceMenu.this.applyText(menuItem.getText());
        }
    };

    @Override
    protected void open(Decorations decorations, SelectionEvent selectionEvent) {
        if (this.colorMenu == null) {
            this.colorMenu = new GamaColorMenu(this.mainMenu);
        }
        ToolItem toolItem = (ToolItem)selectionEvent.widget;
        ToolBar toolBar = toolItem.getParent();
        this.colorMenu.open((Control)toolBar, selectionEvent, this.colorInserter, this.runnable);
    }

    @Override
    protected void openView() {
        GamaColorMenu.openView((GamaColorMenu.IColorRunnable)this.runnable, null);
    }

    @Override
    protected void fillMenu() {
        if (this.colorMenu == null) {
            this.colorMenu = new GamaColorMenu(this.mainMenu);
            this.colorMenu.setSelectionListener(this.colorInserter);
            this.colorMenu.setCurrentRunnable(this.runnable);
        }
        this.colorMenu.fillMenu();
    }

    @Override
    protected Image getImage() {
        return GamaIcon.named((String)"editor/reference.colors").image();
    }

    @Override
    protected String getTitle() {
        return "Colors";
    }
}

