/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.templates;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import gama.annotations.precompiler.GamlAnnotations;
import gama.annotations.precompiler.ISymbolKind;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.kernel.GamaSkillRegistry;
import gama.gaml.descriptions.AbstractProto;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.interfaces.INamed;
import gama.gaml.operators.Strings;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;

public class GamlTemplateFactory {
    static String beginComment = "/**" + Strings.LN;
    static String endComment = "*/" + Strings.LN;
    static String commentLine = Strings.LN + "* \t\t";
    static String inheritedAttributes = "* Inherited attributes:";
    static String inheritedActions = "* Inherited actions:";
    static String availableBehaviors = "* Available behaviors:";

    public static String getContextName() {
        return "Model";
    }

    public static String getContextId() {
        return "gaml.compiler.gaml.Gaml.Model";
    }

    public static TemplatePersistenceData from(GamlAnnotations.usage usage2, AbstractProto abstractProto) {
        Object object;
        String[] stringArray;
        boolean bl = false;
        String string = usage2.name();
        boolean bl2 = string.isEmpty();
        Object object2 = usage2.pattern();
        if (((String)object2).isEmpty()) {
            GamlAnnotations.example[] exampleArray = usage2.examples();
            int n = exampleArray.length;
            int n2 = 0;
            while (n2 < n) {
                stringArray = exampleArray[n2];
                if (bl2) {
                    string = stringArray.value();
                    bl2 = false;
                }
                if (!stringArray.isPattern()) {
                    bl = true;
                }
                object2 = (String)object2 + Strings.LN + stringArray.value();
                ++n2;
            }
        }
        if (((String)object2).isEmpty()) {
            return null;
        }
        object2 = (String)object2 + Strings.LN;
        stringArray = usage2.path();
        if (stringArray.length == 0) {
            stringArray = new String[]{StringUtils.capitalize((String)abstractProto.getName())};
        }
        Object object3 = "";
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String string2 = stringArray2[n3];
            object3 = (String)object3 + string2 + ".";
            ++n3;
        }
        String string3 = usage2.menu();
        if ("".equals(string3)) {
            string3 = ISymbolKind.TEMPLATE_MENU[abstractProto.getKind()];
        }
        if ("".equals(object = usage2.value())) {
            object = string3 + " " + string;
            object = (String)object + Strings.LN;
            String string4 = abstractProto.getDocumentation().toString();
            int n4 = string4.indexOf(". ");
            if (n4 == -1) {
                n4 = string4.length();
            }
            object = (String)object + string4.substring(0, Math.min(n4, 150)) + " [...]";
        }
        object3 = string3 + "." + ((String)object3).substring(0, ((String)object3).length() - 1);
        if (bl) {
            object3 = "Examples." + (String)object3;
        }
        Template template = new Template(string, (String)object, GamlTemplateFactory.getContextId(), (String)object2, true);
        return new TemplatePersistenceData(template, true, (String)object3);
    }

    private static String body(String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(" {").append(Strings.LN);
        stringBuilder.append(string);
        stringBuilder.append(Strings.LN).append("${cursor}");
        stringBuilder.append(Strings.LN).append("}").append(Strings.LN);
        return stringBuilder.toString();
    }

    private static void dump(String string, Iterable<? extends INamed> iterable, StringBuilder stringBuilder) {
        if (!Iterables.isEmpty(iterable)) {
            ArrayList arrayList = Lists.newArrayList(iterable);
            Collections.sort(arrayList, INamed.COMPARATOR);
            stringBuilder.append(string);
            for (INamed iNamed : arrayList) {
                stringBuilder.append(commentLine).append(iNamed.serializeToGaml(true));
            }
            stringBuilder.append(Strings.LN);
        }
    }

    public static Template speciesWithSkill(String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(beginComment);
        GamlTemplateFactory.dump(inheritedAttributes, GamaSkillRegistry.INSTANCE.getVariablesForSkill(string), stringBuilder);
        GamlTemplateFactory.dump(inheritedActions, GamaSkillRegistry.INSTANCE.getActionsForSkill(string), stringBuilder);
        stringBuilder.append(endComment);
        return new Template("A species with the skill " + string, "Defines a species that implements the skill named " + string, GamlTemplateFactory.getContextId(), "species ${species_name} skills: [" + string + "]" + GamlTemplateFactory.body(stringBuilder.toString()), true);
    }

    public static Template attributeWithType(String string) {
        return new Template("An attribute of type " + string, "Defines an attribute of type " + string, GamlTemplateFactory.getContextId(), string + " " + Types.get((String)string).asPattern() + " <- ${initial_value};", true);
    }

    public static Template speciesWithControl(String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(beginComment);
        GamlTemplateFactory.dump(inheritedAttributes, GamaSkillRegistry.INSTANCE.getVariablesForSkill(string), stringBuilder);
        GamlTemplateFactory.dump(inheritedActions, GamaSkillRegistry.INSTANCE.getActionsForSkill(string), stringBuilder);
        GamlTemplateFactory.dump(availableBehaviors, GAML.getStatementsForSkill((String)string), stringBuilder);
        stringBuilder.append(endComment);
        return new Template("A species with the control " + string, "Defines a species that implements the control named " + string, GamlTemplateFactory.getContextId(), "species ${species_name} control: " + string + GamlTemplateFactory.body(stringBuilder.toString()), true);
    }

    public static Template speciesWithParent(TypeDescription typeDescription) {
        String string = typeDescription.getName();
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(beginComment);
        GamlTemplateFactory.dump(inheritedAttributes, typeDescription.getAttributes(), stringBuilder);
        GamlTemplateFactory.dump(inheritedActions, typeDescription.getActions(), stringBuilder);
        stringBuilder.append(endComment);
        return new Template("A species with the parent " + string, "Defines a species that implements the control named " + string, GamlTemplateFactory.getContextId(), "species ${species_name} parent: " + string + GamlTemplateFactory.body(stringBuilder.toString()), true);
    }

    public static Template callToAction(StatementDescription statementDescription) {
        String string = statementDescription.getName();
        Iterable iterable = statementDescription.getFormalArgs();
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("(");
        for (IDescription iDescription : iterable) {
            stringBuilder.append(iDescription.getName()).append(": ").append("${the_").append(iDescription.getName()).append("}, ");
        }
        int n = stringBuilder.length();
        if (n > 0) {
            stringBuilder.setLength(n - 2);
        }
        stringBuilder.append(")");
        return new Template("A call to action " + string, "A call to action " + string + " will all its arguments", GamlTemplateFactory.getContextId(), "do " + string + stringBuilder.toString() + ";" + Strings.LN, true);
    }

    public static Template from(OperatorProto operatorProto) {
        Object object = operatorProto.getMainDoc();
        if (object == null) {
            object = "Template for using operator " + operatorProto.getName();
        }
        return new Template("Operator " + operatorProto.getName(), (String)object, GamlTemplateFactory.getContextId(), operatorProto.getPattern(true), true);
    }
}

