/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.utils;

import com.google.inject.Injector;
import com.google.inject.Singleton;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.kernel.experiment.TestAgent;
import gama.core.kernel.model.IModel;
import gama.core.runtime.GAMA;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;
import gama.gaml.statements.test.TestExperimentSummary;
import gama.ui.editor.internal.EditorActivator;
import gama.ui.navigator.view.contents.WrappedGamaFile;
import gama.ui.shared.interfaces.IModelRunner;
import gama.ui.shared.utils.WorkbenchHelper;
import gaml.compiler.gaml.validation.GamlModelBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

@Singleton
public class ModelRunner
extends AbstractServiceFactory
implements IModelRunner {
    private void editModelInternal(Object object) {
        if (object instanceof URI) {
            URI uRI = (URI)object;
            Injector injector = EditorActivator.getInstance().getInjector("gaml.compiler.Gaml");
            IURIEditorOpener iURIEditorOpener = (IURIEditorOpener)injector.getInstance(IURIEditorOpener.class);
            iURIEditorOpener.open(uRI, true);
        } else if (object instanceof EObject) {
            this.editModelInternal(EcoreUtil.getURI((EObject)((EObject)object)));
        } else if (object instanceof String) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IFile iFile = iWorkspace.getRoot().getFile((IPath)new Path((String)object));
            this.editModelInternal(iFile);
        } else if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            if (!iFile.exists()) {
                DEBUG.LOG((Object)("File " + iFile.getFullPath().toString() + " does not exist in the workspace"));
                return;
            }
            try {
                IDE.openEditor((IWorkbenchPage)WorkbenchHelper.getPage(), (IFile)iFile);
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        }
    }

    public void editModel(Object object) {
        WorkbenchHelper.asyncRun(() -> this.editModelInternal(object));
    }

    public List<TestExperimentSummary> runHeadlessTests(Object object) {
        IModel iModel = this.findModel(object);
        if (iModel == null) {
            return null;
        }
        List<String> list = iModel.getDescription().getExperimentNames().stream().filter(string -> iModel.getExperiment(string).isTest()).toList();
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<TestExperimentSummary> arrayList = new ArrayList<TestExperimentSummary>();
        for (String string2 : list) {
            IExperimentPlan iExperimentPlan = GAMA.addHeadlessExperiment((IModel)iModel, (String)string2, (ParametersSet)new ParametersSet(), null);
            if (iExperimentPlan == null) continue;
            iExperimentPlan.setHeadless(true);
            TestAgent testAgent = (TestAgent)iExperimentPlan.getAgent();
            testAgent.step(testAgent.getScope());
            arrayList.add((TestExperimentSummary)testAgent.getSummary());
            GAMA.closeExperiment((IExperimentPlan)iExperimentPlan);
        }
        return arrayList;
    }

    private IModel findModel(Object object) {
        if (object instanceof IModel) {
            return (IModel)object;
        }
        if (object instanceof WrappedGamaFile) {
            return this.findModel(((WrappedGamaFile)object).getResource());
        }
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            try {
                if (iFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0) == 2) {
                    GAMA.getGui().error("Model " + String.valueOf(iFile.getFullPath()) + " has errors and cannot be launched");
                    return null;
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
            return this.findModel(uRI);
        }
        if (object instanceof URI) {
            URI uRI = (URI)object;
            ArrayList arrayList = new ArrayList();
            IModel iModel = GamlModelBuilder.getDefaultInstance().compile(uRI, arrayList);
            if (iModel == null) {
                GAMA.getGui().error("File " + uRI.lastSegment() + " cannot be built because of " + arrayList.size() + " compilation errors");
            }
            return iModel;
        }
        if (object instanceof IXtextDocument) {
            IXtextDocument iXtextDocument = (IXtextDocument)object;
            IModel iModel = null;
            try {
                iModel = (IModel)iXtextDocument.readOnly(xtextResource -> GamlModelBuilder.getDefaultInstance().compile(xtextResource.getURI(), null));
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                GAMA.getGui().error("Experiment cannot be instantiated because of the following error: " + gamaRuntimeException.getMessage());
            }
            return iModel;
        }
        return null;
    }

    public void runModel(Object object, String string) {
        IModel iModel = this.findModel(object);
        if (iModel == null) {
            return;
        }
        GAMA.runGuiExperiment((String)string, (IModel)iModel);
    }

    public Object create(Class clazz, IServiceLocator iServiceLocator, IServiceLocator iServiceLocator2) {
        return this;
    }
}

