/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.editor.internal;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import gaml.compiler.GamlRuntimeModule;
import gaml.compiler.ui.GamlUiModule;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.shared.SharedStateModule;
import org.eclipse.xtext.util.Modules2;
import org.osgi.framework.BundleContext;

public class EditorActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "gama.ui.editor";
    public static final String GAML_COMPILER_GAML = "gaml.compiler.Gaml";
    private static final Logger logger = Logger.getLogger(EditorActivator.class);
    private static EditorActivator INSTANCE;
    private Map<String, Injector> injectors = Collections.synchronizedMap(Maps.newHashMapWithExpectedSize((int)1));

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        INSTANCE = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.injectors.clear();
        INSTANCE = null;
        super.stop(bundleContext);
    }

    public static EditorActivator getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector getInjector(String string) {
        Map<String, Injector> map = this.injectors;
        synchronized (map) {
            Injector injector = this.injectors.get(string);
            if (injector == null) {
                injector = this.createInjector(string);
                this.injectors.put(string, injector);
            }
            return injector;
        }
    }

    protected Injector createInjector(String string) {
        try {
            Module module = this.getRuntimeModule(string);
            Module module2 = this.getSharedStateModule();
            Module module3 = this.getUiModule(string);
            Module module4 = Modules2.mixin((Module[])new Module[]{module, module2, module3});
            return Guice.createInjector((Module[])new Module[]{module4});
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to create injector for " + string));
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            throw new RuntimeException("Failed to create injector for " + string, exception);
        }
    }

    protected Module getRuntimeModule(String string) {
        if (GAML_COMPILER_GAML.equals(string)) {
            return new GamlRuntimeModule();
        }
        throw new IllegalArgumentException(string);
    }

    protected Module getUiModule(String string) {
        if (GAML_COMPILER_GAML.equals(string)) {
            return new GamlUiModule(this);
        }
        throw new IllegalArgumentException(string);
    }

    protected Module getSharedStateModule() {
        return new SharedStateModule();
    }
}

