/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editbox;

import gaml.compiler.ui.editbox.BoxBuilderImpl;
import gaml.compiler.ui.editbox.BoxDecoratorImpl;
import gaml.compiler.ui.editbox.BoxSettingsImpl;
import gaml.compiler.ui.editbox.BoxSettingsStoreImpl;
import gaml.compiler.ui.editbox.IBoxBuilder;
import gaml.compiler.ui.editbox.IBoxDecorator;
import gaml.compiler.ui.editbox.IBoxEnabledEditor;
import gaml.compiler.ui.editbox.IBoxProvider;
import gaml.compiler.ui.editbox.IBoxSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class BoxProviderImpl
implements IBoxProvider {
    protected String id;
    protected String name;
    protected IBoxSettings editorsSettings;
    protected BoxSettingsStoreImpl settingsStore;
    protected Map<String, Class<? extends IBoxBuilder>> builders;
    protected Collection<String> defaultSettingsCatalog;
    private ArrayList<Matcher> matchers;

    @Override
    public BoxSettingsStoreImpl getSettingsStore() {
        if (this.settingsStore == null) {
            this.settingsStore = this.createSettingsStore();
            this.settingsStore.setProviderId(this.id);
        }
        return this.settingsStore;
    }

    @Override
    public IBoxSettings getEditorsBoxSettings() {
        if (this.editorsSettings == null) {
            this.editorsSettings = this.createSettings0();
            this.getSettingsStore().loadDefaults(this.editorsSettings);
            this.editorsSettings.addPropertyChangeListener(propertyChangeEvent -> {
                String string = propertyChangeEvent.getProperty();
                if (string != null && (string.equals(IBoxSettings.PropertiesKeys.FileNames.name()) || string.equals(IBoxSettings.PropertiesKeys.ALL.name()))) {
                    this.matchers = null;
                }
            });
        }
        return this.editorsSettings;
    }

    @Override
    public IBoxDecorator decorate(IWorkbenchPart iWorkbenchPart) {
        if (!(iWorkbenchPart instanceof IBoxEnabledEditor)) {
            return null;
        }
        IBoxSettings iBoxSettings = this.getEditorsBoxSettings();
        if (!iBoxSettings.getEnabled()) {
            return null;
        }
        ((IBoxEnabledEditor)iWorkbenchPart).createDecorator();
        return ((IBoxEnabledEditor)iWorkbenchPart).getDecorator();
    }

    @Override
    public boolean supports(IWorkbenchPart iWorkbenchPart) {
        return iWorkbenchPart.getAdapter(Control.class) instanceof StyledText && (this.supportsFile(iWorkbenchPart.getTitle()) || this.supportsFile(iWorkbenchPart.getTitleToolTip()));
    }

    protected boolean supportsFile(String string) {
        if (string != null) {
            for (Matcher matcher : this.getMatchers()) {
                if (!matcher.matches(string)) continue;
                return true;
            }
        }
        return false;
    }

    protected Collection<Matcher> getMatchers() {
        if (this.matchers == null) {
            this.matchers = new ArrayList();
            Collection<String> collection = this.getEditorsBoxSettings().getFileNames();
            if (collection != null) {
                for (String string : collection) {
                    this.matchers.add(new Matcher(string));
                }
            }
        }
        return this.matchers;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected BoxSettingsStoreImpl createSettingsStore() {
        BoxSettingsStoreImpl boxSettingsStoreImpl = new BoxSettingsStoreImpl();
        boxSettingsStoreImpl.setDefaultSettingsCatalog(this.defaultSettingsCatalog);
        return boxSettingsStoreImpl;
    }

    public void setDefaultSettingsCatalog(Collection<String> collection) {
        this.defaultSettingsCatalog = collection;
    }

    @Override
    public IBoxSettings createSettings() {
        BoxSettingsImpl boxSettingsImpl = this.createSettings0();
        boxSettingsImpl.copyFrom(this.getEditorsBoxSettings());
        return boxSettingsImpl;
    }

    protected BoxSettingsImpl createSettings0() {
        return new BoxSettingsImpl();
    }

    @Override
    public IBoxDecorator createDecorator() {
        BoxDecoratorImpl boxDecoratorImpl = new BoxDecoratorImpl();
        boxDecoratorImpl.setProvider(this);
        return boxDecoratorImpl;
    }

    @Override
    public Collection<String> getBuilders() {
        return this.builders != null ? this.builders.keySet() : null;
    }

    public void setBuilders(Map<String, Class<? extends IBoxBuilder>> map) {
        this.builders = map;
    }

    @Override
    public IBoxBuilder createBoxBuilder(String string) {
        Class<? extends IBoxBuilder> clazz = null;
        if (string != null && this.builders != null) {
            clazz = this.builders.get(string);
        }
        if (clazz == null) {
            return new BoxBuilderImpl();
        }
        try {
            return (IBoxBuilder)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    class Matcher {
        StringMatcher m;

        Matcher(String string) {
            this.m = new StringMatcher(string.trim(), true, false);
        }

        boolean matches(String string) {
            return this.m.match(string);
        }
    }
}

