/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.highlight;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import gama.core.util.GamaFont;
import gama.ui.application.workbench.ThemeHelper;
import gaml.compiler.ui.highlight.GamlHighlightingConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ITextAttributeProvider;
import org.eclipse.xtext.ui.editor.syntaxcoloring.PreferenceStoreAccessor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.editor.utils.TextStyle;
import org.eclipse.xtext.util.Strings;

@Singleton
public class GamlTextAttributeProvider
implements ITextAttributeProvider,
IHighlightingConfigurationAcceptor {
    private final HashMap<String, TextAttribute> attributes;
    private final GamlHighlightingConfiguration highlightingConfig;
    @Inject
    @Named(value="languageName")
    private String languageName;

    public static GamaFont getFont(TextStyle textStyle) {
        FontData[] fontDataArray = textStyle.getFontData();
        if (fontDataArray == null) {
            return null;
        }
        FontData fontData = fontDataArray[0];
        return new GamaFont(fontData.getName(), fontData.getStyle(), fontData.getHeight());
    }

    @Inject
    public GamlTextAttributeProvider(IHighlightingConfiguration iHighlightingConfiguration, IPreferenceStoreAccess iPreferenceStoreAccess, PreferenceStoreAccessor preferenceStoreAccessor) {
        this.highlightingConfig = (GamlHighlightingConfiguration)iHighlightingConfiguration;
        this.attributes = new HashMap();
        this.initialize();
        ThemeHelper.addListener(bl -> {
            this.highlightingConfig.changeTo(bl);
            this.initialize();
        });
    }

    private void initialize() {
        this.attributes.clear();
        this.highlightingConfig.configure(this);
    }

    public TextAttribute getAttribute(String string) {
        return this.attributes.get(string);
    }

    public TextAttribute getMergedAttributes(String[] stringArray) {
        if (stringArray.length < 2) {
            throw new IllegalStateException();
        }
        String string = this.getMergedIds(stringArray);
        TextAttribute textAttribute = this.getAttribute(string);
        if (textAttribute == null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                textAttribute = this.merge(textAttribute, this.getAttribute(string2));
                ++n2;
            }
            if (textAttribute != null) {
                this.attributes.put(string, textAttribute);
            } else {
                this.attributes.remove(string);
            }
        }
        return textAttribute;
    }

    private TextAttribute merge(TextAttribute textAttribute, TextAttribute textAttribute2) {
        Font font;
        Color color;
        if (textAttribute == null) {
            return textAttribute2;
        }
        if (textAttribute2 == null) {
            return textAttribute;
        }
        int n = textAttribute.getStyle() | textAttribute2.getStyle();
        Color color2 = textAttribute2.getForeground();
        if (color2 == null) {
            color2 = textAttribute.getForeground();
        }
        if ((color = textAttribute2.getBackground()) == null) {
            color = textAttribute.getBackground();
        }
        if ((font = textAttribute2.getFont()) == null) {
            font = textAttribute.getFont();
        }
        return new TextAttribute(color2, color, n, font);
    }

    public String getMergedIds(String[] stringArray) {
        return "$$$Merged:" + Strings.concat((String)"/", Arrays.asList(stringArray)) + "$$$";
    }

    public void acceptDefaultHighlighting(String string, String string2, TextStyle textStyle) {
        this.attributes.put(string, this.createTextAttribute(string, textStyle));
    }

    protected TextAttribute createTextAttribute(String string, TextStyle textStyle) {
        return new TextAttribute(EditorUtils.colorFromRGB((RGB)textStyle.getColor()), EditorUtils.colorFromRGB((RGB)textStyle.getBackgroundColor()), textStyle.getStyle(), EditorUtils.fontFromFontData((FontData[])textStyle.getFontData()));
    }
}

