/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.editor;

import gama.core.runtime.GAMA;
import gama.dev.DEBUG;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.access.ModelsFinder;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import gaml.compiler.gaml.indexer.GamlResourceIndexer;
import gaml.compiler.gaml.resource.GamlResource;
import gaml.compiler.ui.editor.GamlEditor;
import gaml.compiler.ui.reference.BuiltinReferenceMenu;
import gaml.compiler.ui.reference.ColorReferenceMenu;
import gaml.compiler.ui.reference.OperatorsReferenceMenu;
import gaml.compiler.ui.reference.TemplateReferenceMenu;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class EditorMenu
extends ContributionItem
implements IWorkbenchContribution {
    private static final SelectionAdapter UsedInAdapter;
    private static final SelectionAdapter OtherAdapter;

    static {
        DEBUG.ON();
        UsedInAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                URI uRI = (URI)menuItem.getData("uri");
                GAMA.getGui().editModel((Object)uRI);
            }
        };
        OtherAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.widget;
                URI uRI = (URI)menuItem.getData("uri");
                String string = (String)menuItem.getData("exp");
                if (uRI != null && string != null) {
                    GAMA.getGui().runModel((Object)uRI, string);
                }
            }
        };
    }

    public void initialize(IServiceLocator iServiceLocator) {
    }

    public void fill(Menu menu, int n) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("Model");
        Menu menu2 = new Menu(menuItem);
        if (menuItem.getMenu() != null) {
            menuItem.getMenu().dispose();
        }
        menuItem.setMenu(menu2);
        menu2.addListener(22, event -> {
            MenuItem[] menuItemArray = menu2.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                menuItem.dispose();
                ++n2;
            }
            if (this.getEditor() != null) {
                GamaMenu.separate((Menu)menu2, (String)"Insert");
                GamaMenu.separate((Menu)menu2);
                this.createReferenceMenus(menu2);
                GamaMenu.separate((Menu)menu2);
                GamaMenu.separate((Menu)menu2, (String)"Model");
                GamaMenu.separate((Menu)menu2);
                this.createUsedIn(menu2);
                this.createOtherExperiments(menu2);
                GamaMenu.separate((Menu)menu2);
                this.createValidate(menu2);
            }
        });
    }

    private void createReferenceMenus(Menu menu) {
        new TemplateReferenceMenu().installSubMenuIn(menu);
        new BuiltinReferenceMenu().installSubMenuIn(menu);
        new OperatorsReferenceMenu().installSubMenuIn(menu);
        new ColorReferenceMenu().installSubMenuIn(menu);
    }

    private void createOtherExperiments(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(" Other experiments...");
        menuItem.setImage(GamaIcon.named((String)"editor/other.experiments").image());
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        menu2.addListener(22, event -> {
            MenuItem[] menuItemArray = menu2.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                menuItem.dispose();
                ++n2;
            }
            EditorMenu.createOtherSubMenu(menu2, this.getEditor());
        });
    }

    public static Menu createOtherSubMenu(Menu menu, GamlEditor gamlEditor) {
        Map<URI, List<String>> map = EditorMenu.grabProjectModelsAndExperiments(gamlEditor);
        if (map.isEmpty()) {
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText("No experiments defined");
            menuItem.setEnabled(false);
            return menu;
        }
        for (URI uRI : map.keySet()) {
            MenuItem menuItem = new MenuItem(menu, 64);
            menuItem.setText(URI.decode((String)uRI.lastSegment()));
            menuItem.setImage(GamaIcon.named((String)"navigator/files/file.model").image());
            Menu menu2 = new Menu(menuItem);
            menuItem.setMenu(menu2);
            List<String> list = map.get(uRI);
            for (String string : list) {
                MenuItem menuItem2 = new MenuItem(menu2, 8);
                menuItem2.setText(string);
                menuItem2.setData("uri", (Object)uRI);
                menuItem2.setData("exp", (Object)string);
                menuItem2.setImage(GamaIcon.named((String)(ThemeHelper.isDark() ? "overlays/small.exp.run.white" : "overlays/small.exp.run.green")).image());
                menuItem2.addSelectionListener((SelectionListener)OtherAdapter);
            }
        }
        return menu;
    }

    private static Map<URI, List<String>> grabProjectModelsAndExperiments(final GamlEditor gamlEditor) {
        final TreeMap<URI, List<String>> treeMap = new TreeMap<URI, List<String>>(Comparator.comparing(URI::lastSegment));
        gamlEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource xtextResource) throws Exception {
                String string = xtextResource.getURI().toPlatformString(true);
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string));
                IProject iProject = iFile.getProject();
                List list = ModelsFinder.getAllGamaURIsInProject((IProject)iProject);
                ResourceSet resourceSet = gamlEditor.resourceSetProvider.get(iProject);
                for (URI uRI : list) {
                    ISyntacticElement iSyntacticElement2;
                    GamlResource gamlResource = (GamlResource)resourceSet.getResource(uRI, true);
                    if (gamlResource.hasErrors() || (iSyntacticElement2 = gamlResource.getSyntacticContents()) == null) continue;
                    iSyntacticElement2.visitExperiments(iSyntacticElement -> {
                        if (!treeMap.containsKey(uRI)) {
                            treeMap.put(uRI, new ArrayList());
                        }
                        ((List)treeMap.get(uRI)).add(iSyntacticElement.getName());
                    });
                }
            }
        });
        return treeMap;
    }

    private void createUsedIn(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(" Imported in...");
        menuItem.setImage(GamaIcon.named((String)"editor/imported.in").image());
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        menu2.addListener(22, event -> {
            MenuItem[] menuItemArray = menu2.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                menuItem.dispose();
                ++n2;
            }
            EditorMenu.createImportedSubMenu(menu2, this.getEditor());
        });
    }

    public static Menu createImportedSubMenu(Menu menu, GamlEditor gamlEditor) {
        Set<URI> set = EditorMenu.getImporters(gamlEditor);
        if (set.isEmpty()) {
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText("No importers");
            menuItem.setEnabled(false);
            return menu;
        }
        for (URI uRI : set) {
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText(URI.decode((String)uRI.lastSegment()));
            menuItem.setImage(GamaIcon.named((String)"navigator/files/file.model").image());
            menuItem.setData("uri", (Object)uRI);
            menuItem.addSelectionListener((SelectionListener)UsedInAdapter);
        }
        return menu;
    }

    private static Set<URI> getImporters(GamlEditor gamlEditor) {
        final HashSet<URI> hashSet = new HashSet<URI>();
        gamlEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource xtextResource) throws Exception {
                Set set = GamlResourceIndexer.directImportersOf((URI)xtextResource.getURI());
                DEBUG.OUT((Object)("Importers of " + xtextResource.getURI().lastSegment() + ": " + String.valueOf(set)));
                hashSet.addAll(set);
            }
        });
        return hashSet;
    }

    private void createValidate(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(" Validate");
        menuItem.setImage(GamaIcon.named((String)"build/build.project").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    WorkbenchHelper.runCommand((String)"gaml.compiler.gaml.Gaml.validate");
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
            }
        });
    }

    GamlEditor getEditor() {
        return (GamlEditor)WorkbenchHelper.getActiveEditor();
    }
}

