/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.editor;

import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.Pref;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import gaml.compiler.ui.editor.GamlEditor;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class EditorPresentationMenu
extends ContributionItem
implements IWorkbenchContribution {
    Pref<Boolean> markPref;

    public void initialize(IServiceLocator iServiceLocator) {
    }

    public void fill(Menu menu, int n) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("Presentation");
        menuItem.setImage(GamaIcon.named((String)"display/menu.presentation").image());
        Menu menu2 = new Menu(menuItem);
        if (menuItem.getMenu() != null) {
            menuItem.getMenu().dispose();
        }
        menuItem.setMenu(menu2);
        menu2.addListener(22, event -> {
            this.markPref = GamaPreferences.get((String)"pref_editor_mark_occurrences", Boolean.class);
            MenuItem[] menuItemArray = menu2.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                menuItem.dispose();
                ++n2;
            }
            if (this.getEditor() != null) {
                this.createLineToggle(menu2);
                this.createFoldingToggle(menu2);
                this.createMarkToggle(menu2);
                this.createBoxToggle(menu2);
                this.createOverviewToggle(menu2);
                this.createWordWrapToggle(menu2);
            }
        });
    }

    private void createBoxToggle(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(" Toggle code sections colorization");
        menuItem.setImage(GamaIcon.named((String)"editor/toggle.box").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = !EditorPresentationMenu.this.getEditor().isDecorationEnabled();
                EditorPresentationMenu.this.getEditor().setDecorationEnabled(bl);
                EditorPresentationMenu.this.getEditor().decorate(bl);
            }
        });
    }

    private void createMarkToggle(Menu menu) {
        final MenuItem menuItem = new MenuItem(menu, 8);
        boolean bl = (Boolean)this.markPref.getValue();
        menuItem.setText(bl ? " Do not mark symbols occurences" : " Mark occurences of symbols");
        menuItem.setImage(GamaIcon.named((String)"editor/toggle.mark").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditorPresentationMenu.this.markPref.set((Object)menuItem.getSelection()).save();
            }
        });
    }

    private void createWordWrapToggle(Menu menu) {
        final MenuItem menuItem = new MenuItem(menu, 8);
        boolean bl = this.getEditor().isWordWrapEnabled();
        menuItem.setText(bl ? " Turn Word Wrap off" : " Turn Word Wrap on");
        menuItem.setImage(GamaIcon.named((String)"editor/menu.delimiter").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditorPresentationMenu.this.getEditor().setWordWrap(menuItem.getSelection());
            }
        });
    }

    private void createOverviewToggle(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 8);
        boolean bl = this.getEditor().isOverviewRulerVisible();
        menuItem.setText(bl ? " Hide markers overview" : " Show markers overview");
        menuItem.setImage(GamaIcon.named((String)"editor/toggle.overview").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = EditorPresentationMenu.this.getEditor().isOverviewRulerVisible();
                if (bl) {
                    EditorPresentationMenu.this.getEditor().hideOverviewRuler();
                } else {
                    EditorPresentationMenu.this.getEditor().showOverviewRuler();
                }
            }
        });
    }

    private void createFoldingToggle(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 8);
        boolean bl = this.getEditor().isRangeIndicatorEnabled();
        menuItem.setText(bl ? " Unfold code sections" : " Fold code sections");
        menuItem.setSelection(bl);
        menuItem.setImage(GamaIcon.named((String)"editor/toggle.folding").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditorPresentationMenu.this.getEditor().getAction("FoldingToggle").run();
            }
        });
    }

    private void createLineToggle(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 8);
        boolean bl = this.getEditor().isLineNumberRulerVisible();
        menuItem.setText(bl ? " Hide line numbers" : " Display line numbers");
        menuItem.setImage(GamaIcon.named((String)"editor/toggle.numbers").image());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditorPresentationMenu.this.getEditor().getAction("Linenumbers.Toggle").run();
            }
        });
    }

    GamlEditor getEditor() {
        return (GamlEditor)WorkbenchHelper.getActiveEditor();
    }
}

