/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editor.toolbar;

import gama.core.runtime.PlatformHelper;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.bindings.GamaKeyBindings;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.views.toolbar.GamaToolbarSimple;
import gaml.compiler.ui.editor.GamlEditor;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.swt.IFocusService;

public class EditorSearchControls {
    static final String EMPTY = "Find... (" + GamaKeyBindings.format((int)SWT.MOD1, (int)71) + ")";
    Text find;
    int incrementalOffset = -1;
    final GamlEditor editor;
    private final ModifyListener modifyListener = new ModifyListener(){
        private String lastText = EMPTY;

        public void modifyText(ModifyEvent modifyEvent) {
            boolean bl = true;
            String string = EditorSearchControls.this.find.getText();
            if (this.lastText.startsWith(string)) {
                bl = false;
            }
            this.lastText = string;
            if (EMPTY.equals(string) || "".equals(string)) {
                ISelection iSelection;
                EditorSearchControls.this.adjustEnablement(false, null);
                ISelectionProvider iSelectionProvider = EditorSearchControls.this.editor.getSelectionProvider();
                if (iSelectionProvider != null && (iSelection = iSelectionProvider.getSelection()) instanceof TextSelection) {
                    ITextSelection iTextSelection = (ITextSelection)iSelection;
                    iSelectionProvider.setSelection((ISelection)new TextSelection(iTextSelection.getOffset(), 0));
                }
            } else {
                EditorSearchControls.this.find(true, true, bl);
            }
        }
    };

    public EditorSearchControls(GamlEditor gamlEditor) {
        this.editor = gamlEditor;
    }

    public EditorSearchControls fill(GamaToolbarSimple gamaToolbarSimple) {
        GridLayout gridLayout;
        GridData gridData;
        GamaToolbarSimple gamaToolbarSimple2 = gamaToolbarSimple;
        Color color = gamaToolbarSimple2.getBackground();
        if (PlatformHelper.isWindows()) {
            gamaToolbarSimple2 = new Composite((Composite)gamaToolbarSimple, 0);
            gridData = new GridData(4, 4, true, true);
            gridData.heightHint = 24;
            gridData.widthHint = 100;
            gamaToolbarSimple2.setLayoutData((Object)gridData);
            gridLayout = new GridLayout();
            gamaToolbarSimple2.setLayout((Layout)gridLayout);
            GamaColors.setBackground((Color)color, (Control[])new Control[]{gamaToolbarSimple2});
        }
        this.find = new Text((Composite)gamaToolbarSimple2, 640);
        gridData = (IFocusService)this.editor.getSite().getService(IFocusService.class);
        gridData.addFocusTracker((Control)this.find, "search");
        gridLayout = new GridData(4, 4, true, true);
        gridLayout.heightHint = 24;
        gridLayout.widthHint = 100;
        this.find.setLayoutData((Object)gridLayout);
        this.find.setMessage(EMPTY);
        this.find.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                EditorSearchControls.this.find.setText("");
            }

            public void focusGained(FocusEvent focusEvent) {
                EditorSearchControls.this.adjustEnablement(false, null);
                EditorSearchControls.this.incrementalOffset = -1;
            }
        });
        GamaColors.setBackAndForeground((Color)color, (Color)(ThemeHelper.isDark() ? IGamaColors.VERY_LIGHT_GRAY.color() : IGamaColors.VERY_DARK_GRAY.color()), (Control[])new Control[]{this.find});
        gamaToolbarSimple.control((Control)(gamaToolbarSimple2 == gamaToolbarSimple ? this.find : gamaToolbarSimple2), 100);
        this.find.addModifyListener(this.modifyListener);
        this.find.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    EditorSearchControls.this.editor.setFocus();
                }
            }
        });
        this.adjustEnablement(false, null);
        return this;
    }

    public Text getFindControl() {
        return this.find;
    }

    void adjustEnablement(boolean bl, Color color) {
        if (color == null) {
            this.find.setForeground(IGamaColors.WIDGET_FOREGROUND.color());
        } else {
            this.find.setForeground(color);
        }
    }

    public void findPrevious() {
        this.find(false);
    }

    public void findNext() {
        this.find(true);
    }

    private void find(boolean bl) {
        this.find(bl, false);
    }

    private void find(boolean bl, boolean bl2) {
        this.find(bl, bl2, true, false);
    }

    void find(boolean bl, boolean bl2, boolean bl3) {
        this.find(bl, bl2, bl3, false);
    }

    private void find(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        IFindReplaceTarget iFindReplaceTarget = (IFindReplaceTarget)this.editor.getAdapter(IFindReplaceTarget.class);
        if (iFindReplaceTarget != null) {
            try {
                String string = this.find.getText();
                if (iFindReplaceTarget instanceof IFindReplaceTargetExtension) {
                    IFindReplaceTargetExtension iFindReplaceTargetExtension = (IFindReplaceTargetExtension)iFindReplaceTarget;
                    iFindReplaceTargetExtension.beginSession();
                }
                ISourceViewer iSourceViewer = this.getSourceViewer();
                StyledText styledText = iSourceViewer.getTextWidget();
                int n = styledText.getCaretOffset();
                Point point = styledText.getSelection();
                if (bl4) {
                    n = bl ? 0 : iSourceViewer.getDocument().getLength() - 1;
                } else if (bl) {
                    if (bl2) {
                        if (this.incrementalOffset == -1) {
                            this.incrementalOffset = n;
                        } else {
                            n = this.incrementalOffset;
                        }
                    } else {
                        this.incrementalOffset = point.x;
                    }
                } else {
                    this.incrementalOffset = point.x;
                    if (point.x != n) {
                        n = point.x;
                    }
                }
                int n2 = -1;
                n2 = iFindReplaceTarget instanceof IFindReplaceTargetExtension3 ? ((IFindReplaceTargetExtension3)iFindReplaceTarget).findAndSelect(n, string, bl, false, false, false) : iFindReplaceTarget.findAndSelect(n, string, bl, false, false);
                if (n2 != -1) {
                    this.adjustEnablement(true, IGamaColors.OK.inactive());
                    point = styledText.getSelection();
                    if (!bl) {
                        this.incrementalOffset = point.x;
                    }
                } else {
                    if (bl3 && !bl4) {
                        this.find(bl, bl2, bl3, true);
                        return;
                    }
                    if (!EMPTY.equals(string) && !"".equals(string)) {
                        this.adjustEnablement(false, IGamaColors.ERROR.inactive());
                    }
                }
            }
            finally {
                if (iFindReplaceTarget instanceof IFindReplaceTargetExtension) {
                    IFindReplaceTargetExtension iFindReplaceTargetExtension = (IFindReplaceTargetExtension)iFindReplaceTarget;
                    iFindReplaceTargetExtension.endSession();
                }
            }
        }
    }

    private ISourceViewer getSourceViewer() {
        return (ISourceViewer)this.editor.getAdapter(ITextOperationTarget.class);
    }
}

