/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.reference;

import gama.core.common.preferences.GamaPreferences;
import gama.core.util.IMap;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.types.Signature;
import gama.ui.shared.resources.GamaIcon;
import gaml.compiler.ui.reference.GamlReferenceMenu;
import gaml.compiler.ui.templates.GamlTemplateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class OperatorsReferenceMenu
extends GamlReferenceMenu {
    public static Boolean byName = null;

    @Override
    protected void fillMenu() {
        if (byName == null) {
            byName = "Name".equals(GamaPreferences.Modeling.OPERATORS_MENU_SORT.getValue());
        }
        if (byName.booleanValue()) {
            this.fillMenuByName();
        } else {
            this.fillMenuByCategory();
        }
    }

    protected void fillMenuByName() {
        Map map = GAML.OPERATORS;
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList, IGNORE_CASE);
        for (String string : arrayList) {
            Signature signature2;
            ArrayList<OperatorProto> arrayList2 = new ArrayList<OperatorProto>();
            for (Signature signature2 : ((IMap)map.get(string)).keySet()) {
                OperatorProto operatorProto = (OperatorProto)((IMap)map.get(string)).get((Object)signature2);
                if (operatorProto.getDeprecated() != null) continue;
                arrayList2.add(operatorProto);
            }
            if (arrayList2.isEmpty()) continue;
            signature2 = this.sub(string);
            for (OperatorProto operatorProto : arrayList2) {
                final Template template = GamlTemplateFactory.from(operatorProto);
                MenuItem menuItem = OperatorsReferenceMenu.action((Menu)signature2, (String)("(" + operatorProto.signature.asPattern(false) + ") -> " + operatorProto.returnType.serializeToGaml(true)), (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        OperatorsReferenceMenu.this.applyTemplate(template);
                    }
                });
                menuItem.setToolTipText(template.getDescription());
            }
        }
    }

    protected void fillMenuByCategory() {
        Menu menu;
        Cloneable cloneable;
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Map map = GAML.OPERATORS;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList, IGNORE_CASE);
        for (Object object42 : arrayList) {
            object3 = (Map)map.get(object42);
            for (Signature signature : object3.keySet()) {
                object2 = (OperatorProto)object3.get(signature);
                if (object2.getDeprecated() != null) continue;
                object = object2.getCategory().replace("-related", "");
                cloneable = (LinkedHashMap<Object, Menu>)linkedHashMap.get(object);
                if (cloneable == null) {
                    cloneable = new LinkedHashMap<Object, Menu>();
                    linkedHashMap.put(object, cloneable);
                }
                if ((menu = (Menu)cloneable.get(object42)) == null) {
                    menu = new LinkedHashMap();
                    cloneable.put(object42, menu);
                }
                menu.put(object2, GamlTemplateFactory.from(object2));
            }
        }
        object42 = new ArrayList(linkedHashMap.keySet());
        Collections.sort(object42, IGNORE_CASE);
        object3 = object42.iterator();
        while (object3.hasNext()) {
            Signature signature;
            String string = (String)object3.next();
            signature = this.sub(string);
            ArrayList arrayList2 = new ArrayList(((Map)linkedHashMap.get(string)).keySet());
            Collections.sort(arrayList2, IGNORE_CASE);
            object = arrayList2.iterator();
            while (object.hasNext()) {
                object2 = (String)object.next();
                cloneable = new ArrayList(((Map)((Map)linkedHashMap.get(string)).get(object2)).keySet());
                menu = this.sub((Menu)signature, (String)object2);
                Iterator iterator = cloneable.iterator();
                while (iterator.hasNext()) {
                    OperatorProto operatorProto = (OperatorProto)iterator.next();
                    final Template template = (Template)((Map)((Map)linkedHashMap.get(string)).get(object2)).get(operatorProto);
                    MenuItem menuItem = OperatorsReferenceMenu.action((Menu)menu, (String)("(" + operatorProto.signature.asPattern(false) + ") -> " + operatorProto.returnType.serializeToGaml(true)), (SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            OperatorsReferenceMenu.this.applyTemplate(template);
                        }
                    });
                    menuItem.setToolTipText(template.getDescription());
                }
            }
        }
    }

    @Override
    protected void openView() {
    }

    @Override
    protected Image getImage() {
        return GamaIcon.named((String)"editor/reference.operators").image();
    }

    @Override
    protected String getTitle() {
        return "Operators";
    }
}

