/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.decorators;

import com.google.inject.Inject;
import gama.ui.shared.resources.GamaIcon;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.xtext.ui.editor.model.XtextMarkerAnnotationImageProvider;
import org.eclipse.xtext.ui.editor.validation.XtextAnnotation;

public class GamlAnnotationImageProvider
extends XtextMarkerAnnotationImageProvider {
    private static final GamaIcon DELETED = GamaIcon.named((String)"markers/marker.deleted");
    private static final GamaIcon ERROR = GamaIcon.named((String)"markers/marker.error");
    private static final GamaIcon WARNING = GamaIcon.named((String)"markers/marker.warning");
    private static final GamaIcon INFO = GamaIcon.named((String)"markers/marker.info");
    private static final GamaIcon TASK = GamaIcon.named((String)"markers/marker.task");
    private static final Map<String, GamaIcon> deleted = new HashMap(){
        {
            this.put("org.eclipse.xtext.ui.editor.error", DELETED);
            this.put("org.eclipse.xtext.ui.editor.warning", DELETED);
            this.put("org.eclipse.xtext.ui.editor.info", DELETED);
            this.put("org.eclipse.ui.workbench.texteditor.task", DELETED);
        }
    };

    @Inject
    public GamlAnnotationImageProvider() {
    }

    public Image getManagedImage(Annotation annotation) {
        GamaIcon gamaIcon = null;
        if (annotation.isMarkedDeleted()) {
            gamaIcon = deleted.get(annotation.getType());
        } else if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
            gamaIcon = this.getImage(annotation.getType());
        } else {
            if (annotation instanceof ProjectionAnnotation) {
                return null;
            }
            if (annotation instanceof XtextAnnotation) {
                XtextAnnotation xtextAnnotation = (XtextAnnotation)annotation;
                gamaIcon = this.getImage(annotation.getType());
            }
        }
        if (gamaIcon != null) {
            return gamaIcon.image();
        }
        return super.getManagedImage(annotation);
    }

    public GamaIcon getImage(String string) {
        return switch (string) {
            case "org.eclipse.xtext.ui.editor.error" -> ERROR;
            case "org.eclipse.xtext.ui.editor.warning" -> WARNING;
            case "org.eclipse.xtext.ui.editor.info" -> INFO;
            case "org.eclipse.ui.workbench.texteditor.task" -> TASK;
            default -> null;
        };
    }
}

