/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.IPreferenceChangeListener;
import gama.dev.DEBUG;
import gama.ui.shared.commands.TestsRunner;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.views.toolbar.GamaCommand;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.GamaToolbarSimple;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import gaml.compiler.gaml.indexer.GamlResourceIndexer;
import gaml.compiler.gaml.resource.GamlResourceServices;
import gaml.compiler.gaml.validation.GamlResourceValidator;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.views.markers.ConfigureContentsDialogHandler;
import org.eclipse.ui.internal.views.markers.MarkersTreeViewer;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.MarkerSupportView;

public class SyntaxErrorsView
extends MarkerSupportView
implements IToolbarDecoratedView.Expandable {
    protected Composite parent;
    protected GamaToolbar2 toolbar;
    final BuildPreferenceChangeListener listener = new BuildPreferenceChangeListener(this);

    static {
        DEBUG.ON();
    }

    public SyntaxErrorsView() {
        super("gaml.compiler.gaml.ui.error.generator");
        GamaPreferences.Modeling.WARNINGS_ENABLED.addChangeListener((IPreferenceChangeListener)this.listener);
        GamaPreferences.Modeling.INFO_ENABLED.addChangeListener((IPreferenceChangeListener)this.listener);
    }

    public void createPartControl(Composite composite) {
        this.parent = GamaToolbarFactory.createToolbars((IToolbarDecoratedView)this, (Composite)composite);
        super.createPartControl(this.parent);
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.removeAll();
        iToolBarManager.update(true);
        MarkersTreeViewer markersTreeViewer = (MarkersTreeViewer)this.getAdapter(MarkersTreeViewer.class);
        markersTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof MarkerItem) {
                    MarkerItem markerItem = (MarkerItem)object2;
                    IMarker iMarker = markerItem.getMarker();
                    if (iMarker == null) {
                        return true;
                    }
                    String string = iMarker.getAttribute("message", "");
                    if (string.contains("imported from")) {
                        return false;
                    }
                }
                return true;
            }
        });
    }

    public void dispose() {
        super.dispose();
        GamaPreferences.Modeling.WARNINGS_ENABLED.removeChangeListener((IPreferenceChangeListener)this.listener);
        GamaPreferences.Modeling.INFO_ENABLED.removeChangeListener((IPreferenceChangeListener)this.listener);
    }

    protected void setContentDescription(String string) {
        this.toolbar.status("navigator/status.info", string, selectionEvent -> this.openFilterDialog(), null);
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        this.toolbar = gamaToolbar2;
        GamaToolbarSimple gamaToolbarSimple = this.toolbar.getToolbar(131072);
        gamaToolbarSimple.button("editor/local.menu", "More...", "More options", selectionEvent -> {
            GamaMenu gamaMenu = new GamaMenu(){

                protected void fillMenu() {
                    boolean bl = (Boolean)GamaPreferences.Modeling.WARNINGS_ENABLED.getValue();
                    GamaCommand.build((String)"validation/toggle.warnings", (String)(bl ? "Hide warnings" : "Show warnings"), null, selectionEvent -> GamaPreferences.Modeling.WARNINGS_ENABLED.set((Object)((MenuItem)selectionEvent.widget).getSelection()).save()).toCheckItem(this.mainMenu).setSelection(bl);
                    bl = (Boolean)GamaPreferences.Modeling.INFO_ENABLED.getValue();
                    GamaCommand.build((String)"validation/toggle.infos", (String)(bl ? "Hide info markers" : "Show info markers"), null, selectionEvent -> GamaPreferences.Modeling.INFO_ENABLED.set((Object)((MenuItem)selectionEvent.widget).getSelection()).save()).toCheckItem(this.mainMenu).setSelection(bl);
                    GamaMenu.separate((Menu)this.mainMenu);
                    GamaCommand.build((String)"validation/compile.all", (String)"Validate all projects", null, selectionEvent -> SyntaxErrorsView.build()).toItem(this.mainMenu);
                    GamaCommand.build((String)"validation/test.run", (String)"Run all tests", null, selectionEvent -> TestsRunner.start()).toItem(this.mainMenu);
                }
            };
            gamaMenu.open((Control)gamaToolbarSimple, selectionEvent, gamaToolbarSimple.getSize().y, 0);
        });
    }

    void openFilterDialog() {
        EvaluationContext evaluationContext = new EvaluationContext(null, (Object)this);
        evaluationContext.addVariable("activePart", (Object)this);
        ExecutionEvent executionEvent = new ExecutionEvent(null, new HashMap(), (Object)this, (Object)evaluationContext);
        new ConfigureContentsDialogHandler().execute(executionEvent);
    }

    private static void doBuild(IProgressMonitor iProgressMonitor) {
        GamlResourceServices.getResourceDocumenter().invalidateAll();
        GamlResourceIndexer.eraseIndex();
        try {
            DEBUG.BANNER((String)"COMPIL", (String)"Last compilation of all models", (String)"in", (String)String.valueOf(GamlResourceValidator.DURATION()));
            GamlResourceValidator.RESET();
            ResourcesPlugin.getWorkspace().build(15, iProgressMonitor);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    static void build() {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
        progressMonitorDialog.setBlockOnOpen(false);
        progressMonitorDialog.setCancelable(true);
        progressMonitorDialog.setOpenOnRun(true);
        try {
            progressMonitorDialog.run(true, true, SyntaxErrorsView::doBuild);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }

    public void expandAll() {
        ((MarkersTreeViewer)this.getAdapter(MarkersTreeViewer.class)).expandAll();
    }

    public void collapseAll() {
        ((MarkersTreeViewer)this.getAdapter(MarkersTreeViewer.class)).collapseAll();
    }

    void updateTitleImage(Integer[] integerArray) {
        Image image = GamaIcon.named((String)"views/tabs/view.problems").image();
        if (integerArray[0] > 0) {
            image = GamaIcon.named((String)"markers/marker.error").image();
        } else if (integerArray[1] > 0) {
            image = GamaIcon.named((String)"markers/marker.warning").image();
        } else if (integerArray[2] > 0) {
            image = GamaIcon.named((String)"markers/marker.info").image();
        }
        this.setTitleImage(image);
    }

    public static class BuildPreferenceChangeListener
    implements IPreferenceChangeListener.IPreferenceAfterChangeListener<Boolean> {
        SyntaxErrorsView view;

        BuildPreferenceChangeListener(SyntaxErrorsView syntaxErrorsView) {
            this.view = syntaxErrorsView;
        }

        public void afterValueChange(Boolean bl) {
            SyntaxErrorsView.build();
        }
    }
}

