/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.templates;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.codetemplates.ui.internal.CodetemplatesActivator;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.IEditTemplateDialog;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.TemplateDialogMessages;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.TemplatesLanguageConfiguration;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.validation.Issue;

public class GamlEditTemplateDialog
extends StatusDialog
implements IEditTemplateDialog {
    TemplatePersistenceData data;
    private Text fNameText;
    private Text fDescriptionText;
    SourceViewer fPatternEditor;
    private EmbeddedEditorModelAccess partialModelEditor;
    private Button fInsertVariableButton;
    private final String languageName;
    private final TemplatesLanguageConfiguration configuration;
    private final IEditedResourceProvider resourceProvider;

    public GamlEditTemplateDialog(Shell shell, TemplatePersistenceData templatePersistenceData, boolean bl, ContextTypeRegistry contextTypeRegistry, TemplatesLanguageConfiguration templatesLanguageConfiguration, IEditedResourceProvider iEditedResourceProvider, String string) {
        super(shell);
        this.data = templatePersistenceData;
        this.configuration = templatesLanguageConfiguration;
        this.resourceProvider = iEditedResourceProvider;
        this.languageName = string;
        String string2 = bl ? TemplateDialogMessages.EditTemplateDialog_title_edit : TemplateDialogMessages.EditTemplateDialog_title_new;
        this.setTitle(string2);
        ArrayList arrayList = Lists.newArrayList();
        UnmodifiableIterator unmodifiableIterator = Iterators.filter((Iterator)contextTypeRegistry.contextTypes(), TemplateContextType.class);
        while (unmodifiableIterator.hasNext()) {
            TemplateContextType templateContextType = (TemplateContextType)unmodifiableIterator.next();
            arrayList.add(new String[]{templateContextType.getId(), templateContextType.getName()});
        }
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(this.getStatus().isOK());
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        ModifyListener modifyListener = modifyEvent -> this.doTextWidgetChanged(modifyEvent.widget);
        GamlEditTemplateDialog.createLabel(composite2, TemplateDialogMessages.EditTemplateDialog_name);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        this.fNameText = GamlEditTemplateDialog.createText(composite3);
        GamlEditTemplateDialog.createLabel(composite3, "Category:");
        Label label = new Label(composite3, 0);
        GamlEditTemplateDialog.createLabel(composite2, TemplateDialogMessages.EditTemplateDialog_description);
        this.fDescriptionText = new Text(composite2, 2048);
        this.fDescriptionText.setLayoutData((Object)new GridData(768));
        this.fDescriptionText.addModifyListener(modifyListener);
        Label label2 = GamlEditTemplateDialog.createLabel(composite2, TemplateDialogMessages.EditTemplateDialog_pattern);
        label2.setLayoutData((Object)new GridData(2));
        this.fPatternEditor = this.createEditor(composite2);
        Label label3 = new Label(composite2, 0);
        label3.setLayoutData((Object)new GridData());
        composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData());
        this.fInsertVariableButton = new Button(composite3, 0);
        this.fInsertVariableButton.setLayoutData((Object)GamlEditTemplateDialog.getButtonGridData());
        this.fInsertVariableButton.setText(TemplateDialogMessages.EditTemplateDialog_insert_variable);
        this.fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GamlEditTemplateDialog.this.fPatternEditor.getTextWidget().setFocus();
                GamlEditTemplateDialog.this.fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.fDescriptionText.setText(this.data.getTemplate().getDescription());
        this.fillMenuPath(label);
        this.fNameText.setText(this.data.getTemplate().getName());
        this.fNameText.addModifyListener(modifyListener);
        GamlEditTemplateDialog.applyDialogFont((Control)composite2);
        return composite3;
    }

    private void fillMenuPath(Label label) {
        String string = this.data.getId();
        string = string.substring(0, string.lastIndexOf(46)).replace(".", " > ");
        label.setText(string);
    }

    protected void doTextWidgetChanged(Widget widget) {
        if (widget == this.fNameText) {
            this.partialModelEditor.updatePrefix(this.getPrefix());
        }
    }

    protected String getContextName() {
        return "Model";
    }

    protected String getContextId() {
        return "gaml.compiler.gaml.Gaml.Model";
    }

    protected Status createErrorStatus(String string, TemplateException templateException) {
        return new Status(4, CodetemplatesActivator.getInstance().getBundle().getSymbolicName(), string, (Throwable)templateException);
    }

    private static GridData getButtonGridData() {
        GridData gridData = new GridData(768);
        return gridData;
    }

    private static Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite composite) {
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private SourceViewer createEditor(Composite composite) {
        SourceViewer sourceViewer = this.createViewer(composite);
        int n = sourceViewer.getDocument().getNumberOfLines();
        if (n < 7) {
            n = 7;
        } else if (n > 14) {
            n = 14;
        }
        Control control = sourceViewer.getControl();
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        gridData.heightHint = this.convertHeightInCharsToPixels(n);
        control.setLayoutData((Object)gridData);
        return sourceViewer;
    }

    protected SourceViewer createViewer(Composite composite) {
        EmbeddedEditorFactory.Builder builder = this.configuration.getEmbeddedEditorFactory().newEditor(this.resourceProvider);
        builder.processIssuesBy((list, iProgressMonitor) -> {
            Issue issue2;
            IStatus iStatus = Status.OK_STATUS;
            StringBuilder stringBuilder = new StringBuilder();
            for (Issue issue2 : list) {
                if (issue2.getSeverity() != Severity.ERROR) continue;
                if (stringBuilder.length() != 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(issue2.getMessage());
            }
            if (stringBuilder.length() != 0) {
                iStatus = this.createErrorStatus(stringBuilder.toString(), null);
            }
            issue2 = iStatus;
            this.getShell().getDisplay().asyncExec(() -> this.lambda$2((IStatus)issue2));
        });
        EmbeddedEditor embeddedEditor = builder.withParent(composite);
        this.partialModelEditor = embeddedEditor.createPartialEditor(this.getPrefix(), this.data.getTemplate().getPattern(), "", true);
        return embeddedEditor.getViewer();
    }

    protected String getPrefix() {
        String string = this.getContextName();
        String string2 = this.data.getTemplate().getName();
        if (this.fNameText != null && !this.fNameText.isDisposed()) {
            string2 = this.fNameText.getText();
        }
        String string3 = "templates for " + this.languageName + " '" + string2 + "' for " + string + " >>";
        return string3;
    }

    protected void okPressed() {
        String string = this.fNameText == null ? this.data.getTemplate().getName() : this.fNameText.getText();
        Template template = new Template(string, this.fDescriptionText.getText(), this.getContextId(), this.getPattern(), true);
        this.data = new TemplatePersistenceData(template, true, this.data.getId());
        super.okPressed();
    }

    public TemplatePersistenceData getData() {
        return this.data;
    }

    protected String getPattern() {
        return this.partialModelEditor.getEditablePart();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String string = ((Object)((Object)this)).getClass().getName() + "_dialogBounds";
        IDialogSettings iDialogSettings = this.configuration.getDialogSettings().getSection(string);
        if (iDialogSettings == null) {
            iDialogSettings = this.configuration.getDialogSettings().addNewSection(string);
        }
        return iDialogSettings;
    }

    public Template getTemplate() {
        return this.data.getTemplate();
    }

    private /* synthetic */ void lambda$2(IStatus iStatus) {
        this.updateStatus(iStatus);
    }
}

