/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui;

import gama.core.common.preferences.GamaPreferences;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.dev.DEBUG;
import gama.ui.shared.access.HeapControl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class AutoStartup
implements IStartup {
    static {
        DEBUG.OFF();
    }

    private static GamaColor getDefaultBackground() {
        EditorsPlugin.getDefault().getPreferenceStore().setValue("AbstractTextEditor.Color.Background.SystemDefault", false);
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)EditorsPlugin.getDefault().getPreferenceStore(), (String)"AbstractTextEditor.Color.Background");
        return GamaColor.get((int)rGB.red, (int)rGB.green, (int)rGB.blue);
    }

    public static GamaFont getDefaultFontData() {
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)EditorsPlugin.getDefault().getPreferenceStore(), (String)"org.eclipse.jface.textfont");
        return new GamaFont(fontData.getName(), fontData.getStyle(), fontData.getHeight());
    }

    public void earlyStartup() {
        DEBUG.OUT((Object)"Startup of editor plugin begins");
        GamaPreferences.Modeling.EDITOR_BASE_FONT.init(AutoStartup::getDefaultFontData).onChange(gamaFont -> {
            try {
                FontData fontData = new FontData(gamaFont.getName(), gamaFont.getSize(), gamaFont.getStyle());
                PreferenceConverter.setValue((IPreferenceStore)EditorsPlugin.getDefault().getPreferenceStore(), (String)"org.eclipse.jface.textfont", (FontData)fontData);
            }
            catch (Exception exception) {}
        });
        GamaPreferences.Modeling.EDITOR_BACKGROUND_COLOR.init(AutoStartup::getDefaultBackground).onChange(gamaColor -> {
            RGB rGB = new RGB(gamaColor.getRed(), gamaColor.getGreen(), gamaColor.getBlue());
            PreferenceConverter.setValue((IPreferenceStore)EditorsPlugin.getDefault().getPreferenceStore(), (String)"AbstractTextEditor.Color.Background", (RGB)rGB);
        });
        HeapControl.install();
        DEBUG.OUT((Object)"Startup of editor plugin finished");
    }
}

