/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.decorators;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import gama.ui.shared.resources.GamaIcon;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.IImageHelper;

@Singleton
public class GamlImageHelper
implements IImageHelper,
IImageHelper.IImageDescriptorHelper {
    private static final ImageDescriptor UNKNOWN_DESC = GamaIcon.named((String)"gaml/_unknown").descriptor();
    private static final Image UNKNOWN_IMG = GamaIcon.named((String)"gaml/_unknown").image();
    private final Map<ImageDescriptor, Image> registry = Maps.newHashMapWithExpectedSize((int)10);

    public ImageDescriptor getImageDescriptor(String string) {
        String string2 = "gaml/" + string.replace(".png", "");
        return GamaIcon.exist((String)string2) ? GamaIcon.named((String)string2).descriptor() : UNKNOWN_DESC;
    }

    public ImageDescriptor getImageDescriptor(Image image) {
        for (Map.Entry<ImageDescriptor, Image> object2 : this.registry.entrySet()) {
            if (!object2.getValue().equals((Object)image)) continue;
            return object2.getKey();
        }
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        this.registry.put(imageDescriptor, image);
        return imageDescriptor;
    }

    public Image getImage(String string) {
        String string2 = "gaml/" + string.replace(".png", "");
        return GamaIcon.exist((String)string2) ? GamaIcon.named((String)string2).image() : UNKNOWN_IMG;
    }

    public Image getImage(ImageDescriptor imageDescriptor) {
        Image image;
        ImageDescriptor imageDescriptor2 = imageDescriptor;
        if (imageDescriptor2 == null) {
            imageDescriptor2 = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((image = this.registry.get(imageDescriptor2)) != null) {
            return image;
        }
        image = imageDescriptor2.createImage();
        if (image != null) {
            this.registry.put(imageDescriptor2, image);
        }
        return image;
    }
}

