/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.decorators;

import com.google.inject.Inject;
import gama.dev.DEBUG;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.MarkerUpdaterImpl;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.markers.IMarkerContributor;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.validation.IResourceUIValidatorExtension;
import org.eclipse.xtext.ui.validation.MarkerEraser;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.CheckMode;

public class GamlMarkerUpdater
extends MarkerUpdaterImpl {
    final MarkerEraser eraser = new MarkerEraser();
    @Inject
    IStorage2UriMapper mapper;

    public void updateMarkers(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor iProgressMonitor) {
        URI uRI = delta.getUri();
        IResourceUIValidatorExtension iResourceUIValidatorExtension = this.getResourceUIValidatorExtension(uRI);
        IMarkerContributor iMarkerContributor = this.getMarkerContributor(uRI);
        CheckMode checkMode = CheckMode.NORMAL_AND_FAST;
        for (Pair pair : this.mapper.getStorages(uRI)) {
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            IStorage iStorage = (IStorage)pair.getFirst();
            if (!(iStorage instanceof IFile)) continue;
            IFile iFile = (IFile)iStorage;
            if (delta.getNew() != null) {
                if (resourceSet == null) {
                    return;
                }
                Resource resource = resourceSet.getResource(uRI, true);
                if (iResourceUIValidatorExtension != null) {
                    iResourceUIValidatorExtension.updateValidationMarkers(iFile, resource, checkMode, iProgressMonitor);
                }
                if (iMarkerContributor == null) continue;
                iMarkerContributor.updateMarkers(iFile, resource, iProgressMonitor);
                continue;
            }
            if (iResourceUIValidatorExtension != null) {
                iResourceUIValidatorExtension.deleteValidationMarkers(iFile, checkMode, iProgressMonitor);
            } else {
                this.eraser.deleteValidationMarkers(iFile, checkMode, iProgressMonitor);
            }
            if (iMarkerContributor != null) {
                iMarkerContributor.deleteMarkers(iFile, iProgressMonitor);
                continue;
            }
            try {
                iFile.deleteMarkers("org.eclipse.xtext.ui.marker", true, 0);
            }
            catch (CoreException coreException) {
                DEBUG.ERR((Object)coreException.getMessage());
            }
        }
    }
}

