/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.hover;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import gama.gaml.interfaces.IGamlDescription;
import gama.ui.shared.utils.WebHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import gaml.compiler.gaml.ActionRef;
import gaml.compiler.gaml.Function;
import gaml.compiler.gaml.VariableRef;
import gaml.compiler.ui.hover.GamlHoverDocumentationProvider;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.hover.DispatchingEObjectTextHover;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.IXtextBrowserInformationControl;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControl;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;
import org.eclipse.xtext.ui.editor.hover.html.XtextElementLinks;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class GamlHoverProvider
extends DefaultEObjectHoverProvider {
    private IInformationControlCreator creator;
    @Inject
    private IEObjectDocumentationProvider decoratedProvider;
    @Inject
    private GamlHoverDocumentationProvider provider;

    public IInformationControlCreator getHoverControlCreator() {
        if (this.creator == null) {
            this.creator = new GamlHoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.creator;
    }

    protected void addLinkListener(final IXtextBrowserInformationControl iXtextBrowserInformationControl) {
        iXtextBrowserInformationControl.addLocationListener(this.getElementLinks().createLocationListener(new XtextElementLinks.ILinkHandler(){
            @Inject
            private IURIEditorOpener uriEditorOpener;

            public void handleXtextdocViewLink(URI uRI) {
            }

            public void handleInlineXtextdocLink(URI uRI) {
                XtextBrowserInformationControlInput xtextBrowserInformationControlInput = GamlHoverProvider.this.getHoverInfo(this.getTarget(uRI), null, (XtextBrowserInformationControlInput)iXtextBrowserInformationControl.getInput());
                if (iXtextBrowserInformationControl.hasDelayedInputChangeListener()) {
                    iXtextBrowserInformationControl.notifyDelayedInputChange((Object)xtextBrowserInformationControlInput);
                } else {
                    iXtextBrowserInformationControl.setInput((Object)xtextBrowserInformationControlInput);
                }
            }

            public void handleDeclarationLink(URI uRI) {
                iXtextBrowserInformationControl.notifyDelayedInputChange(null);
                iXtextBrowserInformationControl.dispose();
                if (this.uriEditorOpener != null) {
                    this.uriEditorOpener.open(uRI, true);
                }
            }

            public boolean handleExternalLink(URL uRL, Display display) {
                iXtextBrowserInformationControl.notifyDelayedInputChange(null);
                iXtextBrowserInformationControl.dispose();
                WebHelper.openPage((String)uRL.toString());
                return true;
            }

            public void handleTextSet() {
            }

            EObject getTarget(URI uRI) {
                ResourceSet resourceSet = ((XtextBrowserInformationControlInput)iXtextBrowserInformationControl.getInput()).getElement().eResource().getResourceSet();
                return resourceSet.getEObject(uRI, true);
            }
        }));
    }

    protected String getHoverInfoAsHtml(EObject eObject) {
        StringBuilder stringBuilder = new StringBuilder();
        IGamlDescription iGamlDescription = this.provider.getDoc(eObject);
        if (iGamlDescription == null) {
            iGamlDescription = new GamlHoverDocumentationProvider.Result("Unknow object of type " + eObject.getClass().getSimpleName(), "File an issue at https://github.com/gama-platform/gama/issues to document it");
        }
        String string = iGamlDescription.getTitle();
        String string2 = iGamlDescription.getDocumentation().toString();
        String string3 = this.decoratedProvider.getDocumentation(eObject);
        if (Strings.isNullOrEmpty((String)string3)) {
            if (eObject instanceof VariableRef) {
                string3 = super.getDocumentation((EObject)((VariableRef)eObject).getRef());
            } else if (eObject instanceof ActionRef) {
                string3 = super.getDocumentation((EObject)((ActionRef)eObject).getRef());
            }
        }
        if (!Strings.isNullOrEmpty((String)string)) {
            stringBuilder.append("<b>").append(string).append("</b><hr>");
        }
        if (!Strings.isNullOrEmpty((String)string3)) {
            stringBuilder.append("<p><i>").append(string3).append("</i></p><hr>");
        }
        if (!Strings.isNullOrEmpty((String)string2)) {
            stringBuilder.append("<p>").append(string2).append("</p>");
        }
        return stringBuilder.toString();
    }

    public static class GamlDispatchingEObjectTextHover
    extends DispatchingEObjectTextHover {
        @Inject
        private EObjectAtOffsetHelper eObjectAtOffsetHelper;
        @Inject
        private ILocationInFileProvider locationInFileProvider;
        EObject correct = null;

        protected Pair<EObject, IRegion> getXtextElementAt(XtextResource xtextResource, int n) {
            EObject eObject;
            ITextRegion iTextRegion = null;
            if (this.correct == null) {
                eObject = this.correct = this.eObjectAtOffsetHelper.resolveContainedElementAt(xtextResource, n);
            } else {
                eObject = this.correct;
                this.correct = null;
            }
            if (eObject != null) {
                EObject eObject2;
                if (eObject instanceof ActionRef && (eObject2 = eObject.eContainer()) instanceof Function) {
                    eObject = eObject2;
                    iTextRegion = this.locationInFileProvider.getFullTextRegion(eObject);
                }
                if (iTextRegion == null) {
                    iTextRegion = this.locationInFileProvider.getSignificantTextRegion(eObject);
                }
                eObject2 = new Region(iTextRegion.getOffset(), iTextRegion.getLength());
                return Tuples.create((Object)eObject, (Object)eObject2);
            }
            ILeafNode iLeafNode = NodeModelUtils.findLeafNodeAtOffset((INode)xtextResource.getParseResult().getRootNode(), (int)n);
            if (iLeafNode != null && iLeafNode.getGrammarElement() instanceof Keyword) {
                Region region = new Region(iLeafNode.getOffset(), iLeafNode.getLength());
                return Tuples.create((Object)iLeafNode.getGrammarElement(), (Object)region);
            }
            return null;
        }

        public Object getHoverInfo(EObject eObject, ITextViewer iTextViewer, IRegion iRegion) {
            return super.getHoverInfo(eObject, iTextViewer, iRegion);
        }
    }

    public class GamlHoverControlCreator
    extends DefaultEObjectHoverProvider.HoverControlCreator {
        public GamlHoverControlCreator(IInformationControlCreator iInformationControlCreator) {
            super((DefaultEObjectHoverProvider)GamlHoverProvider.this, iInformationControlCreator);
        }

        public IInformationControl doCreateInformationControl(Shell shell) {
            String string = EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)shell)) {
                GamlInformationControl gamlInformationControl = new GamlInformationControl(shell, "org.eclipse.jdt.ui.javadocfont", string);
                GamlHoverProvider.this.addLinkListener((IXtextBrowserInformationControl)gamlInformationControl);
                return gamlInformationControl;
            }
            return new DefaultInformationControl(shell, string);
        }

        public class GamlInformationControl
        extends XtextBrowserInformationControl {
            public void setSize(int n, int n2) {
                super.setSize(n, n2 + 30);
                Point point = WorkbenchHelper.getDisplay().getCursorLocation();
                point.x -= 5;
                point.y += 15;
                this.setLocation(point);
            }

            public GamlInformationControl(Shell shell, String string, String string2) {
                super(shell, string, string2);
            }

            public IInformationControlCreator getInformationPresenterControlCreator() {
                return GamlHoverProvider.this.getInformationPresenterControlCreator();
            }
        }
    }
}

