/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.outline;

import com.google.inject.Inject;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.factories.DescriptionFactory;
import gaml.compiler.gaml.Block;
import gaml.compiler.gaml.EGaml;
import gaml.compiler.gaml.ExperimentFileStructure;
import gaml.compiler.gaml.HeadlessExperiment;
import gaml.compiler.gaml.Model;
import gaml.compiler.gaml.S_Action;
import gaml.compiler.gaml.S_Definition;
import gaml.compiler.gaml.S_Experiment;
import gaml.compiler.gaml.S_Global;
import gaml.compiler.gaml.S_Species;
import gaml.compiler.gaml.Statement;
import gaml.compiler.gaml.util.GamlSwitch;
import gaml.compiler.ui.labeling.GamlLabelProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.AbstractOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.BackgroundOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;

public class GamlOutlineTreeProvider
extends BackgroundOutlineTreeProvider {
    @Inject
    private GamlLabelProvider provider;
    static final Object FOUND = new Object();

    public void createChildren(final IOutlineNode iOutlineNode, EObject eObject) {
        if (eObject != null && iOutlineNode.hasChildren()) {
            new GamlSwitch<Object>(){

                public Object caseModel(Model model) {
                    Block block = model.getBlock();
                    if (block != null) {
                        for (Statement statement : EGaml.getInstance().getStatementsOf((EObject)block)) {
                            if (statement instanceof S_Global) {
                                block = statement.getBlock();
                                if (block == null) continue;
                                GamlOutlineTreeProvider.this.ownCreateChildren(iOutlineNode, block, true);
                                continue;
                            }
                            GamlOutlineTreeProvider.this.createNode(iOutlineNode, (EObject)statement);
                        }
                    }
                    return FOUND;
                }

                public Object caseExperimentFileStructure(ExperimentFileStructure experimentFileStructure) {
                    return this.caseHeadlessExperiment(experimentFileStructure.getExp());
                }

                public Object caseS_Experiment(S_Experiment s_Experiment) {
                    GamlOutlineTreeProvider.this.ownCreateChildren(iOutlineNode, s_Experiment.getBlock(), true);
                    return FOUND;
                }

                public Object caseHeadlessExperiment(HeadlessExperiment headlessExperiment) {
                    GamlOutlineTreeProvider.this.ownCreateChildren(iOutlineNode, headlessExperiment.getBlock(), true);
                    return FOUND;
                }

                public Object caseS_Species(S_Species s_Species) {
                    GamlOutlineTreeProvider.this.ownCreateChildren(iOutlineNode, s_Species.getBlock(), true);
                    return FOUND;
                }

                public Object defaultCase(EObject eObject) {
                    String string = EGaml.getInstance().getKeyOf(eObject);
                    if ("output".equals(string)) {
                        Statement statement = (Statement)eObject;
                        GamlOutlineTreeProvider.this.ownCreateChildren(iOutlineNode, statement.getBlock(), false);
                        return FOUND;
                    }
                    return null;
                }
            }.doSwitch(eObject);
        }
    }

    protected void ownCreateChildren(IOutlineNode iOutlineNode, Block block, boolean bl) {
        AbstractOutlineNode abstractOutlineNode = null;
        AbstractOutlineNode abstractOutlineNode2 = null;
        AbstractOutlineNode abstractOutlineNode3 = null;
        if (block != null && bl) {
            for (Statement statement2 : EGaml.getInstance().getStatementsOf((EObject)block)) {
                if (this.isParameter(statement2)) {
                    if (abstractOutlineNode2 == null) {
                        abstractOutlineNode2 = new AbstractOutlineNode(iOutlineNode, this.provider.convertToImageDescriptor("_parameter.png"), "Parameters", false){};
                    }
                    this.createNode((IOutlineNode)abstractOutlineNode2, (EObject)statement2);
                    continue;
                }
                if (GamlOutlineTreeProvider.isAttribute(statement2)) {
                    if (abstractOutlineNode == null) {
                        abstractOutlineNode = new AbstractOutlineNode(iOutlineNode, this.provider.convertToImageDescriptor("_attributes.png"), "Attributes", false){};
                    }
                    this.createNode((IOutlineNode)abstractOutlineNode, (EObject)statement2);
                    continue;
                }
                if (GamlOutlineTreeProvider.isAction(statement2)) {
                    if (abstractOutlineNode3 == null) {
                        abstractOutlineNode3 = new AbstractOutlineNode(iOutlineNode, this.provider.convertToImageDescriptor("_action.png"), "Actions", false){};
                    }
                    this.createNode((IOutlineNode)abstractOutlineNode3, (EObject)statement2);
                    continue;
                }
                this.createNode(iOutlineNode, (EObject)statement2);
            }
        } else {
            EGaml.getInstance().getStatementsOf((EObject)block).forEach(statement -> {
                EObjectNode eObjectNode = this.createNode(iOutlineNode, (EObject)statement);
            });
        }
    }

    private boolean isParameter(Statement statement) {
        String string = EGaml.getInstance().getKeyOf((EObject)statement);
        return "parameter".equals(string) || "text".equals(string) || "user_command".equals(string) || "category".equals(string);
    }

    public static boolean isAttribute(Statement statement) {
        if (!(statement instanceof S_Definition)) {
            return false;
        }
        String string = EGaml.getInstance().getKeyOf((EObject)statement);
        if ("action".equals(string)) {
            return false;
        }
        SymbolProto symbolProto = DescriptionFactory.getStatementProto((String)string);
        return symbolProto == null || symbolProto.getKind() != 9;
    }

    public static boolean isAction(Statement statement) {
        if (!(statement instanceof S_Definition)) {
            return false;
        }
        if (statement instanceof S_Action) {
            return true;
        }
        String string = EGaml.getInstance().getKeyOf((EObject)statement);
        SymbolProto symbolProto = DescriptionFactory.getStatementProto((String)string);
        if (symbolProto != null && symbolProto.isTopLevel()) {
            return false;
        }
        return statement.getKey() == null;
    }

    protected Object getText(Object object) {
        if (object instanceof S_Global) {
            return null;
        }
        return super.getText(object);
    }

    protected boolean isLeaf(EObject eObject) {
        if (eObject instanceof S_Experiment) {
            return ((S_Experiment)eObject).getBlock() == null || ((S_Experiment)eObject).getBlock().getStatements().isEmpty();
        }
        if (eObject instanceof S_Species) {
            return ((S_Species)eObject).getBlock() == null || ((S_Species)eObject).getBlock().getStatements().isEmpty();
        }
        if (eObject instanceof Model) {
            return ((Model)eObject).getBlock() == null;
        }
        String string = EGaml.getInstance().getKeyOf(eObject);
        return !"output".equals(string);
    }
}

