/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.editor;

import gama.core.common.util.FileUtils;
import gama.core.runtime.PlatformHelper;
import gama.gaml.operators.Strings;
import gama.gaml.types.GamaFileType;
import gama.gaml.types.ParametricFileType;
import gama.ui.navigator.metadata.FileMetaDataProvider;
import gaml.compiler.ui.editor.GamaSourceViewer;
import gaml.compiler.ui.editor.GamlEditor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class GamlEditorDragAndDropHandler {
    TextTransfer TEXT = TextTransfer.getInstance();
    FileTransfer FILE = FileTransfer.getInstance();
    ResourceTransfer RSRC = ResourceTransfer.getInstance();
    Transfer[] TRANSFER_ALL = new Transfer[]{this.FILE, this.RSRC, this.TEXT};
    Transfer[] TRANSFER_TEXT = new Transfer[]{this.TEXT};
    final GamlEditor editor;
    boolean fIsTextDragAndDropInstalled;
    protected Object fTextDragAndDropToken;
    protected static final Set<String> usedNames = new HashSet<String>();

    public GamlEditorDragAndDropHandler(GamlEditor gamlEditor) {
        this.editor = gamlEditor;
    }

    public StyledText getStyledText() {
        return this.getViewer().getTextWidget();
    }

    public XtextDocument getDocument() {
        return (XtextDocument)this.getViewer().getDocument();
    }

    public GamaSourceViewer getViewer() {
        return this.editor.getInternalSourceViewer();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.getViewer().getSelectionProvider();
    }

    public void install(boolean bl) {
        if (this.getViewer() == null || this.fIsTextDragAndDropInstalled) {
            return;
        }
        final StyledText styledText = this.getStyledText();
        final ISelectionProvider iSelectionProvider = this.getSelectionProvider();
        IDragAndDropService iDragAndDropService = (IDragAndDropService)this.editor.getSite().getService(IDragAndDropService.class);
        if (iDragAndDropService == null) {
            return;
        }
        DragSource dragSource = new DragSource((Control)styledText, 3);
        dragSource.setTransfer(this.TRANSFER_TEXT);
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
            String fSelectedText;
            Point fSelection;

            public void dragStart(DragSourceEvent dragSourceEvent) {
                GamlEditorDragAndDropHandler.this.fTextDragAndDropToken = null;
                try {
                    this.fSelection = styledText.getSelection();
                    dragSourceEvent.doit = this.isLocationSelected(new Point(dragSourceEvent.x, dragSourceEvent.y));
                    ISelection iSelection = iSelectionProvider.getSelection();
                    this.fSelectedText = iSelection instanceof ITextSelection ? ((ITextSelection)iSelection).getText() : styledText.getSelectionText();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    dragSourceEvent.doit = false;
                }
            }

            private boolean isLocationSelected(Point point) {
                if (GamlEditorDragAndDropHandler.this.editor.isBlockSelectionModeEnabled()) {
                    return false;
                }
                int n = styledText.getOffsetAtPoint(point);
                Point point2 = styledText.getLocationAtOffset(n);
                if (point2.x > point.x) {
                    --n;
                }
                return n >= this.fSelection.x && n < this.fSelection.y;
            }

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                dragSourceEvent.data = this.fSelectedText;
                GamlEditorDragAndDropHandler.this.fTextDragAndDropToken = this;
            }

            public void dragFinished(DragSourceEvent dragSourceEvent) {
                try {
                    if (dragSourceEvent.detail == 2 && GamlEditorDragAndDropHandler.this.editor.validateEditorInputState()) {
                        Object object;
                        Point point = styledText.getSelection();
                        int n = this.fSelection.y - this.fSelection.x;
                        int n2 = 0;
                        if (point.x < this.fSelection.x) {
                            n2 = n;
                        }
                        styledText.replaceTextRange(this.fSelection.x + n2, n, "");
                        if (GamlEditorDragAndDropHandler.this.fTextDragAndDropToken == null && (object = GamlEditorDragAndDropHandler.this.editor.getAdapter(IRewriteTarget.class)) != null) {
                            ((IRewriteTarget)object).endCompoundChange();
                        }
                    }
                }
                finally {
                    GamlEditorDragAndDropHandler.this.fTextDragAndDropToken = null;
                }
            }
        });
        DropTargetAdapter dropTargetAdapter = new DropTargetAdapter(){
            private Point fSelection;

            public void dropAccept(DropTargetEvent dropTargetEvent) {
                if (GamlEditorDragAndDropHandler.this.RSRC.isSupportedType(dropTargetEvent.currentDataType) || GamlEditorDragAndDropHandler.this.FILE.isSupportedType(dropTargetEvent.currentDataType)) {
                    dropTargetEvent.detail = 1;
                    return;
                }
            }

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                if (GamlEditorDragAndDropHandler.this.RSRC.isSupportedType(dropTargetEvent.currentDataType) || GamlEditorDragAndDropHandler.this.FILE.isSupportedType(dropTargetEvent.currentDataType)) {
                    dropTargetEvent.detail = 1;
                    return;
                }
                GamlEditorDragAndDropHandler.this.fTextDragAndDropToken = null;
                this.fSelection = styledText.getSelection();
                if (dropTargetEvent.detail == 16) {
                    dropTargetEvent.detail = (dropTargetEvent.operations & 2) != 0 ? 2 : ((dropTargetEvent.operations & 1) != 0 ? 1 : 0);
                }
            }

            public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.detail == 16) {
                    dropTargetEvent.detail = (dropTargetEvent.operations & 2) != 0 ? 2 : ((dropTargetEvent.operations & 1) != 0 ? 1 : 0);
                }
            }

            public void dragOver(DropTargetEvent dropTargetEvent) {
                dropTargetEvent.feedback |= 8;
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                block16: {
                    Object object = dropTargetEvent.data;
                    try {
                        Object object2;
                        if (GamlEditorDragAndDropHandler.this.RSRC.isSupportedType(dropTargetEvent.currentDataType) && object instanceof IResource[]) {
                            GamlEditorDragAndDropHandler.this.tryDropResources((IResource[])object);
                            return;
                        }
                        if (GamlEditorDragAndDropHandler.this.FILE.isSupportedType(dropTargetEvent.currentDataType) && object instanceof String[]) {
                            GamlEditorDragAndDropHandler.this.tryDropFiles((String[])object);
                            return;
                        }
                        if (GamlEditorDragAndDropHandler.this.fTextDragAndDropToken != null && dropTargetEvent.detail == 2) {
                            int n = styledText.getCaretOffset();
                            if (this.fSelection.x <= n && n <= this.fSelection.y) {
                                dropTargetEvent.detail = 0;
                                return;
                            }
                            object2 = GamlEditorDragAndDropHandler.this.editor.getAdapter(IRewriteTarget.class);
                            if (object2 != null) {
                                ((IRewriteTarget)object2).beginCompoundChange();
                            }
                        }
                        if (!GamlEditorDragAndDropHandler.this.editor.validateEditorInputState()) {
                            dropTargetEvent.detail = 0;
                            return;
                        }
                        String string = (String)object;
                        if (GamlEditorDragAndDropHandler.this.editor.isBlockSelectionModeEnabled()) break block16;
                        object2 = styledText.getSelection();
                        try {
                            int n = GamlEditorDragAndDropHandler.this.getViewer().widgetOffset2ModelOffset(object2.x);
                            GamlEditorDragAndDropHandler.this.getDocument().replace(n, 0, string);
                        }
                        catch (BadLocationException badLocationException) {
                            GamlEditorDragAndDropHandler.this.fTextDragAndDropToken = null;
                            return;
                        }
                        styledText.setSelectionRange(object2.x, string.length());
                    }
                    finally {
                        GamlEditorDragAndDropHandler.this.fTextDragAndDropToken = null;
                    }
                }
            }
        };
        iDragAndDropService.addMergedDropTarget((Control)styledText, 3, bl ? this.TRANSFER_TEXT : this.TRANSFER_ALL, (DropTargetListener)dropTargetAdapter);
        this.fIsTextDragAndDropInstalled = true;
    }

    protected void uninstall() {
        if (this.getViewer() == null || !this.fIsTextDragAndDropInstalled) {
            return;
        }
        IDragAndDropService iDragAndDropService = (IDragAndDropService)this.editor.getSite().getService(IDragAndDropService.class);
        if (iDragAndDropService == null) {
            return;
        }
        StyledText styledText = this.getStyledText();
        iDragAndDropService.removeMergedDropTarget((Control)styledText);
        DragSource dragSource = (DragSource)styledText.getData("DragSource");
        if (dragSource != null) {
            dragSource.dispose();
            styledText.setData("DragSource", null);
        }
        this.fIsTextDragAndDropInstalled = false;
    }

    void tryDropFiles(String[] stringArray) {
        IResource[] iResourceArray;
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile iFile;
            Object object = iResourceArray = stringArray2[n2];
            if (PlatformHelper.isWindows()) {
                object = object.replace('\\', '/');
            }
            if (!FileUtils.isDirectoryOrNullExternalFile((String)object) && (iFile = FileUtils.createLinkToExternalFile((String)object, (URI)this.editor.getURI())) != null) {
                arrayList.add(iFile);
            }
            ++n2;
        }
        if (arrayList.isEmpty()) {
            return;
        }
        iResourceArray = arrayList.toArray(new IResource[0]);
        this.tryDropResources(iResourceArray);
    }

    void tryDropResources(IResource[] iResourceArray) {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        ArrayList<IFile> arrayList2 = new ArrayList<IFile>();
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                IResource iResource = iResourceArray2[n2];
                if (!(iResource instanceof IFile)) break block8;
                IFile iFile = (IFile)iResource;
                switch (FileMetaDataProvider.getContentTypeId((IFile)iFile)) {
                    case "gama.ui.gaml.type": {
                        arrayList.add(iFile);
                        break;
                    }
                    default: {
                        arrayList2.add(iFile);
                    }
                }
            }
            ++n2;
        }
        this.addFilesToText(arrayList2, false);
        this.addFilesToText(arrayList, true);
        usedNames.clear();
    }

    private void addFilesToText(List<IFile> list, boolean bl) {
        if (list.size() == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getStyledText().getSelection().x;
        if (bl) {
            for (IFile iFile : list) {
                n = this.addDropImport(stringBuilder, iFile);
            }
        } else {
            for (IFile iFile : list) {
                this.addDropFile(stringBuilder, iFile);
            }
        }
        if (stringBuilder.length() == 0) {
            return;
        }
        if (n == -1) {
            return;
        }
        try {
            int n2 = this.getViewer().widgetOffset2ModelOffset(n);
            this.getDocument().replace(n2, 0, this.addGlobalIfNecessary(stringBuilder.toString()));
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.getStyledText().setSelectionRange(n, stringBuilder.length());
    }

    private int addDropFile(StringBuilder stringBuilder, IFile iFile) {
        ParametricFileType parametricFileType = (ParametricFileType)GamaFileType.extensionsToFullType.get(iFile.getFileExtension());
        String string = parametricFileType == null ? "file" : parametricFileType.toString();
        String string2 = this.obtainRelativePath(iFile);
        String string3 = GamlEditorDragAndDropHandler.clean(iFile.getName()) + "_" + string;
        stringBuilder.append(Strings.LN).append("\t").append(string).append(' ').append(string3).append(" <- ").append(string).append("(").append('\"').append(string2).append('\"').append(");").append(Strings.LN);
        return -1;
    }

    private static String clean(String string) {
        int n = 1;
        String string2 = string.substring(0, string.indexOf(46));
        string2 = StringUtils.replaceChars((String)string2, (String)" .,;:-()'&@%*?!<>=+#", (String)"_");
        String string3 = string2 + "0";
        while (usedNames.contains(string3)) {
            string3 = string2 + String.valueOf(n++);
        }
        usedNames.add(string3);
        return string3;
    }

    private String obtainRelativePath(IFile iFile) {
        IPath iPath = iFile.getFullPath();
        IPath iPath2 = new Path(this.editor.getURI().toPlatformString(true)).removeLastSegments(1);
        IPath iPath3 = iPath.makeRelativeTo(iPath2);
        String string = iPath3.toString();
        return string;
    }

    private String addGlobalIfNecessary(String string) {
        if (string.contains("import \"")) {
            return string;
        }
        StyledText styledText = this.getStyledText();
        String string2 = styledText.getText();
        int n = string2.indexOf("global");
        if (n == -1) {
            return "global {" + Strings.LN + string + Strings.LN + "}";
        }
        return string;
    }

    private int addDropImport(StringBuilder stringBuilder, IFile iFile) {
        String string = this.obtainRelativePath(iFile);
        stringBuilder.append(Strings.LN).append("import ").append('\"').append(string).append('\"').append(Strings.LN);
        StyledText styledText = this.getStyledText();
        String string2 = styledText.getText();
        int n = string2.indexOf("global");
        int n2 = string2.indexOf("\nmodel");
        if (n == -1 && n2 == -1) {
            return -1;
        }
        int n3 = string2.indexOf("\n", n2 + 1);
        return n3 + 1;
    }
}

