/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.quickfix;

import gama.ui.shared.utils.FileOpener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class GamlQuickfixProvider
extends DefaultQuickfixProvider {
    public void removeIssue(String string, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        issueResolutionAcceptor.accept(issue, string, "", "", iModificationContext -> {
            IXtextDocument iXtextDocument = iModificationContext.getXtextDocument();
            iXtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), "");
        });
    }

    @Fix(value="gaml.casting.issue")
    public void shouldCast(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        String[] stringArray = issue.getData();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = stringArray[0];
        issueResolutionAcceptor.accept(issue, "Cast the expression to " + string + "...", "", "", (IModification)new Surround(issue.getOffset(), issue.getLength(), string + "(", ")"));
    }

    @Fix(value="gaml.no.init.issue")
    public void addInit(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        issueResolutionAcceptor.accept(issue, "Add an init facet...", "", "", iModificationContext -> {
            IXtextDocument iXtextDocument = iModificationContext.getXtextDocument();
            iXtextDocument.replace(issue.getOffset() + issue.getLength() + 1, 0, " <- " + issue.getData()[0] + " ");
        });
    }

    @Fix(value="gaml.as.array.issue")
    public void asArray(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        issueResolutionAcceptor.accept(issue, "Enclose the skill in a list...", "", "", (IModification)new Surround(issue.getOffset(), issue.getLength(), "[", "]"));
    }

    @Fix(value="gaml.import.has.error")
    public void gotoImport(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        String[] stringArray = issue.getData();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = stringArray[0];
        URI uRI = URI.createURI((String)string, (boolean)false);
        issueResolutionAcceptor.accept(issue, "Open " + uRI.lastSegment() + "...", "Open file " + uRI.lastSegment() + " to fix it", "", iModificationContext -> {
            IEditorPart iEditorPart = FileOpener.openFile((URI)uRI);
        });
    }

    @Fix(value="gaml.wrong.value")
    public void replaceValue(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        String[] stringArray = issue.getData();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = stringArray[0];
        issueResolutionAcceptor.accept(issue, "Replace with " + string + "...", "", "", (IModification)new Replace(issue.getOffset(), issue.getLength(), string));
    }

    @Fix(value="gaml.missing.facet.issue")
    public void addFacet(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
    }

    private static class Replace
    implements IModification {
        protected final int length;
        protected final int offset;
        protected final String text;

        Replace(int n, int n2, String string) {
            this.length = n2;
            this.offset = n;
            this.text = string;
        }

        public void apply(IModificationContext iModificationContext) throws BadLocationException {
            IXtextDocument iXtextDocument = iModificationContext.getXtextDocument();
            iXtextDocument.replace(this.offset, this.length, this.text);
        }
    }

    private static class Surround
    extends Replace {
        private final String suffix;

        Surround(int n, int n2, String string) {
            super(n, n2, string);
            this.suffix = string;
        }

        Surround(int n, int n2, String string, String string2) {
            super(n, n2, string);
            this.suffix = string2;
        }

        @Override
        public void apply(IModificationContext iModificationContext) throws BadLocationException {
            IXtextDocument iXtextDocument = iModificationContext.getXtextDocument();
            String string = this.text + iXtextDocument.get(this.offset, this.length) + this.suffix;
            iXtextDocument.replace(this.offset, this.length, string);
        }
    }
}

