/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.hover;

import com.google.inject.Inject;
import gama.core.common.interfaces.IDisplayCreator;
import gama.core.common.interfaces.IDocManager;
import gama.core.common.interfaces.IExperimentAgentCreator;
import gama.core.common.interfaces.IGui;
import gama.core.common.util.FileUtils;
import gama.core.runtime.GAMA;
import gama.core.util.file.IGamaFileMetaData;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.kernel.GamaMetaModel;
import gama.gaml.compilation.kernel.GamaSkillRegistry;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.expressions.units.UnitConstantExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.operators.Strings;
import gama.gaml.statements.DoStatement;
import gama.gaml.types.Types;
import gaml.compiler.gaml.ActionDefinition;
import gaml.compiler.gaml.ActionRef;
import gaml.compiler.gaml.ArgumentPair;
import gaml.compiler.gaml.Array;
import gaml.compiler.gaml.EGaml;
import gaml.compiler.gaml.Expression;
import gaml.compiler.gaml.ExpressionList;
import gaml.compiler.gaml.Facet;
import gaml.compiler.gaml.Function;
import gaml.compiler.gaml.Import;
import gaml.compiler.gaml.Parameter;
import gaml.compiler.gaml.S_Definition;
import gaml.compiler.gaml.S_Display;
import gaml.compiler.gaml.S_Do;
import gaml.compiler.gaml.S_Experiment;
import gaml.compiler.gaml.S_Global;
import gaml.compiler.gaml.Statement;
import gaml.compiler.gaml.StringLiteral;
import gaml.compiler.gaml.TypeRef;
import gaml.compiler.gaml.UnitFakeDefinition;
import gaml.compiler.gaml.UnitName;
import gaml.compiler.gaml.VarDefinition;
import gaml.compiler.gaml.VariableRef;
import gaml.compiler.gaml.resource.GamlResourceServices;
import gaml.compiler.gaml.speciesOrGridDisplayStatement;
import gaml.compiler.gaml.util.GamlSwitch;
import gaml.compiler.ui.editor.GamlHyperlinkDetector;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class GamlHoverDocumentationProvider
extends GamlSwitch<IGamlDescription> {
    @Inject
    protected GamlHyperlinkDetector detector;
    private final IDocManager documenter = GamlResourceServices.getResourceDocumenter();

    IGamlDescription getDoc(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        int n = eObject.eClass().getClassifierID();
        IGamlDescription iGamlDescription = (IGamlDescription)this.doSwitch(n, eObject);
        if (iGamlDescription == null) {
            if (eObject instanceof VariableRef) {
                VariableRef variableRef = (VariableRef)eObject;
                iGamlDescription = this.specialCaseVariableRef(variableRef);
            } else if (eObject instanceof TypeRef) {
                TypeRef typeRef = (TypeRef)eObject;
                iGamlDescription = this.specialCaseTypeRef(typeRef);
            }
        }
        return iGamlDescription;
    }

    public IGamlDescription caseImport(Import import_) {
        String string = import_.getImportURI();
        string = string.substring(string.lastIndexOf(47) + 1);
        String string2 = import_.getName() != null ? "micro-model" : "model";
        String string3 = "Import of the " + string2 + " defined in <i>" + string + "</i>";
        String string4 = "ctrl-click or cmd-click on the path to open this model in a new editor";
        return new Result(string3, string4);
    }

    public IGamlDescription caseS_Global(S_Global s_Global) {
        EObject eObject = s_Global.eContainer().eContainer();
        String string = "Global section of <i>" + this.getDoc(eObject).getTitle() + "</i>";
        String string2 = "";
        return new Result(string, string2);
    }

    public IGamlDescription caseStringLiteral(StringLiteral stringLiteral) {
        URI uRI = this.detector.getURI(stringLiteral);
        if (uRI != null) {
            IFile iFile;
            Object object = "";
            if (FileUtils.isFileExistingInWorkspace((URI)uRI)) {
                iFile = FileUtils.getWorkspaceFile((URI)uRI);
                IGamaFileMetaData iGamaFileMetaData = GAMA.getGui().getMetaDataProvider().getMetaData((Object)iFile, false, true);
                if (iGamaFileMetaData == null) {
                    String string = iFile.getFileExtension();
                    object = "This " + string + " file has no metadata associated with it";
                } else {
                    String string = iGamaFileMetaData.getDocumentation().toString();
                    if (string != null) {
                        object = string.replace(Strings.LN, "<br/>");
                    }
                }
            } else {
                iFile = FileUtils.createLinkToExternalFile((String)stringLiteral.getOp(), (URI)stringLiteral.eResource().getURI());
                if (iFile == null) {
                    object = "This file is outside the workspace and cannot be found.";
                } else {
                    IGamaFileMetaData iGamaFileMetaData = GAMA.getGui().getMetaDataProvider().getMetaData((Object)iFile, false, true);
                    if (iGamaFileMetaData == null) {
                        String string = iFile.getFileExtension();
                        object = "This external " + string + " file has no metadata associated with it";
                    } else {
                        String string = iGamaFileMetaData.getDocumentation().toString();
                        if (string != null) {
                            object = string.replace(Strings.LN, "<br/>");
                        }
                    }
                }
            }
            if (iFile != null) {
                return new Result("File " + String.valueOf(iFile.getFullPath()), (String)object);
            }
        }
        return null;
    }

    public IGamlDescription caseTypeRef(TypeRef typeRef) {
        Statement statement = EGaml.getInstance().getSurroundingStatement((EObject)typeRef);
        final String string = EGaml.getInstance().getKeyOf((EObject)typeRef);
        if (statement instanceof S_Display) {
            IDisplayCreator.DisplayDescription displayDescription = (IDisplayCreator.DisplayDescription)IGui.DISPLAYS.get(string);
            if (displayDescription != null) {
                return displayDescription;
            }
            return new IGamlDescription(){

                public String getTitle() {
                    return "Unknown type of display " + string;
                }

                public IGamlDescription.Doc getDocumentation() {
                    return new IGamlDescription.ConstantDoc(string + " is not a registered display type. Please visit <a href=\"https://gama-platform.org/wiki/Displays\"> https://gama-platform.org/wiki/Displays</a> for more information.");
                }
            };
        }
        if (statement instanceof S_Experiment) {
            IExperimentAgentCreator.ExperimentAgentDescription experimentAgentDescription = (IExperimentAgentCreator.ExperimentAgentDescription)GamaMetaModel.INSTANCE.getExperimentCreator(string);
            if (experimentAgentDescription != null) {
                return experimentAgentDescription;
            }
            return new IGamlDescription(){

                public String getTitle() {
                    return "Unknown type of experiment " + string;
                }

                public IGamlDescription.Doc getDocumentation() {
                    return new IGamlDescription.ConstantDoc(string + " is not a registered experiment type. Please visit <a=href=\"https://gama-platform.org/wiki/DefiningGUIExperiment#types-of-experiments\">https://gama-platform.org/wiki/DefiningGUIExperiment#types-of-experiments</a> for more information.");
                }
            };
        }
        if ("method".equals(string)) {
            return new IGamlDescription(){

                public String getTitle() {
                    return "Definition of the exploration method to use in this experiment ";
                }

                public IGamlDescription.Doc getDocumentation() {
                    return new IGamlDescription.ConstantDoc("The facets that can be defined to specify the exploration are specific to each method. Please visit <a href=\"https://gama-platform.org/wiki/ExplorationMethods\">https://gama-platform.org/wiki/ExplorationMethods</a> for more information.");
                }
            };
        }
        if ("chart".equals(EGaml.getInstance().getKeyOf((EObject)statement))) {
            return new IGamlDescription(){

                public String getTitle() {
                    return "The type (" + string + ") of charts to draw";
                }

                public IGamlDescription.Doc getDocumentation() {
                    return new IGamlDescription.ConstantDoc("Several types of charts are available (pie, series, histogram, xy...). Please visit <a href=\"https://gama-platform.org/wiki/DefiningCharts\">https://gama-platform.org/wiki/DefiningCharts </a> for more information.");
                }
            };
        }
        return null;
    }

    public IGamlDescription caseFacet(Facet facet) {
        String string;
        S_Do s_Do;
        Expression expression;
        EObject eObject = facet.eContainer();
        if (eObject instanceof S_Do && (expression = (s_Do = (S_Do)eObject).getExpr()) instanceof VariableRef) {
            VariableRef variableRef = (VariableRef)expression;
            string = EGaml.getInstance().getKeyOf((EObject)facet);
            if (!DoStatement.DO_FACETS.contains(string)) {
                String string2 = "Argument " + string + " of action " + EGaml.getInstance().getNameOfRef((EObject)s_Do.getExpr());
                IGamlDescription iGamlDescription = this.documenter.getGamlDocumentation((EObject)variableRef);
                String string3 = iGamlDescription == null ? "" : iGamlDescription.getDocumentation().get(string).toString();
                return new Result(string2, string3);
            }
        }
        if ((string = facet.getKey()).endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        EObject eObject2 = facet.eContainer();
        String string4 = EGaml.getInstance().getKeyOf(eObject2);
        if (eObject2 instanceof speciesOrGridDisplayStatement) {
            speciesOrGridDisplayStatement speciesOrGridDisplayStatement2 = (speciesOrGridDisplayStatement)eObject2;
            String string5 = speciesOrGridDisplayStatement2.getKey();
            string4 = "species".equals(string5) ? "species_layer" : "display_grid";
        } else if (eObject2 instanceof S_Definition) {
            S_Definition s_Definition = (S_Definition)eObject2;
            if ("method".equals(string4)) {
                string4 = s_Definition.getName();
            }
        }
        SymbolProto symbolProto = DescriptionFactory.getProto((String)string4, null);
        if (symbolProto != null) {
            return (IGamlDescription)symbolProto.getPossibleFacets().get(string);
        }
        return null;
    }

    public IGamlDescription caseArgumentPair(ArgumentPair argumentPair) {
        Array array;
        EObject eObject;
        ExpressionList expressionList;
        EObject eObject2;
        EObject eObject3 = argumentPair.eContainer();
        if (eObject3 instanceof ExpressionList && (eObject2 = (expressionList = (ExpressionList)eObject3).eContainer()) instanceof Array && (eObject = (array = (Array)eObject2).eContainer()) instanceof Facet) {
            S_Do s_Do;
            Expression expression;
            Facet facet = (Facet)eObject;
            EObject eObject4 = facet.eContainer();
            if (eObject4 instanceof S_Do && (expression = (s_Do = (S_Do)eObject4).getExpr()) instanceof VariableRef) {
                VariableRef variableRef = (VariableRef)expression;
                String string = argumentPair.getOp();
                if (!DoStatement.DO_FACETS.contains(string)) {
                    String string2 = "Argument " + string + " of action " + EGaml.getInstance().getNameOfRef((EObject)variableRef);
                    IGamlDescription iGamlDescription = this.documenter.getGamlDocumentation((EObject)variableRef);
                    String string3 = iGamlDescription == null ? "" : iGamlDescription.getDocumentation().get(string).toString();
                    return new Result(string2, string3);
                }
            } else {
                Statement statement;
                EObject eObject5 = facet.eContainer();
                if (eObject5 instanceof Statement && "create".equals((statement = (Statement)eObject5).getKey())) {
                    String string = argumentPair.getOp();
                    IGamlDescription iGamlDescription = this.documenter.getGamlDocumentation((EObject)statement.getExpr());
                    if (iGamlDescription != null) {
                        String string4 = "Attribute " + string + " defined in " + iGamlDescription.getTitle();
                        String string5 = iGamlDescription.getDocumentation().get(string).toString();
                        return new Result(string4, string5);
                    }
                }
            }
        }
        return null;
    }

    public IGamlDescription caseVariableRef(VariableRef variableRef) {
        Facet facet;
        Object object;
        Statement statement;
        Facet facet2;
        Array array;
        EObject eObject;
        EObject eObject2;
        EObject eObject3;
        ExpressionList expressionList;
        Function function;
        Expression expression;
        ExpressionList expressionList2;
        EObject eObject4;
        EObject eObject5;
        EObject eObject6;
        Object object2;
        S_Do s_Do;
        Expression expression2;
        Facet facet3;
        EObject eObject7;
        ExpressionList expressionList3;
        EObject eObject8;
        Parameter parameter;
        EObject eObject9;
        EObject eObject10 = variableRef.eContainer();
        if (eObject10 instanceof Parameter && (eObject9 = (parameter = (Parameter)eObject10).eContainer()) instanceof ExpressionList && (eObject8 = (expressionList3 = (ExpressionList)eObject9).eContainer()) instanceof Facet && (eObject7 = (facet3 = (Facet)eObject8).eContainer()) instanceof S_Do && (expression2 = (s_Do = (S_Do)eObject7).getExpr()) instanceof VariableRef) {
            VariableRef variableRef2 = (VariableRef)expression2;
            object2 = EGaml.getInstance().getKeyOf((EObject)parameter);
            if (!DoStatement.DO_FACETS.contains(object2)) {
                String string = "Argument " + (String)object2 + " of action " + EGaml.getInstance().getNameOfRef((EObject)s_Do.getExpr());
                IGamlDescription iGamlDescription = this.documenter.getGamlDocumentation((EObject)variableRef2);
                String string2 = iGamlDescription == null ? "" : iGamlDescription.getDocumentation().get((String)object2).toString();
                return new Result(string, string2);
            }
        }
        if ((eObject6 = variableRef.eContainer()) instanceof Parameter && (eObject5 = (object2 = (Parameter)eObject6).eContainer()) instanceof ExpressionList && (eObject4 = (expressionList2 = (ExpressionList)eObject5).eContainer()) instanceof Function && (expression = (function = (Function)eObject4).getLeft()) instanceof ActionRef) {
            ActionRef actionRef = (ActionRef)expression;
            expressionList = this.documenter.getGamlDocumentation((EObject)function);
            if (expressionList != null) {
                VarDefinition varDefinition = variableRef.getRef();
                String string = "Argument " + varDefinition.getName() + " of action " + EGaml.getInstance().getNameOfRef((EObject)function.getLeft());
                String string3 = expressionList.getDocumentation().get(varDefinition.getName()).toString();
                return new Result(string, string3);
            }
        }
        if ((eObject3 = variableRef.eContainer()) instanceof ExpressionList && (eObject2 = (expressionList = (ExpressionList)eObject3).eContainer()) instanceof Array && (eObject = (array = (Array)eObject2).eContainer()) instanceof Facet && (facet2 = (Facet)eObject).getKey().startsWith("skills") && (statement = GamaSkillRegistry.INSTANCE.get((String)(object = (facet = variableRef.getRef()).getName()))) != null) {
            return statement;
        }
        object = variableRef.eContainer();
        if (object instanceof Facet) {
            EObject eObject11;
            facet = (Facet)object;
            if ("style".equals(EGaml.getInstance().getKeyOf((EObject)facet)) && (eObject11 = facet.eContainer()) instanceof Statement) {
                statement = (Statement)eObject11;
                if ("chart".equals(EGaml.getInstance().getKeyOf((EObject)statement))) {
                    return this.getDoc((EObject)facet);
                }
            }
        }
        return null;
    }

    public IGamlDescription caseFunction(Function function) {
        IGamlDescription iGamlDescription;
        S_Definition s_Definition;
        ActionDefinition actionDefinition;
        ActionRef actionRef;
        ActionRef actionRef2 = actionRef = function.getLeft() instanceof ActionRef ? (ActionRef)function.getLeft() : null;
        if (actionRef != null && (actionDefinition = actionRef.getRef()) instanceof S_Definition && (s_Definition = (S_Definition)actionDefinition).getBlock() != null && (iGamlDescription = this.getDoc((EObject)s_Definition)) != null) {
            return iGamlDescription;
        }
        return null;
    }

    public IGamlDescription caseUnitName(UnitName unitName) {
        UnitConstantExpression unitConstantExpression;
        UnitFakeDefinition unitFakeDefinition = unitName.getRef();
        if (unitFakeDefinition != null && (unitConstantExpression = (UnitConstantExpression)GAML.UNITS.get(unitFakeDefinition.getName())) != null) {
            return unitConstantExpression;
        }
        return null;
    }

    public IGamlDescription defaultCase(EObject eObject) {
        return this.documenter.getGamlDocumentation(eObject);
    }

    private IGamlDescription specialCaseVariableRef(VariableRef variableRef) {
        VarDefinition varDefinition = variableRef.getRef();
        return this.documenter.getGamlDocumentation((EObject)varDefinition);
    }

    private IGamlDescription specialCaseTypeRef(TypeRef typeRef) {
        String string = EGaml.getInstance().getKeyOf((EObject)typeRef);
        if (DescriptionFactory.isStatementProto((String)string)) {
            return DescriptionFactory.getStatementProto((String)string);
        }
        if (Types.hasType((String)string)) {
            return Types.get((String)string);
        }
        return null;
    }

    record Result(String title, String doc) implements IGamlDescription
    {
        public IGamlDescription.Doc getDocumentation() {
            return new IGamlDescription.ConstantDoc(this.doc);
        }

        public String getTitle() {
            return this.title;
        }
    }
}

