/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.labeling;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import gama.core.common.interfaces.IGamlLabelProvider;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.operators.Strings;
import gama.gaml.types.Types;
import gaml.compiler.gaml.EGaml;
import gaml.compiler.gaml.Expression;
import gaml.compiler.gaml.Facet;
import gaml.compiler.gaml.HeadlessExperiment;
import gaml.compiler.gaml.Import;
import gaml.compiler.gaml.Model;
import gaml.compiler.gaml.S_Declaration;
import gaml.compiler.gaml.S_Definition;
import gaml.compiler.gaml.S_Experiment;
import gaml.compiler.gaml.Statement;
import gaml.compiler.gaml.StringLiteral;
import gaml.compiler.gaml.VarDefinition;
import gaml.compiler.gaml.VariableRef;
import gaml.compiler.ui.outline.GamlOutlineTreeProvider;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

@Singleton
public class GamlLabelProvider
extends DefaultEObjectLabelProvider
implements IGamlLabelProvider {
    @Inject
    private IQualifiedNameProvider nameProvider;

    @Inject
    public GamlLabelProvider(AdapterFactoryLabelProvider adapterFactoryLabelProvider) {
        super(adapterFactoryLabelProvider);
    }

    String image(Model model) {
        return "_model.png";
    }

    String text(Import import_) {
        String string = import_.getImportURI();
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return "import " + string;
    }

    String text(HeadlessExperiment headlessExperiment) {
        return "Experiment " + headlessExperiment.getName();
    }

    String text(EObject eObject) {
        String string = EGaml.getInstance().getKeyOf(eObject);
        if (string == null) {
            string = "";
        }
        Object object = string;
        string = null;
        if (eObject instanceof Statement) {
            Expression expression;
            if ("parameter".equals(object)) {
                return this.parameterText((Statement)eObject);
            }
            if (GamlOutlineTreeProvider.isAttribute((Statement)eObject)) {
                return this.attributeText((S_Definition)eObject);
            }
            if (GamlOutlineTreeProvider.isAction((Statement)eObject)) {
                return GamlLabelProvider.actionText((Statement)eObject);
            }
            String string2 = EGaml.getInstance().getNameOf(eObject);
            if (string2 == null && (expression = ((Statement)eObject).getExpr()) != null) {
                string2 = EGaml.getInstance().getKeyOf((EObject)expression);
            }
            if (string2 == null) {
                expression = null;
                try {
                    expression = this.nameProvider.getFullyQualifiedName(eObject);
                    string2 = expression == null ? null : expression.toString();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string2 = null;
                }
            }
            object = (String)object + " " + (string2 == null ? "" : string2);
        }
        return StringUtils.capitalize((String)object);
    }

    private String attributeText(S_Definition s_Definition) {
        Object object;
        Object object2;
        String string = EGaml.getInstance().getKeyOf((EObject)s_Definition);
        String string2 = "const".equals(string) ? string : null;
        Map map = EGaml.getInstance().getFacetsMapOf((EObject)s_Definition);
        if (s_Definition.getBlock() != null) {
            string2 = "function";
        } else if (map.containsKey("function") || map.containsKey("->")) {
            string = "function";
        }
        if (("var".equals(string) || "const".equals(string)) && (object2 = (Facet)map.get("type")) != null) {
            string = EGaml.getInstance().getKeyOf((EObject)object2.getExpr());
        }
        if ((object2 = EGaml.getInstance().getNameOf((EObject)s_Definition)) == null && (object = s_Definition.getExpr()) != null) {
            object2 = EGaml.getInstance().getKeyOf((EObject)object);
        }
        if (object2 == null) {
            object = null;
            try {
                object = this.nameProvider.getFullyQualifiedName((EObject)s_Definition);
                object2 = object == null ? null : object.toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object2 = null;
            }
        }
        object = "Attribute ";
        if (string.contains("file")) {
            string = "file";
        }
        if (Types.get((String)string) == Types.NO_TYPE) {
            object = Strings.capitalize(null, (String)string) + " ";
        }
        return (String)object + (object2 == null ? "" : object2) + (String)(string == null ? "" : " (" + string + ") " + (String)(string2 == null ? "" : "(" + string2 + ") "));
    }

    private static String actionText(Statement statement) {
        String string = EGaml.getInstance().getKeyOf((EObject)statement);
        String string2 = EGaml.getInstance().getNameOf((EObject)statement);
        return "Action " + string2 + " " + (String)("action".equals(string) ? "" : " (" + string + ")");
    }

    String text(Model model) {
        return "Model " + model.getName();
    }

    protected String parameterText(Statement statement) {
        VarDefinition varDefinition;
        Object object;
        String string = null;
        String string2 = null;
        Map map = EGaml.getInstance().getFacetsMapOf((EObject)statement);
        Facet facet = (Facet)map.get("var");
        if (facet != null && (object = facet.getExpr()) instanceof VariableRef && (varDefinition = ((VariableRef)object).getRef()) instanceof S_Declaration) {
            string = EGaml.getInstance().getKeyOf((EObject)varDefinition);
            string2 = EGaml.getInstance().getNameOf((EObject)varDefinition);
        }
        object = null;
        facet = (Facet)map.get("name");
        if (facet == null) {
            varDefinition = statement.getExpr();
            if (varDefinition instanceof StringLiteral) {
                object = ((StringLiteral)varDefinition).getOp();
            }
        } else {
            varDefinition = facet.getExpr();
            if (varDefinition instanceof StringLiteral) {
                object = ((StringLiteral)varDefinition).getOp();
            }
        }
        return "Parameter \"" + (String)object + "\"" + (String)(string2 == null ? "" : " (" + string2 + ")" + (String)(string == null ? "" : " (" + string + ")"));
    }

    String image(Import import_) {
        return "_include.png";
    }

    String image(S_Experiment s_Experiment) {
        List list = EGaml.getInstance().getFacetsOf((EObject)s_Experiment);
        Facet facet = null;
        for (Facet facet2 : list) {
            if (!facet2.getKey().startsWith("type")) continue;
            facet = facet2;
            break;
        }
        if (facet == null) {
            return "_gui.png";
        }
        return this.typeImage(EGaml.getInstance().toString((EObject)facet.getExpr()));
    }

    String image(HeadlessExperiment headlessExperiment) {
        List list = EGaml.getInstance().getFacetsOf((EObject)headlessExperiment);
        Facet facet = null;
        for (Facet facet2 : list) {
            if (!facet2.getKey().startsWith("type")) continue;
            facet = facet2;
            break;
        }
        if (facet == null) {
            return "_batch.png";
        }
        return this.typeImage(EGaml.getInstance().toString((EObject)facet.getExpr()));
    }

    public String image(Statement statement) {
        String string = EGaml.getInstance().getKeyOf((EObject)statement);
        if (string == null) {
            return null;
        }
        if ("parameter".equals(string)) {
            return this.parameterImage(statement);
        }
        if ("var".equals(string) || "const".equals(string)) {
            for (Facet facet : EGaml.getInstance().getFacetsOf((EObject)statement)) {
                if (!EGaml.getInstance().getKeyOf((EObject)facet).startsWith("type")) continue;
                return this.typeImage(EGaml.getInstance().getKeyOf((EObject)facet.getExpr()));
            }
        }
        return this.typeImage(string);
    }

    protected String parameterImage(Statement statement) {
        VarDefinition varDefinition;
        Expression expression;
        if (!"parameter".equals(statement.getKey())) {
            return "_parameter.png";
        }
        String string = null;
        Facet facet = (Facet)EGaml.getInstance().getFacetsMapOf((EObject)statement).get("var");
        if (facet != null && (expression = facet.getExpr()) instanceof VariableRef && (varDefinition = ((VariableRef)expression).getRef()) instanceof S_Declaration) {
            string = EGaml.getInstance().getKeyOf((EObject)varDefinition);
        }
        if (string == null) {
            return "_parameter.png";
        }
        return this.typeImage(string);
    }

    public String typeImage(String string) {
        if (string.contains("_file")) {
            string = "file";
        }
        return "_" + string + ".png";
    }

    public String getText(ISyntacticElement iSyntacticElement) {
        return this.getText(iSyntacticElement.getElement());
    }

    public ImageDescriptor getImageDescriptor(ISyntacticElement iSyntacticElement) {
        return this.getImageDescriptor(iSyntacticElement.getElement());
    }

    public ImageDescriptor convertToImageDescriptor(Object object) {
        return super.convertToImageDescriptor(object);
    }
}

