/*
 * Decompiled with CFR 0.152.
 */
package gaml.compiler.ui.reference;

import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.utils.WorkbenchHelper;
import gaml.compiler.ui.editor.GamlEditor;
import java.util.Comparator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class GamlReferenceMenu
extends GamaMenu {
    protected static final Comparator<String> IGNORE_CASE = String::compareToIgnoreCase;

    protected void open(Decorations decorations, SelectionEvent selectionEvent) {
        boolean bl = this.mainMenu == null;
        ToolItem toolItem = (ToolItem)selectionEvent.widget;
        ToolBar toolBar = toolItem.getParent();
        if (bl) {
            this.mainMenu = new Menu(decorations, 8);
            this.fillMenu();
        }
        Point point = toolBar.toDisplay(new Point(selectionEvent.x, selectionEvent.y));
        this.mainMenu.setLocation(point.x, point.y);
        this.mainMenu.setVisible(true);
    }

    protected abstract void openView();

    protected abstract void fillMenu();

    protected GamlEditor getEditor() {
        return (GamlEditor)WorkbenchHelper.getActiveEditor();
    }

    public void reset() {
        if (this.mainMenu != null && !this.mainMenu.isDisposed()) {
            super.reset();
        }
    }

    protected final void applyText(String string) {
        GamlEditor gamlEditor = this.getEditor();
        if (gamlEditor == null) {
            return;
        }
        gamlEditor.insertText(string);
    }

    public void applyTemplate(Template template) {
        GamlEditor gamlEditor = this.getEditor();
        if (gamlEditor == null) {
            return;
        }
        gamlEditor.applyTemplate(template);
    }

    public void installSubMenuIn(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(this.getTitle());
        menuItem.setImage(this.getImage());
        this.mainMenu = new Menu(menuItem);
        menuItem.setMenu(this.mainMenu);
        this.mainMenu.addListener(22, event -> {
            if (this.mainMenu.getItemCount() > 0) {
                if (!this.isDynamic()) {
                    return;
                }
                MenuItem[] menuItemArray = this.mainMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem menuItem = menuItemArray[n2];
                    menuItem.dispose();
                    ++n2;
                }
            }
            this.fillMenu();
        });
    }

    protected abstract boolean isDynamic();

    protected abstract Image getImage();

    protected abstract String getTitle();
}

