/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.factories;

import gama.core.common.interfaces.IConsoleListener;
import gama.core.common.interfaces.IGamaView;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.runtime.GAMA;
import gama.core.util.GamaColor;
import gama.ui.application.workbench.PerspectiveHelper;
import gama.ui.shared.utils.ViewsHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;

public class ConsoleDisplayerFactory
extends AbstractServiceFactory {
    IConsoleListener displayer = new ConsoleDisplayer();

    public Object create(Class clazz, IServiceLocator iServiceLocator, IServiceLocator iServiceLocator2) {
        return this.displayer;
    }

    static class ConsoleDisplayer
    implements IConsoleListener {
        Map<GamaColor, StringBuilder> consoleBuffers = new HashMap<GamaColor, StringBuilder>();

        ConsoleDisplayer() {
        }

        public void informConsole(String string, ITopLevelAgent iTopLevelAgent, GamaColor gamaColor) {
            IGamaView.Console[] consoleArray = new IGamaView.Console[1];
            try {
                consoleArray[0] = (IGamaView.Console)ViewsHelper.findView((String)"gama.ui.application.view.ConsoleView", null, (boolean)true);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
            if (consoleArray[0] == null) {
                WorkbenchHelper.run(() -> {
                    if (!PerspectiveHelper.showConsoles()) {
                        return;
                    }
                    consoleArray[0] = (IGamaView.Console)GAMA.getGui().showView(null, "gama.ui.application.view.ConsoleView", null, 2);
                });
            }
            if (consoleArray[0] != null) {
                consoleArray[0].append(string, iTopLevelAgent, gamaColor);
            } else {
                GamaColor gamaColor2 = gamaColor == null ? (iTopLevelAgent == null ? GamaColor.get((int)0) : iTopLevelAgent.getColor()) : gamaColor;
                StringBuilder stringBuilder = this.consoleBuffers.get(gamaColor2);
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(2000);
                    this.consoleBuffers.put(gamaColor2, stringBuilder);
                }
                stringBuilder.append(string);
            }
        }

        public void eraseConsole(boolean bl) {
            IGamaView iGamaView = (IGamaView)ViewsHelper.findView((String)"gama.ui.application.view.ConsoleView", null, (boolean)false);
            if (iGamaView != null) {
                WorkbenchHelper.run(() -> iGamaView.reset());
            }
            this.consoleBuffers.clear();
        }

        public void toggleConsoleViews(ITopLevelAgent iTopLevelAgent, boolean bl) {
            if (!bl) {
                ViewsHelper.hideView((String)"gama.ui.application.view.ConsoleView");
                ViewsHelper.hideView((String)"gama.ui.application.view.InteractiveConsoleView");
            } else {
                GAMA.getGui().showView(null, "gama.ui.application.view.InteractiveConsoleView", null, 2);
                IGamaView.Console console = (IGamaView.Console)GAMA.getGui().showView(null, "gama.ui.application.view.ConsoleView", null, 2);
                this.consoleBuffers.forEach((gamaColor, stringBuilder) -> {
                    if (stringBuilder.length() > 0 && console != null) {
                        console.append(stringBuilder.toString(), iTopLevelAgent, gamaColor);
                        stringBuilder.setLength(0);
                    }
                });
            }
        }
    }
}

