/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.displays;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IDisposable;
import gama.dev.DEBUG;
import gama.ui.experiment.views.displays.LayeredDisplayDecorator;
import gama.ui.experiment.views.displays.LayeredDisplayMultiListener;
import gama.ui.shared.bindings.GamaKeyBindings;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.function.Supplier;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class SWTLayeredDisplayMultiListener
implements MenuDetectListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
MouseWheelListener,
KeyListener,
DragDetectListener,
FocusListener,
IDisposable {
    final LayeredDisplayMultiListener delegate;
    Control control;
    final Supplier<Boolean> ok;

    static {
        DEBUG.ON();
    }

    public SWTLayeredDisplayMultiListener(LayeredDisplayDecorator layeredDisplayDecorator, IDisplaySurface iDisplaySurface) {
        this.delegate = new LayeredDisplayMultiListener(iDisplaySurface, layeredDisplayDecorator);
        this.control = layeredDisplayDecorator.view.getInteractionControl();
        this.ok = () -> {
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = layeredDisplayDecorator.view != null && !layeredDisplayDecorator.view.disposed;
            if (!bl2) {
                return false;
            }
            boolean bl4 = bl = this.control != null && !this.control.isDisposed();
            if (!bl) {
                return false;
            }
            if (iDisplaySurface != null && !iDisplaySurface.isDisposed()) {
                return true;
            }
            return false;
        };
        this.control.addKeyListener((KeyListener)this);
        this.control.addMouseListener((MouseListener)this);
        this.control.addMenuDetectListener((MenuDetectListener)this);
        this.control.addDragDetectListener((DragDetectListener)this);
        this.control.addMouseTrackListener((MouseTrackListener)this);
        this.control.addMouseMoveListener((MouseMoveListener)this);
        this.control.addFocusListener((FocusListener)this);
    }

    public void dispose() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        this.control.removeKeyListener((KeyListener)this);
        this.control.removeMouseListener((MouseListener)this);
        this.control.removeMenuDetectListener((MenuDetectListener)this);
        this.control.removeDragDetectListener((DragDetectListener)this);
        this.control.removeMouseTrackListener((MouseTrackListener)this);
        this.control.removeMouseMoveListener((MouseMoveListener)this);
        this.control.removeFocusListener((FocusListener)this);
    }

    public void keyPressed(org.eclipse.swt.events.KeyEvent keyEvent) {
        if (!this.ok.get().booleanValue() || keyEvent.stateMask != 0) {
            return;
        }
        switch (keyEvent.keyCode) {
            case 0x1000002: {
                this.delegate.specialKeyPressed(13);
                return;
            }
            case 0x1000001: {
                this.delegate.specialKeyPressed(12);
                return;
            }
            case 0x1000003: {
                this.delegate.specialKeyPressed(10);
                return;
            }
            case 0x1000004: {
                this.delegate.specialKeyPressed(11);
                return;
            }
            case 27: {
                this.delegate.specialKeyPressed(15);
                return;
            }
            case 9: {
                this.delegate.specialKeyPressed(14);
                return;
            }
            case 0x1000006: {
                this.delegate.specialKeyPressed(17);
                return;
            }
            case 0x1000005: {
                this.delegate.specialKeyPressed(16);
                return;
            }
            case 13: 
            case 0x1000050: {
                this.delegate.specialKeyPressed(18);
                return;
            }
            case 0x400000: {
                this.delegate.specialKeyPressed(20);
                return;
            }
            case 131072: {
                this.delegate.specialKeyPressed(22);
                return;
            }
            case 65536: {
                this.delegate.specialKeyPressed(21);
                return;
            }
            case 262144: {
                this.delegate.specialKeyPressed(19);
                return;
            }
        }
        this.delegate.keyPressed(keyEvent.character, GamaKeyBindings.ctrl((org.eclipse.swt.events.KeyEvent)keyEvent));
    }

    public void keyReleased(org.eclipse.swt.events.KeyEvent keyEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        switch (keyEvent.keyCode) {
            case 0x1000002: {
                this.delegate.specialKeyReleased(13);
                return;
            }
            case 0x1000001: {
                this.delegate.specialKeyReleased(12);
                return;
            }
            case 0x1000003: {
                this.delegate.specialKeyReleased(10);
                return;
            }
            case 0x1000004: {
                this.delegate.specialKeyReleased(11);
                return;
            }
            case 27: {
                this.delegate.specialKeyReleased(15);
                return;
            }
            case 9: {
                this.delegate.specialKeyReleased(14);
                return;
            }
            case 0x1000006: {
                this.delegate.specialKeyReleased(17);
                return;
            }
            case 0x1000005: {
                this.delegate.specialKeyReleased(16);
                return;
            }
            case 13: 
            case 0x1000050: {
                this.delegate.specialKeyReleased(18);
                return;
            }
            case 0x400000: {
                this.delegate.specialKeyReleased(20);
                return;
            }
            case 131072: {
                this.delegate.specialKeyReleased(22);
                return;
            }
            case 65536: {
                this.delegate.specialKeyReleased(21);
                return;
            }
            case 262144: {
                this.delegate.specialKeyReleased(19);
                return;
            }
        }
        this.delegate.keyReleased(keyEvent.character, GamaKeyBindings.ctrl((org.eclipse.swt.events.KeyEvent)keyEvent));
    }

    private void filter(org.eclipse.swt.events.MouseEvent mouseEvent) {
    }

    public void mouseScrolled(org.eclipse.swt.events.MouseEvent mouseEvent) {
        this.filter(mouseEvent);
    }

    public void mouseEnter(org.eclipse.swt.events.MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.filter(mouseEvent);
        this.delegate.mouseEnter(mouseEvent.x, mouseEvent.y, (mouseEvent.stateMask & SWT.MODIFIER_MASK) != 0, mouseEvent.button);
    }

    public void mouseExit(org.eclipse.swt.events.MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.filter(mouseEvent);
        this.delegate.mouseExit(mouseEvent.x, mouseEvent.y, (mouseEvent.stateMask & SWT.MODIFIER_MASK) != 0, mouseEvent.button);
    }

    public void mouseHover(org.eclipse.swt.events.MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.filter(mouseEvent);
        this.delegate.mouseHover(mouseEvent.x, mouseEvent.y, mouseEvent.button);
    }

    public void mouseMove(org.eclipse.swt.events.MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.filter(mouseEvent);
        this.delegate.mouseMove(mouseEvent.x, mouseEvent.y, (mouseEvent.stateMask & SWT.MODIFIER_MASK) != 0);
    }

    public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent mouseEvent) {
    }

    public void mouseDown(org.eclipse.swt.events.MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.filter(mouseEvent);
        DEBUG.OUT((Object)("Mouse down " + String.valueOf(mouseEvent)));
        this.delegate.mouseDown(mouseEvent.x, mouseEvent.y, mouseEvent.button, (mouseEvent.stateMask & SWT.MODIFIER_MASK) != 0);
    }

    public void mouseUp(org.eclipse.swt.events.MouseEvent mouseEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.filter(mouseEvent);
        DEBUG.OUT((Object)("Mouse up " + String.valueOf(mouseEvent)));
        this.delegate.mouseUp(mouseEvent.x, mouseEvent.y, mouseEvent.button, (mouseEvent.stateMask & SWT.MODIFIER_MASK) != 0);
    }

    public void menuDetected(MenuDetectEvent menuDetectEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        DEBUG.LOG((Object)"Menu detected ");
        Point point = this.control.toControl(menuDetectEvent.x, menuDetectEvent.y);
        this.delegate.menuDetected(point.x, point.y);
    }

    public void dragDetected(DragDetectEvent dragDetectEvent) {
        if (!this.ok.get().booleanValue()) {
            return;
        }
        this.filter((org.eclipse.swt.events.MouseEvent)dragDetectEvent);
        this.delegate.dragDetected(dragDetectEvent.x, dragDetectEvent.y);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.delegate.focusGained();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.delegate.focusLost();
    }

    public java.awt.event.KeyListener getKeyAdapterForAWT() {
        return new java.awt.event.KeyListener(){
            long previous;

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getWhen() == this.previous) {
                    return;
                }
                this.previous = keyEvent.getWhen();
                DEBUG.LOG((Object)("Key received by the AWT listener. Code " + keyEvent.getKeyCode() + " Action ? " + keyEvent.isActionKey()));
                if (!keyEvent.isActionKey()) {
                    SWTLayeredDisplayMultiListener.this.delegate.keyPressed(keyEvent.getKeyChar(), keyEvent.isControlDown());
                } else if (keyEvent.getModifiersEx() == 0) {
                    LayeredDisplayMultiListener layeredDisplayMultiListener = SWTLayeredDisplayMultiListener.this.delegate;
                    layeredDisplayMultiListener.specialKeyPressed(switch (keyEvent.getKeyCode()) {
                        case 38, 224 -> 12;
                        case 40, 225 -> 13;
                        case 37, 226 -> 10;
                        case 39, 227 -> 11;
                        case 33 -> 16;
                        case 34 -> 17;
                        case 27 -> 15;
                        case 10 -> 18;
                        case 9 -> 14;
                        case 16 -> 22;
                        case 18 -> 21;
                        case 17 -> 19;
                        case 157 -> 20;
                        default -> 0;
                    });
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DEBUG.LOG((Object)("Key released by the AWT listener. Code " + keyEvent.getKeyCode() + " Action ? " + keyEvent.isActionKey()));
                if (!keyEvent.isActionKey()) {
                    SWTLayeredDisplayMultiListener.this.delegate.keyReleased(keyEvent.getKeyChar(), keyEvent.isControlDown());
                } else if (keyEvent.getModifiersEx() == 0) {
                    LayeredDisplayMultiListener layeredDisplayMultiListener = SWTLayeredDisplayMultiListener.this.delegate;
                    layeredDisplayMultiListener.specialKeyReleased(switch (keyEvent.getKeyCode()) {
                        case 38, 224 -> 12;
                        case 40, 225 -> 13;
                        case 37, 226 -> 10;
                        case 39, 227 -> 11;
                        case 33 -> 16;
                        case 34 -> 17;
                        case 27 -> 15;
                        case 10 -> 18;
                        case 9 -> 14;
                        default -> 0;
                    });
                }
            }
        };
    }

    public MouseMotionListener getMouseAdapterForAWT() {
        return new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                SWTLayeredDisplayMultiListener.this.delegate.dragDetected(mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                SWTLayeredDisplayMultiListener.this.delegate.mouseMove(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers() != 0);
            }
        };
    }
}

