/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.controls;

import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.runtime.GAMA;
import gama.core.util.GamaColor;
import gama.dev.DEBUG;
import gama.gaml.compilation.GamlIdiomsProvider;
import gama.ui.experiment.controls.StatusControlContribution;
import gama.ui.experiment.menus.SimulationsMenu;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SimulationPopupMenu
extends PopupDialog {
    Composite parent;
    Composite contents;
    Composite toolbarComposite;
    ToolBar toolbar;
    List<Composite> labels = new CopyOnWriteArrayList<Composite>();
    ToolItem add;
    ToolItem kill;
    ToolItem loadNew;
    ToolItem loadAndReplace;
    ToolItem duplicate;
    ToolItem save;
    ToolItem saveHistory;
    final Listener hide = event -> this.hide();
    private final StatusControlContribution status;

    static {
        DEBUG.ON();
    }

    public SimulationPopupMenu(StatusControlContribution statusControlContribution) {
        super(WorkbenchHelper.getShell(), 540676, false, false, false, false, false, null, null);
        this.status = statusControlContribution;
        Shell shell = statusControlContribution.getControllingShell();
        shell.addListener(10, this.hide);
        shell.addListener(11, this.hide);
        shell.addListener(21, this.hide);
        shell.addListener(27, this.hide);
        shell.addListener(23, this.hide);
        shell.addListener(12, event -> {
            boolean bl = this.close();
        });
    }

    List<ITopLevelAgent> getAgentsToDisplay() {
        IExperimentPlan iExperimentPlan = GAMA.getExperiment();
        if (iExperimentPlan == null) {
            return Collections.EMPTY_LIST;
        }
        ExperimentAgent experimentAgent = GAMA.getExperiment().getAgent();
        if (experimentAgent == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ITopLevelAgent> arrayList = new ArrayList<ITopLevelAgent>();
        arrayList.add((ITopLevelAgent)experimentAgent);
        SimulationPopulation simulationPopulation = experimentAgent.getSimulationPopulation();
        if (simulationPopulation == null) {
            return arrayList;
        }
        arrayList.addAll((Collection<ITopLevelAgent>)GAMA.getExperiment().getAgent().getSimulationPopulation());
        return arrayList;
    }

    protected Control createContents(Composite composite) {
        if (this.parent != composite || this.parent.isDisposed()) {
            this.parent = composite;
            GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(this.parent);
        }
        this.createToolbar();
        if (this.contents == null || this.contents.isDisposed()) {
            this.contents = (Composite)super.createDialogArea(this.parent);
            GridDataFactory.swtDefaults().grab(true, true).align(4, 0x1000000).applyTo((Control)this.contents);
            GridLayoutFactory.swtDefaults().numColumns(1).margins(5, 5).spacing(0, 5).applyTo(this.contents);
        }
        this.fillLabels(this.getAgentsToDisplay());
        return this.contents;
    }

    private void fillLabels(List<ITopLevelAgent> list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                ITopLevelAgent iTopLevelAgent = list.get(n2);
                Composite composite = this.getOrCreateLabel(n2);
                Label label = (Label)composite.getChildren()[0];
                Label label2 = (Label)composite.getChildren()[1];
                label.setImage(GamaIcon.ofColor((GamaColors.GamaUIColor)GamaColors.get((java.awt.Color)iTopLevelAgent.getColor()), (boolean)false).image());
                composite.setData((Object)iTopLevelAgent);
                label2.setText(GamlIdiomsProvider.toText((String)this.status.popupTextFor(iTopLevelAgent)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        if (n < this.labels.size()) {
            n2 = n;
            while (n2 < this.labels.size()) {
                this.labels.get(n2).dispose();
                this.labels.remove(n2);
                ++n2;
            }
        }
    }

    Composite getOrCreateLabel(int n) {
        Composite composite;
        if (n > this.labels.size() - 1) {
            this.labels.add(this.createLabel());
        }
        if ((composite = this.labels.get(n)) == null || composite.isDisposed()) {
            this.labels.remove(n);
            composite = this.createLabel();
            this.labels.add(n, composite);
        }
        return composite;
    }

    private Composite createLabel() {
        try {
            final Composite composite = new Composite(this.contents, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).spacing(5, 0).applyTo(composite);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)composite);
            Label label = new Label(composite, 0);
            final Label label2 = new Label(composite, 0);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, true).applyTo((Control)label);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)label2);
            label2.addMouseTrackListener(new MouseTrackListener(){
                Color background;
                Color foreground;

                public void mouseHover(MouseEvent mouseEvent) {
                }

                public void mouseEnter(MouseEvent mouseEvent) {
                    this.background = label2.getBackground();
                    this.foreground = label2.getForeground();
                    GamaColor gamaColor = ((ITopLevelAgent)composite.getData()).getColor();
                    Color color = GamaColors.toSwtColor((java.awt.Color)gamaColor);
                    GamaColors.setBackAndForeground((Color)color, (Color)GamaColors.getTextColorForBackground((Color)color).color(), (Control[])new Control[]{label2});
                }

                public void mouseExit(MouseEvent mouseEvent) {
                    GamaColors.setBackAndForeground((Color)this.background, (Color)this.foreground, (Control[])new Control[]{label2});
                }
            });
            label2.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    SimulationPopupMenu.this.hide();
                    SimulationPopupMenu.this.status.setSelection((ITopLevelAgent)composite.getData());
                }
            });
            return composite;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void createToolbar() {
        if (this.toolbarComposite == null || this.toolbarComposite.isDisposed()) {
            try {
                this.toolbarComposite = new Composite(this.parent, 2048);
                RowLayoutFactory.swtDefaults().center(true).fill(true).applyTo(this.toolbarComposite);
                GridDataFactory.swtDefaults().grab(true, true).align(4, 0x1000000).applyTo((Control)this.toolbarComposite);
                this.toolbar = new ToolBar(this.toolbarComposite, 0x800100);
                RowDataFactory.swtDefaults().exclude(false).applyTo((Control)this.toolbar);
                this.add = SimulationsMenu.addNewSimulation.toItem(this.toolbar);
                this.kill = SimulationsMenu.killCurrentSimulation.toItem(this.toolbar);
                this.duplicate = SimulationsMenu.duplicateCurrentSimulation.toItem(this.toolbar);
                new ToolItem(this.toolbar, 2);
                this.save = SimulationsMenu.saveCurrentSimulation.toItem(this.toolbar);
                this.saveHistory = SimulationsMenu.saveCurrentSimulationAndHistory.toItem(this.toolbar);
                this.loadAndReplace = SimulationsMenu.replaceCurrentSimulation.toItem(this.toolbar);
                this.loadNew = SimulationsMenu.loadNewSimulation.toItem(this.toolbar);
            }
            catch (Exception exception) {
                this.toolbarComposite = null;
                this.toolbar = null;
                return;
            }
        }
        boolean bl = GAMA.getCurrentTopLevelAgent() instanceof IExperimentAgent;
        boolean bl2 = GAMA.getCurrentTopLevelAgent() instanceof SimulationAgent;
        boolean bl3 = bl2 && GAMA.getExperiment() != null && GAMA.getExperiment().isMemorize();
        this.add.setEnabled(bl || bl2);
        this.kill.setEnabled(bl2);
        this.duplicate.setEnabled(bl2);
        this.save.setEnabled(bl2);
        this.saveHistory.setEnabled(bl3);
        this.loadAndReplace.setEnabled(bl2);
        this.loadNew.setEnabled(bl || bl2);
    }

    protected boolean hasTitleArea() {
        return false;
    }

    protected boolean hasInfoArea() {
        return false;
    }

    protected void showDialogMenu() {
    }

    protected void setInfoText(String string) {
    }

    protected void setTitleText(String string) {
    }

    protected void saveDialogBounds(Shell shell) {
    }

    protected Point getDefaultLocation(Point point) {
        Point point2 = this.status.getLocation();
        return new Point(point2.x, point2.y + this.status.getHeight() - 4);
    }

    protected Point getDefaultSize() {
        int n = this.status.getWidth();
        if (n <= 0) {
            n = -1;
        }
        return this.getShell().computeSize(n, -1, true);
    }

    public boolean isVisible() {
        return this.getShell() != null && this.getShell().isVisible();
    }

    public void display() {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            this.createContents(this.parent);
            shell.setLocation(this.getDefaultLocation(null));
            shell.setSize(this.getDefaultSize());
            shell.setVisible(true);
        } else {
            this.open();
        }
    }

    public void hide() {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.setVisible(false);
        }
    }

    public void wipe() {
        for (Control control : this.labels) {
            if (control.isDisposed()) continue;
            control.setData(null);
        }
    }
}

