/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.factories;

import gama.core.common.ErrorStatusMessage;
import gama.core.common.StatusMessage;
import gama.core.common.SubTaskMessage;
import gama.core.common.UserStatusMessage;
import gama.core.common.interfaces.IStatusDisplayer;
import gama.core.common.interfaces.IStatusMessage;
import gama.core.common.interfaces.ITopLevelAgentChangeListener;
import gama.core.common.interfaces.IUpdaterMessage;
import gama.core.common.interfaces.IUpdaterTarget;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.ui.experiment.controls.StatusControlContribution;
import gama.ui.shared.utils.ThreadedUpdater;

public class StatusDisplayer
implements IStatusDisplayer {
    private final ThreadedUpdater<IStatusMessage> status = new ThreadedUpdater("Status refresh");

    StatusDisplayer() {
        this.status.setTarget((IUpdaterTarget)StatusControlContribution.getInstance(), null);
        GAMA.registerTopLevelAgentChangeListener((ITopLevelAgentChangeListener)this);
    }

    public void topLevelAgentChanged(ITopLevelAgent iTopLevelAgent) {
        this.informStatus(iTopLevelAgent.getScope(), null, "overlays/status.clock");
    }

    public void waitStatus(IScope iScope, String string) {
        this.setStatus(string, 1);
    }

    public void informStatus(IScope iScope, String string) {
        this.setStatus(string, 2);
    }

    public void errorStatus(IScope iScope, Exception exception) {
        this.setStatus(exception);
    }

    public void neutralStatus(IScope iScope, String string) {
        this.setStatus(string, 3);
    }

    private void setStatus(String string, int n) {
        this.status.updateWith((IUpdaterMessage)new StatusMessage(string, n));
    }

    private void setStatus(Exception exception) {
        this.status.updateWith((IUpdaterMessage)new ErrorStatusMessage(exception));
    }

    public void setStatus(IScope iScope, String string, String string2) {
        this.setStatusInternal(string, null, string2);
    }

    public void resumeStatus(IScope iScope) {
        this.status.resume();
    }

    public void setSubStatusCompletion(IScope iScope, double d) {
        this.status.updateWith((IUpdaterMessage)new SubTaskMessage(Double.valueOf(d)));
    }

    public void informStatus(IScope iScope, String string, String string2) {
        this.status.updateWith((IUpdaterMessage)new StatusMessage(string, 2, string2));
    }

    public void beginSubStatus(IScope iScope, String string) {
        this.status.updateWith((IUpdaterMessage)new SubTaskMessage(string, true));
    }

    public void endSubStatus(IScope iScope, String string) {
        this.status.updateWith((IUpdaterMessage)new SubTaskMessage(string, false));
    }

    private void setStatusInternal(String string, GamaColor gamaColor, String string2) {
        this.status.updateWith((IUpdaterMessage)new UserStatusMessage(string, gamaColor, string2));
    }

    public void setStatus(IScope iScope, String string, GamaColor gamaColor) {
        if (string == null) {
            this.resumeStatus(iScope);
        } else {
            this.setStatusInternal(string, gamaColor, null);
        }
    }
}

