/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.menus;

import gama.core.common.interfaces.IGui;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.ValuedDisplayOutputFactory;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.PlatformHelper;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.UserCommandStatement;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.menus.MenuAction;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class AgentsMenu
extends ContributionItem {
    private static SelectionAdapter inspector = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.widget;
            IAgent iAgent = (IAgent)menuItem.getData("agent");
            if (iAgent != null && !iAgent.dead()) {
                iAgent.getScope().getGui().setSelectedAgent(iAgent);
            }
        }
    };
    public static final SelectionAdapter highlighter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.widget;
            IAgent iAgent = (IAgent)menuItem.getData("agent");
            if (iAgent != null && !iAgent.dead()) {
                IGui iGui = iAgent.getScope().getGui();
                if (iGui.getHighlightedAgent() != iAgent) {
                    iGui.setHighlightedAgent(iAgent);
                } else {
                    iGui.setHighlightedAgent(null);
                }
                GAMA.getExperiment().refreshAllOutputs();
            }
        }
    };
    private static SelectionAdapter killer = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.widget;
            IAgent iAgent = (IAgent)menuItem.getData("agent");
            if (iAgent != null && !iAgent.dead()) {
                iAgent.dispose();
                GAMA.getExperiment().refreshAllOutputs();
            }
        }
    };
    private static SelectionAdapter runner = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.widget;
            IAgent iAgent = (IAgent)menuItem.getData("agent");
            IStatement iStatement = (IStatement)menuItem.getData("command");
            if (iStatement != null && iAgent != null && !iAgent.dead()) {
                IScope iScope2 = iAgent.getScope();
                iScope2.getSimulation().executeAction(iScope -> {
                    Arguments arguments = new Arguments();
                    ExecutionResult executionResult = iScope.execute((IExecutable)iStatement, iAgent, arguments);
                    GAMA.getExperiment().refreshAllOutputs();
                    return executionResult.getValue();
                });
            }
        }
    };

    public static MenuItem cascadingAgentMenuItem(Menu menu, IAgent iAgent, String string, MenuAction ... menuActionArray) {
        Image image;
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(string);
        if (iAgent instanceof SimulationAgent) {
            SimulationAgent simulationAgent = (SimulationAgent)iAgent;
            image = GamaIcon.ofColor((GamaColors.GamaUIColor)GamaColors.get((Color)simulationAgent.getColor()), (boolean)false).image();
        } else {
            image = GamaIcon.named((String)"agents/agent.submenu").image();
        }
        menuItem.setImage(image);
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        AgentsMenu.createMenuForAgent(menu2, iAgent, iAgent instanceof ITopLevelAgent, true, menuActionArray);
        return menuItem;
    }

    private static MenuItem actionAgentMenuItem(Menu menu, IAgent iAgent, SelectionListener selectionListener, Image image, String string) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(string);
        menuItem.addSelectionListener(selectionListener);
        menuItem.setImage(image);
        menuItem.setData("agent", (Object)iAgent);
        return menuItem;
    }

    private static MenuItem browsePopulationMenuItem(Menu menu, final Collection<? extends IAgent> collection, Image image) {
        MenuItem menuItem = new MenuItem(menu, 8);
        if (collection instanceof IPopulation) {
            if (collection instanceof SimulationPopulation) {
                menuItem.setText("Browse simulations...");
                GamaMenu.separate((Menu)menu);
            } else {
                menuItem.setText("Browse " + ((IPopulation)collection).getName() + " population...");
            }
        } else {
            menuItem.setText("Browse agents...");
        }
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (collection instanceof SimulationPopulation) {
                    ValuedDisplayOutputFactory.browseSimulations((ExperimentAgent)((SimulationPopulation)collection).getHost());
                } else {
                    ValuedDisplayOutputFactory.browse((Collection)collection);
                }
            }
        });
        menuItem.setImage(image);
        return menuItem;
    }

    private static MenuItem cascadingPopulationMenuItem(Menu menu, IAgent iAgent, IPopulation<? extends IAgent> iPopulation, Image image, MenuAction ... menuActionArray) {
        if (iPopulation instanceof SimulationPopulation) {
            AgentsMenu.fillPopulationSubMenu(menu, iPopulation, menuActionArray);
            return null;
        }
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("Population of " + iPopulation.getName());
        menuItem.setImage(image);
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        AgentsMenu.fillPopulationSubMenu(menu2, iPopulation, menuActionArray);
        return menuItem;
    }

    private static MenuItem actionAgentMenuItem(Menu menu, IAgent iAgent, IStatement iStatement, String string) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(string + " " + iStatement.getName());
        menuItem.setImage(GamaIcon.named((String)"agents/agent.actions").image());
        menuItem.addSelectionListener((SelectionListener)runner);
        menuItem.setData("agent", (Object)iAgent);
        menuItem.setData("command", (Object)iStatement);
        return menuItem;
    }

    public AgentsMenu(String string) {
        super(string);
    }

    public AgentsMenu() {
    }

    public boolean isDynamic() {
        return true;
    }

    public static void createMenuForAgent(Menu menu, IAgent iAgent, boolean bl, boolean bl2, MenuAction ... menuActionArray) {
        IMacroAgent iMacroAgent;
        Collection collection;
        if (iAgent == null) {
            return;
        }
        GamaMenu.separate((Menu)menu, (String)"Actions");
        boolean bl3 = iAgent instanceof SimulationAgent;
        if (bl2) {
            AgentsMenu.actionAgentMenuItem(menu, iAgent, (SelectionListener)inspector, GamaIcon.named((String)"views/open.inspector").image(), "Inspect" + (bl ? (bl3 ? " simulation" : " experiment") : ""));
        }
        if (!bl) {
            AgentsMenu.actionAgentMenuItem(menu, iAgent, (SelectionListener)new Focuser(), GamaIcon.named((String)"agents/action.focus").image(), "Focus on all displays");
            AgentsMenu.actionAgentMenuItem(menu, iAgent, (SelectionListener)highlighter, GamaIcon.named((String)"agents/action.highlight").image(), iAgent.getScope().getGui().getHighlightedAgent() == iAgent ? "Remove highlight" : "Highlight on all displays");
        }
        if (menuActionArray != null && !bl) {
            MenuAction[] menuActionArray2 = menuActionArray;
            int n = menuActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                collection = menuActionArray2[n2];
                if (collection != null) {
                    AgentsMenu.actionAgentMenuItem(menu, iAgent, ((MenuAction)collection).listener, ((MenuAction)collection).image, ((MenuAction)collection).text);
                }
                ++n2;
            }
        }
        if (!(collection = iAgent.getSpecies().getUserCommands()).isEmpty()) {
            GamaMenu.separate((Menu)menu);
            for (UserCommandStatement userCommandStatement : collection) {
                AgentsMenu.actionAgentMenuItem(menu, iAgent, (IStatement)userCommandStatement, "Apply");
            }
        }
        if (!bl) {
            GamaMenu.separate((Menu)menu);
            AgentsMenu.actionAgentMenuItem(menu, iAgent, (SelectionListener)killer, GamaIcon.named((String)"agents/agent.kill").image(), "Kill");
        }
        if (iAgent instanceof IMacroAgent && (iMacroAgent = (IMacroAgent)iAgent).hasMembers()) {
            GamaMenu.separate((Menu)menu);
            if (!bl) {
                GamaMenu.separate((Menu)menu, (String)"Micro-populations");
            }
            IPopulation[] iPopulationArray = iMacroAgent.getMicroPopulations();
            int n = iPopulationArray.length;
            int n3 = 0;
            while (n3 < n) {
                IPopulation iPopulation = iPopulationArray[n3];
                if (!iPopulation.isEmpty()) {
                    AgentsMenu.cascadingPopulationMenuItem(menu, iAgent, (IPopulation<? extends IAgent>)iPopulation, GamaIcon.named((String)"agents/agents.submenu").image(), menuActionArray);
                }
                ++n3;
            }
        }
    }

    public static void fillPopulationSubMenu(Menu menu, Collection<? extends IAgent> collection, MenuAction ... menuActionArray) {
        boolean bl = collection instanceof SimulationPopulation;
        int n = Math.max(2, (Integer)GamaPreferences.Interface.CORE_MENU_SIZE.getValue());
        ArrayList<? extends IAgent> arrayList = new ArrayList<IAgent>(collection);
        int n2 = arrayList.size();
        if (n2 >= 1) {
            AgentsMenu.browsePopulationMenuItem(menu, collection, GamaIcon.named((String)"views/open.browser").image());
        }
        if (n2 >= 1 && !bl) {
            GamaMenu.separate((Menu)menu);
            GamaMenu.separate((Menu)menu, (String)"Agents");
        }
        if (n2 < n) {
            for (IAgent iAgent : arrayList) {
                if (iAgent == null) continue;
                AgentsMenu.cascadingAgentMenuItem(menu, iAgent, iAgent.getName(), menuActionArray);
            }
        } else {
            int n3;
            int n32 = n2 / n + 1;
            if (PlatformHelper.isWindows() && n32 > 90) {
                n3 = 90;
                n = n2 / n3;
            }
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4 * n;
                int n6 = Math.min((n4 + 1) * n, n2);
                if (n5 >= n6) break;
                try {
                    MenuItem sWTError = new MenuItem(menu, 64);
                    Menu menu2 = new Menu(sWTError);
                    sWTError.setMenu(menu2);
                    sWTError.setText("From " + ((IAgent)arrayList.get(n5)).getName() + " to " + ((IAgent)arrayList.get(n6 - 1)).getName());
                    sWTError.setImage(GamaIcon.named((String)"agents/agents.submenu").image());
                    menu2.addListener(22, event -> {
                        MenuItem[] menuItemArray;
                        if (!menu.isVisible()) {
                            return;
                        }
                        MenuItem[] menuItemArray2 = menuItemArray = menu2.getItems();
                        int n3 = menuItemArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            MenuItem menuItem = menuItemArray2[n4];
                            menuItem.dispose();
                            ++n4;
                        }
                        int n5 = n5;
                        while (n5 < n6) {
                            IAgent iAgent = (IAgent)arrayList.get(n5);
                            if (iAgent != null && !iAgent.dead()) {
                                AgentsMenu.cascadingAgentMenuItem(menu2, iAgent, iAgent.getName(), menuActionArray);
                            }
                            ++n5;
                        }
                    });
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 14) {
                        // empty if block
                    }
                }
                ++n4;
            }
        }
    }

    public static MenuAction getHighlightActionFor(IAgent iAgent) {
        if (iAgent == null) {
            return null;
        }
        return new MenuAction((SelectionListener)highlighter, GamaIcon.named((String)"agents/action.highlight").image(), iAgent.getScope().getGui().getHighlightedAgent() == iAgent ? "Remove highlight" : "Highlight");
    }

    public void fill(Menu menu, int n) {
        AgentsMenu.createMenuForAgent(menu, (IAgent)GAMA.getExperiment().getAgent(), true, true, new MenuAction[0]);
    }

    public static class Focuser
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.widget;
            IAgent iAgent = (IAgent)menuItem.getData("agent");
            if (iAgent != null && !iAgent.dead()) {
                GAMA.getGui().setFocusOn((IShape)iAgent);
            }
        }
    }
}

