/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.console;

import gama.core.common.interfaces.IGamaView;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.GamaViewPart;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsoleViewer;

public class ConsoleView
extends GamaViewPart
implements IToolbarDecoratedView.Sizable,
IToolbarDecoratedView.Pausable,
IToolbarDecoratedView.LogExportable,
IGamaView.Console {
    private final IOConsole msgConsole = new IOConsole("GAMA Console", null);
    IOConsoleViewer viewer;
    boolean paused = false;
    private final StringBuilder pauseBuffer = new StringBuilder((Integer)GamaPreferences.Interface.CORE_CONSOLE_BUFFER.getValue() == -1 ? 0 : (Integer)GamaPreferences.Interface.CORE_CONSOLE_BUFFER.getValue());
    private final HashMap<Color, BufferedWriter> writers = new HashMap();
    private boolean indicated = false;

    public void setCharacterLimit(int n) {
        if (n == -1) {
            this.msgConsole.setWaterMarks(-1, -1);
        } else {
            this.msgConsole.setWaterMarks(n, n * 2);
        }
    }

    public void ownCreatePartControl(Composite composite) {
        this.setCharacterLimit((Integer)GamaPreferences.Interface.CORE_CONSOLE_SIZE.getValue());
        GamaPreferences.Interface.CORE_CONSOLE_SIZE.onChange(this::setCharacterLimit);
        this.viewer = new IOConsoleViewer(composite, (TextConsole)this.msgConsole);
        this.viewer.setWordWrap(((Boolean)GamaPreferences.Interface.CORE_CONSOLE_WRAP.getValue()).booleanValue());
    }

    private BufferedWriter getWriterFor(ITopLevelAgent iTopLevelAgent, GamaColors.GamaUIColor gamaUIColor) {
        Color color = this.getColorFor(iTopLevelAgent, gamaUIColor);
        BufferedWriter bufferedWriter = this.writers.get(color);
        if (bufferedWriter == null) {
            IOConsoleOutputStream iOConsoleOutputStream = this.msgConsole.newOutputStream();
            iOConsoleOutputStream.setColor(color);
            iOConsoleOutputStream.setActivateOnWrite(false);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)iOConsoleOutputStream));
            this.writers.put(color, bufferedWriter);
        }
        return bufferedWriter;
    }

    private Color getColorFor(ITopLevelAgent iTopLevelAgent, GamaColors.GamaUIColor gamaUIColor) {
        GamaColors.GamaUIColor gamaUIColor2 = gamaUIColor == null ? (iTopLevelAgent == null ? IGamaColors.BLACK : GamaColors.get((java.awt.Color)iTopLevelAgent.getColor())) : gamaUIColor;
        return ThemeHelper.isDark() ? gamaUIColor2.lighter() : gamaUIColor2.color();
    }

    public void append(String string, ITopLevelAgent iTopLevelAgent, GamaColor gamaColor) {
        this.append(string, iTopLevelAgent, GamaColors.get((java.awt.Color)gamaColor));
    }

    public void append(String string, ITopLevelAgent iTopLevelAgent, GamaColors.GamaUIColor gamaUIColor) {
        if (!this.paused) {
            BufferedWriter bufferedWriter = this.getWriterFor(iTopLevelAgent, gamaUIColor);
            try {
                bufferedWriter.append(string);
                bufferedWriter.flush();
            }
            catch (IOException iOException) {}
        } else {
            int n = (Integer)GamaPreferences.Interface.CORE_CONSOLE_BUFFER.getValue();
            int n2 = (Integer)GamaPreferences.Interface.CORE_CONSOLE_SIZE.getValue();
            if (n2 > -1) {
                n = n == -1 ? n2 : Math.min(n, n2);
            }
            if (n > 0) {
                this.pauseBuffer.append(string);
                if (this.pauseBuffer.length() > n) {
                    this.pauseBuffer.delete(0, this.pauseBuffer.length() - n - 1);
                    this.pauseBuffer.insert(0, "(...)\n");
                }
            } else if (n == -1) {
                this.pauseBuffer.append(string);
            }
            if (!this.indicated) {
                WorkbenchHelper.run(() -> {
                    if (this.toolbar != null) {
                        this.toolbar.status(null, "New contents available", IGamaColors.BLUE, 16384);
                    }
                    this.indicated = true;
                });
            }
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.reset();
        super.widgetDisposed(disposeEvent);
    }

    public void close(IScope iScope) {
        this.reset();
        super.close(iScope);
    }

    public void reset() {
        this.writers.clear();
        this.msgConsole.clearConsole();
        this.pauseBuffer.setLength(0);
    }

    public Control getSizableFontControl() {
        if (this.viewer == null) {
            return null;
        }
        return this.viewer.getTextWidget();
    }

    public void pauseChanged() {
        if (this.paused) {
            WorkbenchHelper.asyncRun(() -> {
                if (this.toolbar != null) {
                    this.toolbar.wipe(16384, true);
                }
                this.indicated = false;
            });
        }
        boolean bl = this.paused = !this.paused;
        if (this.paused) {
            this.pauseBuffer.setLength(0);
        } else {
            this.append(this.pauseBuffer.toString(), (ITopLevelAgent)null, (GamaColors.GamaUIColor)null);
        }
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        super.createToolItems(gamaToolbar2);
        gamaToolbar2.sep(4, 131072);
        gamaToolbar2.button("viewers/erase.contents", "Clear", "Clear the console", selectionEvent -> this.reset(), 131072);
    }

    protected GamaViewPart.GamaUIJob createUpdateJob() {
        return null;
    }

    protected boolean shouldBeClosedWhenNoExperiments() {
        return false;
    }

    protected boolean needsOutput() {
        return false;
    }

    public String getContents() {
        return this.viewer.getDocument().get();
    }
}

