/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.controls;

import gama.core.common.ErrorStatusMessage;
import gama.core.common.StatusMessage;
import gama.core.common.SubTaskMessage;
import gama.core.common.UserStatusMessage;
import gama.core.common.interfaces.IStatusMessage;
import gama.core.common.interfaces.IUpdaterTarget;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.root.PlatformAgent;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationClock;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.runtime.GAMA;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.dev.DEBUG;
import gama.gaml.operators.Strings;
import gama.ui.experiment.controls.ErrorPopUpMenu;
import gama.ui.experiment.controls.SimulationPopupMenu;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Color;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class StatusControlContribution
extends WorkbenchWindowControlContribution
implements IUpdaterTarget<IStatusMessage> {
    GamaRuntimeException currentException;
    private volatile boolean isUpdating;
    private FlatButton label;
    private SimulationPopupMenu popup;
    private ErrorPopUpMenu errorPopup;
    private int state;
    private volatile String mainTaskName;
    private volatile String subTaskName;
    private volatile boolean inSubTask = false;
    private volatile boolean inUserStatus = false;
    private volatile Double subTaskCompletion;
    private static final int WIDTH = 400;
    private GamaColors.GamaUIColor color;
    private final StringBuilder text = new StringBuilder(2000);
    static StatusControlContribution INSTANCE;

    static {
        DEBUG.ON();
    }

    public static StatusControlContribution getInstance() {
        return INSTANCE;
    }

    public StatusControlContribution() {
        INSTANCE = this;
    }

    public StatusControlContribution(String string) {
        super(string);
        INSTANCE = this;
    }

    protected int computeWidth(Control control) {
        return 400;
    }

    public boolean isBusy() {
        return this.isUpdating;
    }

    protected Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0x20000000);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(composite2);
        this.label = FlatButton.label((Composite)composite2, (GamaColors.GamaUIColor)IGamaColors.NEUTRAL, (String)"No experiment running", (int)400).setImage(GamaIcon.named((String)"overlays/status.clock").image());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).hint(400, 24).applyTo((Control)this.label);
        this.popup = new SimulationPopupMenu(this);
        this.errorPopup = new ErrorPopUpMenu(this);
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (StatusControlContribution.this.state == 0) {
                    if (StatusControlContribution.this.errorPopup.isVisible()) {
                        StatusControlContribution.this.errorPopup.hide();
                    } else {
                        WorkbenchHelper.asyncRun(() -> StatusControlContribution.this.errorPopup.display(StatusControlContribution.this.currentException));
                    }
                    return;
                }
                if (StatusControlContribution.this.popup.isVisible()) {
                    StatusControlContribution.this.popup.hide();
                } else {
                    ITopLevelAgent iTopLevelAgent = GAMA.getCurrentTopLevelAgent();
                    if (!(StatusControlContribution.this.state == 0 || StatusControlContribution.this.state == 1 || iTopLevelAgent == null || iTopLevelAgent.dead() || iTopLevelAgent.getScope().isClosed() || iTopLevelAgent.getExperiment() == null || iTopLevelAgent instanceof PlatformAgent)) {
                        WorkbenchHelper.asyncRun(StatusControlContribution.this.popup::display);
                    }
                }
            }
        });
        return composite2;
    }

    public boolean isDisposed() {
        return this.label.isDisposed();
    }

    public void setSelection(ITopLevelAgent iTopLevelAgent) {
        if (iTopLevelAgent instanceof IExperimentAgent) {
            IExperimentAgent iExperimentAgent = (IExperimentAgent)iTopLevelAgent;
            GAMA.changeCurrentTopLevelAgent((ITopLevelAgent)iExperimentAgent, (boolean)false);
        } else if (iTopLevelAgent instanceof SimulationAgent) {
            SimulationAgent simulationAgent = (SimulationAgent)iTopLevelAgent;
            GAMA.getExperiment().getAgent().setCurrentSimulation(simulationAgent);
        }
    }

    String popupTextFor(ITopLevelAgent iTopLevelAgent) {
        if (iTopLevelAgent == null) {
            return "";
        }
        this.text.setLength(0);
        SimulationClock simulationClock = iTopLevelAgent.getClock();
        simulationClock.getInfo(this.text).append(Strings.LN);
        this.text.append("Durations: cycle ").append(simulationClock.getDuration()).append("ms; average ").append((int)simulationClock.getAverageDuration()).append("ms; total ").append(simulationClock.getTotalDuration()).append("ms");
        return this.text.toString();
    }

    public Shell getControllingShell() {
        return this.label.getShell();
    }

    public Point getLocation() {
        return this.label.toDisplay(this.label.getLocation());
    }

    public int getWidth() {
        return this.label.getSize().x;
    }

    public int getHeight() {
        return this.label.getSize().y;
    }

    public void updateWith(IStatusMessage iStatusMessage) {
        if (this.isUpdating) {
            return;
        }
        this.prepareForUpdate();
        IStatusMessage.StatusMessageType statusMessageType = iStatusMessage.getType();
        switch (statusMessageType) {
            case ERROR: {
                this.processErrorStatusMessage((ErrorStatusMessage)iStatusMessage);
                break;
            }
            case USER: {
                this.processUserStatusMessage((UserStatusMessage)iStatusMessage);
                break;
            }
            case STATUS: {
                if (this.inUserStatus) {
                    return;
                }
                this.processStatusMessage((StatusMessage)iStatusMessage);
                break;
            }
            case SUBTASK: {
                if (this.inUserStatus) {
                    return;
                }
                this.processSubTaskMessage((SubTaskMessage)iStatusMessage);
            }
        }
        this.label.setImageWithoutRecomputingSize(iStatusMessage.getIcon() == null ? null : GamaIcon.named((String)iStatusMessage.getIcon()).image());
        this.label.setColor(this.getLabelBackground());
        this.label.setTextWithoutRecomputingSize(this.getLabelText());
        if (this.popup.isVisible()) {
            this.popup.display();
        }
        this.isUpdating = false;
        this.inUserStatus = false;
    }

    private String getSubTaskMessage() {
        return this.subTaskName + (String)(this.subTaskCompletion != null ? " [" + (int)(this.subTaskCompletion * 100.0) + "%]" : "");
    }

    private String getLabelText() {
        return this.inSubTask ? this.getSubTaskMessage() : (this.mainTaskName == null ? this.getClockMessage() : this.mainTaskName);
    }

    public GamaColors.GamaUIColor getLabelBackground() {
        if (this.inUserStatus) {
            if (this.color != null) {
                return this.color;
            }
        } else if (!this.inSubTask && this.mainTaskName == null) {
            return GamaColors.get((Color)GAMA.getCurrentTopLevelAgent().getColor());
        }
        return this.state == 0 ? IGamaColors.ERROR : (this.state == 1 ? IGamaColors.WARNING : (this.state == 3 ? IGamaColors.NEUTRAL : IGamaColors.OK));
    }

    private void processErrorStatusMessage(ErrorStatusMessage errorStatusMessage) {
        this.inSubTask = false;
        this.state = 0;
        this.mainTaskName = "Error in previous experiment";
        this.currentException = errorStatusMessage.getException();
    }

    private void processStatusMessage(StatusMessage statusMessage) {
        this.inSubTask = false;
        this.mainTaskName = statusMessage.getText();
        this.state = statusMessage.getCode();
    }

    private void processUserStatusMessage(UserStatusMessage userStatusMessage) {
        String string = userStatusMessage.getText();
        if (string == null) {
            this.resume();
        } else {
            this.inSubTask = false;
            this.inUserStatus = true;
            GamaColor gamaColor = userStatusMessage.getColor();
            if (gamaColor == null) {
                this.color = null;
                this.state = 3;
            } else {
                this.color = GamaColors.get((Color)gamaColor);
            }
            this.mainTaskName = userStatusMessage.getText();
        }
    }

    private void processSubTaskMessage(SubTaskMessage subTaskMessage) {
        Boolean bl = subTaskMessage.getBeginOrEnd();
        if (bl == null) {
            this.subTaskCompletion = subTaskMessage.getCompletion();
        } else {
            if (bl.booleanValue()) {
                this.subTaskName = subTaskMessage.getText();
                this.inSubTask = true;
            } else {
                this.inSubTask = false;
            }
            this.subTaskCompletion = null;
        }
    }

    private void prepareForUpdate() {
        this.currentException = null;
        if (GAMA.getExperiment() == null) {
            this.label.removeMenuSign();
            this.popup.wipe();
            if (this.popup.isVisible()) {
                this.popup.hide();
            }
        } else {
            this.label.addMenuSign();
        }
        this.isUpdating = true;
    }

    private String getClockMessage() {
        int n;
        ITopLevelAgent iTopLevelAgent = GAMA.getCurrentTopLevelAgent();
        if (iTopLevelAgent == null) {
            return "";
        }
        if (iTopLevelAgent instanceof PlatformAgent) {
            return "No experiment running";
        }
        IExperimentAgent iExperimentAgent = iTopLevelAgent.getExperiment();
        if (iExperimentAgent == null) {
            return "";
        }
        this.text.setLength(0);
        iTopLevelAgent.getClock().getInfo(this.text);
        SimulationPopulation simulationPopulation = iExperimentAgent.getSimulationPopulation();
        int n2 = n = simulationPopulation == null ? 1 : simulationPopulation.getNumberOfActiveThreads();
        if (iTopLevelAgent.getScope().isOnUserHold()) {
            this.text.append(" (waiting)");
        } else if (n > 1) {
            this.text.append(" (" + n + " threads)");
        }
        IExperimentPlan iExperimentPlan = iExperimentAgent.getSpecies();
        if (iExperimentPlan.shouldBeBenchmarked()) {
            this.text.append(" [benchmarking]");
        }
        return this.text.toString();
    }

    public void resume() {
        this.inUserStatus = false;
        this.color = null;
        this.mainTaskName = null;
    }
}

