/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.menus;

import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.outputs.IOutput;
import gama.core.outputs.IOutputManager;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.resources.GamaIcon;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class OutputsMenu
extends ContributionItem {
    public OutputsMenu() {
        super("gama.ui.shared.experiment.outputs.menu");
    }

    public void fill(Menu menu, int n) {
        IExperimentPlan iExperimentPlan = GAMA.getExperiment();
        if (iExperimentPlan == null) {
            return;
        }
        ExperimentAgent experimentAgent = iExperimentPlan.getAgent();
        if (experimentAgent == null) {
            return;
        }
        for (SimulationAgent simulationAgent : experimentAgent.getSimulationPopulation()) {
            this.managementSubMenu(menu, simulationAgent.getScope(), (IOutputManager)simulationAgent.getOutputManager());
        }
        GamaMenu.separate((Menu)menu);
        OutputsMenu.menuItem(menu, selectionEvent -> GAMA.getExperiment().pauseAllOutputs(), GamaIcon.named((String)"display/action.pause").image(), "Pause all");
        OutputsMenu.menuItem(menu, selectionEvent -> GAMA.getExperiment().refreshAllOutputs(), GamaIcon.named((String)"display/action.update").image(), "Update all");
        OutputsMenu.menuItem(menu, selectionEvent -> GAMA.getExperiment().resumeAllOutputs(), GamaIcon.named((String)"display/action.pause").disabled(), "Resume all");
        OutputsMenu.menuItem(menu, selectionEvent -> GAMA.synchronizeFrontmostExperiment(), GamaIcon.named((String)"experiment/experiment.sync").image(), "Synchronize all");
        OutputsMenu.menuItem(menu, selectionEvent -> GAMA.desynchronizeFrontmostExperiment(), GamaIcon.named((String)"experiment/experiment.sync").disabled(), "Desynchronize all");
    }

    public void managementSubMenu(Menu menu, IScope iScope, IOutputManager iOutputManager) {
        if (iOutputManager.isEmpty()) {
            return;
        }
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(iOutputManager.toString());
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        iOutputManager.forEach(iOutput -> this.outputSubMenu(menu2, iScope, iOutputManager, (IOutput)iOutput));
    }

    public void outputSubMenu(Menu menu, IScope iScope, IOutputManager iOutputManager, IOutput iOutput) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText(iOutput.getOriginalName());
        Menu menu2 = new Menu(menuItem);
        menuItem.setMenu(menu2);
        if (iOutput.isOpen()) {
            if (iOutput.isPaused()) {
                OutputsMenu.menuItem(menu2, selectionEvent -> iOutput.setPaused(false), null, "Resume");
            } else {
                OutputsMenu.menuItem(menu2, selectionEvent -> iOutput.setPaused(true), GamaIcon.named((String)"display/action.pause").image(), "Pause");
            }
            OutputsMenu.menuItem(menu2, selectionEvent -> iOutput.update(), GamaIcon.named((String)"display/action.update").image(), "Force update");
            if (iOutput instanceof LayeredDisplayOutput) {
                LayeredDisplayOutput layeredDisplayOutput = (LayeredDisplayOutput)iOutput;
                GamaMenu.separate((Menu)menu2);
                OutputsMenu.menuItem(menu2, selectionEvent -> layeredDisplayOutput.zoom(1), GamaIcon.named((String)"display/zoom.in").image(), "Zoom in");
                OutputsMenu.menuItem(menu2, selectionEvent -> layeredDisplayOutput.zoom(0), GamaIcon.named((String)"display/zoom.fit").image(), "Zoom to fit view");
                OutputsMenu.menuItem(menu2, selectionEvent -> layeredDisplayOutput.zoom(-1), GamaIcon.named((String)"display/zoom.out").image(), "Zoom out");
                GamaMenu.separate((Menu)menu2);
                OutputsMenu.menuItem(menu2, selectionEvent -> layeredDisplayOutput.getView().takeSnapshot(null), GamaIcon.named((String)"display/action.snapshot").image(), "Take a snapshot");
                OutputsMenu.menuItem(menu2, selectionEvent -> layeredDisplayOutput.getView().toggleFullScreen(), GamaIcon.named((String)"display/fullscreen.enter").image(), "Toggle fullscreen");
            }
        } else {
            OutputsMenu.menuItem(menu2, selectionEvent -> {
                boolean bl = iOutputManager.open(iScope, iOutput);
            }, null, "Reopen");
        }
    }

    public boolean isDynamic() {
        return true;
    }

    private static MenuItem menuItem(Menu menu, ISelecter iSelecter, Image image, String string) {
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(string);
        if (iSelecter != null) {
            menuItem.addSelectionListener((SelectionListener)iSelecter);
        }
        if (image != null) {
            menuItem.setImage(image);
        }
        return menuItem;
    }

    @FunctionalInterface
    private static interface ISelecter
    extends SelectionListener {
        default public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }
    }
}

